/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.ServletResponseWrapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.servlet.DispatchTargetsInfo;
import org.glassfish.grizzly.servlet.DispatchedHttpServletRequest;
import org.glassfish.grizzly.servlet.DispatchedHttpServletResponse;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import org.glassfish.grizzly.servlet.ServletHandler;

final class ApplicationDispatcher
implements RequestDispatcher {
    public static final String LAST_DISPATCH_REQUEST_PATH_ATTR = "org.apache.catalina.core.ApplicationDispatcher.lastDispatchRequestPathAttr";
    private static final Logger LOGGER = Grizzly.logger(ApplicationDispatcher.class);
    private Boolean crossContextFlag = null;
    private String name = null;
    private String pathInfo = null;
    private String queryString = null;
    private String requestURI = null;
    private String servletPath = null;
    private ServletHandler wrapper = null;

    public ApplicationDispatcher(ServletHandler wrapper, String requestURI, String servletPath, String pathInfo, String queryString, String name) {
        this.wrapper = wrapper;
        this.requestURI = requestURI;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.name = name;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "servletPath={0}, pathInfo={1}, queryString={2}, name={3}", new Object[]{this.servletPath, this.pathInfo, queryString, this.name});
        }
    }

    @Override
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response, DispatcherType.FORWARD);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) throws ServletException, IOException {
        boolean isCommit;
        if (!(DispatcherType.FORWARD.equals((Object)dispatcherType) || DispatcherType.ERROR.equals((Object)dispatcherType) || DispatcherType.ASYNC.equals((Object)dispatcherType))) {
            throw new IllegalArgumentException("Illegal dispatcher type");
        }
        boolean bl = isCommit = DispatcherType.FORWARD.equals((Object)dispatcherType) || DispatcherType.ERROR.equals((Object)dispatcherType);
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedDispatch dp = new PrivilegedDispatch(request, response, dispatcherType);
                AccessController.doPrivileged(dp);
                if (!isCommit || request.isAsyncStarted()) return;
                ApplicationDispatcher.closeResponse(response);
                return;
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (!(e instanceof ServletException)) throw (IOException)e;
                throw (ServletException)e;
            }
        } else {
            this.doDispatch(request, response, dispatcherType);
            if (!isCommit || request.isAsyncStarted()) return;
            ApplicationDispatcher.closeResponse(response);
        }
    }

    private void doDispatch(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) throws ServletException, IOException {
        if (!DispatcherType.ASYNC.equals((Object)dispatcherType)) {
            if (response.isCommitted()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("  Forward on committed response --> ISE");
                }
                throw new IllegalStateException("Cannot forward after response has been committed");
            }
            try {
                response.resetBuffer();
            }
            catch (IllegalStateException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Forward resetBuffer() returned ISE: {0}", e);
                }
                throw e;
            }
        }
        if (DispatcherType.INCLUDE != dispatcherType) {
            DispatchTargetsInfo dtInfo = (DispatchTargetsInfo)request.getAttribute(LAST_DISPATCH_REQUEST_PATH_ATTR);
            if (dtInfo == null) {
                dtInfo = new DispatchTargetsInfo();
                request.setAttribute(LAST_DISPATCH_REQUEST_PATH_ATTR, dtInfo);
            }
            if (this.servletPath == null && this.pathInfo == null) {
                dtInfo.addDispatchTarget(this.wrapper.getName(), true);
            } else {
                dtInfo.addDispatchTarget(this.getCombinedPath(), false);
            }
        }
        State state = new State(request, response, dispatcherType);
        ServletRequest sr = this.wrapRequest(state);
        this.wrapResponse(state);
        HttpServletRequest hrequest = state.hrequest;
        HttpServletResponse hresponse = state.hresponse;
        if (hrequest == null || hresponse == null) {
            this.processRequest(request, response, state);
        } else if (this.servletPath == null && this.pathInfo == null) {
            DispatchedHttpServletRequest wrequest = (DispatchedHttpServletRequest)sr;
            wrequest.setRequestURI(hrequest.getRequestURI());
            wrequest.setContextPath(hrequest.getContextPath());
            wrequest.setServletPath(hrequest.getServletPath());
            wrequest.setPathInfo(hrequest.getPathInfo());
            wrequest.setQueryString(hrequest.getQueryString());
            this.processRequest(request, response, state);
        } else {
            DispatchedHttpServletRequest wrequest = (DispatchedHttpServletRequest)sr;
            if (DispatcherType.FORWARD.equals((Object)dispatcherType) && hrequest.getAttribute("jakarta.servlet.forward.request_uri") == null || DispatcherType.ASYNC.equals((Object)dispatcherType) && hrequest.getAttribute("jakarta.servlet.async.request_uri") == null) {
                wrequest.initSpecialAttributes(hrequest.getRequestURI(), hrequest.getContextPath(), hrequest.getServletPath(), hrequest.getPathInfo(), hrequest.getQueryString());
            }
            String targetContextPath = this.wrapper.getContextPath();
            HttpServletRequestImpl requestFacade = wrequest.getRequestFacade();
            String originContextPath = requestFacade.getContextPath();
            if (originContextPath != null && originContextPath.equals(targetContextPath)) {
                targetContextPath = hrequest.getContextPath();
            }
            wrequest.setContextPath(targetContextPath);
            wrequest.setRequestURI(this.requestURI);
            wrequest.setServletPath(this.servletPath);
            wrequest.setPathInfo(this.pathInfo);
            if (this.queryString != null) {
                wrequest.setQueryString(this.queryString);
                wrequest.setQueryParams(this.queryString);
            }
            this.processRequest(request, response, state);
        }
        this.recycleRequestWrapper(state);
        this.unwrapRequest(state);
        this.unwrapResponse(state);
    }

    private void processRequest(ServletRequest request, ServletResponse response, State state) throws IOException, ServletException {
        if (request != null) {
            if (state.dispatcherType != DispatcherType.ERROR) {
                state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
                this.invoke(state.outerRequest, response, state);
            } else {
                this.invoke(state.outerRequest, response, state);
            }
        }
    }

    private String getCombinedPath() {
        if (this.servletPath == null) {
            return null;
        }
        if (this.pathInfo == null) {
            return this.servletPath;
        }
        return this.servletPath + this.pathInfo;
    }

    @Override
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedInclude dp = new PrivilegedInclude(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                throw (IOException)e;
            }
        } else {
            this.doInclude(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInclude(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        State state = new State(request, response, DispatcherType.INCLUDE);
        this.wrapResponse(state);
        if (this.name != null) {
            DispatchedHttpServletRequest wrequest = (DispatchedHttpServletRequest)this.wrapRequest(state);
            wrequest.setAttribute("org.apache.catalina.NAMED", this.name);
            if (this.servletPath != null) {
                wrequest.setServletPath(this.servletPath);
            }
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
            try {
                this.invoke(state.outerRequest, state.outerResponse, state);
            }
            finally {
                this.recycleRequestWrapper(state);
                this.unwrapRequest(state);
                this.unwrapResponse(state);
            }
        }
        DispatchedHttpServletRequest wrequest = (DispatchedHttpServletRequest)this.wrapRequest(state);
        wrequest.initSpecialAttributes(this.requestURI, this.wrapper.getContextPath(), this.servletPath, this.pathInfo, this.queryString);
        wrequest.setQueryParams(this.queryString);
        wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
        try {
            this.invoke(state.outerRequest, state.outerResponse, state);
        }
        finally {
            this.recycleRequestWrapper(state);
            this.unwrapRequest(state);
            this.unwrapResponse(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(ServletRequest request, ServletResponse response, State state) throws IOException, ServletException {
        boolean crossContext = false;
        if (this.crossContextFlag != null && this.crossContextFlag.booleanValue()) {
            crossContext = true;
        }
        try {
            this.doInvoke(request, response, crossContext, state);
        }
        finally {
            this.crossContextFlag = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInvoke(ServletRequest request, ServletResponse response, boolean crossContext, State state) throws IOException, ServletException {
        ClassLoader oldCCL = null;
        try {
            ClassLoader contextClassLoader;
            if (crossContext && (contextClassLoader = this.wrapper.getClassLoader()) != null) {
                oldCCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            this.wrapper.doServletService(request, response, state.dispatcherType);
            if (oldCCL != null) {
                Thread.currentThread().setContextClassLoader(oldCCL);
            }
        }
        catch (Throwable throwable) {
            if (oldCCL != null) {
                Thread.currentThread().setContextClassLoader(oldCCL);
            }
            throw throwable;
        }
    }

    private void unwrapRequest(State state) {
        if (state.wrapRequest == null) {
            return;
        }
        ServletRequest previous = null;
        ServletRequest current = state.outerRequest;
        while (current != null && !(current instanceof HttpServletRequestImpl)) {
            if (current == state.wrapRequest) {
                ServletRequest next = ((ServletRequestWrapper)current).getRequest();
                if (previous == null) {
                    state.outerRequest = next;
                    break;
                }
                ((ServletRequestWrapper)previous).setRequest(next);
                break;
            }
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
    }

    private void unwrapResponse(State state) {
        if (state.wrapResponse == null) {
            return;
        }
        ServletResponse previous = null;
        ServletResponse current = state.outerResponse;
        while (current != null && !(current instanceof HttpServletResponseImpl)) {
            if (current == state.wrapResponse) {
                ServletResponse next = ((ServletResponseWrapper)current).getResponse();
                if (previous == null) {
                    state.outerResponse = next;
                    break;
                }
                ((ServletResponseWrapper)previous).setResponse(next);
                break;
            }
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
    }

    private ServletRequest wrapRequest(State state) {
        ServletRequest previous = null;
        ServletRequest current = state.outerRequest;
        while (current != null) {
            if (state.hrequest == null && current instanceof HttpServletRequest) {
                state.hrequest = (HttpServletRequest)current;
            }
            if (!(current instanceof ServletRequestWrapper) || current instanceof DispatchedHttpServletRequest) break;
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
        if (current == null) {
            throw new IllegalStateException("Can't retrieve container request from " + state.outerRequest);
        }
        HttpServletRequest hcurrent = (HttpServletRequest)current;
        boolean crossContext = false;
        if (state.outerRequest instanceof DispatchedHttpServletRequest || state.outerRequest instanceof HttpServletRequest) {
            HttpServletRequest houterRequest = (HttpServletRequest)state.outerRequest;
            Object contextPath = houterRequest.getAttribute("jakarta.servlet.include.context_path");
            if (contextPath == null) {
                contextPath = houterRequest.getContextPath();
            }
            crossContext = !this.wrapper.getContextPath().equals(contextPath);
        }
        this.crossContextFlag = crossContext;
        DispatchedHttpServletRequest wrapperLocal = new DispatchedHttpServletRequest(hcurrent, this.wrapper.getServletCtx(), crossContext, state.dispatcherType);
        if (previous == null) {
            state.outerRequest = wrapperLocal;
        } else {
            ((ServletRequestWrapper)previous).setRequest(wrapperLocal);
        }
        state.wrapRequest = wrapperLocal;
        return wrapperLocal;
    }

    private ServletResponse wrapResponse(State state) {
        ServletResponse previous = null;
        ServletResponse current = state.outerResponse;
        while (current != null) {
            if (state.hresponse == null && current instanceof HttpServletResponse) {
                state.hresponse = (HttpServletResponse)current;
                if (DispatcherType.INCLUDE != state.dispatcherType) {
                    return null;
                }
            }
            if (!(current instanceof ServletResponseWrapper) || current instanceof DispatchedHttpServletResponse) break;
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
        HttpServletResponse hcurrent = (HttpServletResponse)current;
        DispatchedHttpServletResponse wrapperLocal = new DispatchedHttpServletResponse(hcurrent, DispatcherType.INCLUDE.equals((Object)state.dispatcherType));
        if (previous == null) {
            state.outerResponse = wrapperLocal;
        } else {
            ((ServletResponseWrapper)previous).setResponse(wrapperLocal);
        }
        state.wrapResponse = wrapperLocal;
        return wrapperLocal;
    }

    private static void closeResponse(ServletResponse response) {
        try {
            PrintWriter writer = response.getWriter();
            writer.flush();
            writer.close();
        }
        catch (IllegalStateException e) {
            try {
                ServletOutputStream stream = response.getOutputStream();
                stream.flush();
                stream.close();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void recycleRequestWrapper(State state) {
        if (state.wrapRequest instanceof DispatchedHttpServletRequest) {
            ((DispatchedHttpServletRequest)state.wrapRequest).recycle();
        }
    }

    private class PrivilegedDispatch
    implements PrivilegedExceptionAction<Void> {
        private final ServletRequest request;
        private final ServletResponse response;
        private final DispatcherType dispatcherType;

        PrivilegedDispatch(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) {
            this.request = request;
            this.response = response;
            this.dispatcherType = dispatcherType;
        }

        @Override
        public Void run() throws Exception {
            ApplicationDispatcher.this.doDispatch(this.request, this.response, this.dispatcherType);
            return null;
        }
    }

    private static class State {
        ServletRequest outerRequest = null;
        ServletResponse outerResponse = null;
        ServletRequest wrapRequest = null;
        ServletResponse wrapResponse = null;
        final DispatcherType dispatcherType;
        HttpServletRequest hrequest = null;
        HttpServletResponse hresponse = null;

        State(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) {
            this.outerRequest = request;
            this.outerResponse = response;
            this.dispatcherType = dispatcherType;
        }
    }

    private class PrivilegedInclude
    implements PrivilegedExceptionAction<Void> {
        private final ServletRequest request;
        private final ServletResponse response;

        PrivilegedInclude(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        @Override
        public Void run() throws ServletException, IOException {
            ApplicationDispatcher.this.doInclude(this.request, this.response);
            return null;
        }
    }
}

