/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRequest;
import java.util.List;
import java.util.Map;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.servlet.FilterChainImpl;
import org.glassfish.grizzly.servlet.FilterMap;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.WebappContext;

public class FilterChainFactory {
    private final WebappContext ctx;

    public FilterChainFactory(WebappContext ctx) {
        this.ctx = ctx;
    }

    public FilterChainImpl createFilterChain(ServletRequest request, Servlet servlet, DispatcherType dispatcherType) {
        return this.buildFilterChain(servlet, this.getRequestPath(request), dispatcherType);
    }

    public FilterChainImpl createFilterChain(Request request, Servlet servlet, DispatcherType dispatcherType) {
        return this.buildFilterChain(servlet, this.getRequestPath(request), dispatcherType);
    }

    private FilterChainImpl buildFilterChain(Servlet servlet, String requestPath, DispatcherType dispatcherType) {
        if (servlet == null) {
            return null;
        }
        FilterChainImpl filterChain = new FilterChainImpl(servlet, this.ctx);
        Map<String, ? extends FilterRegistration> registrations = this.ctx.getFilterRegistrations();
        if (registrations.isEmpty()) {
            return filterChain;
        }
        List<FilterMap> filterMaps = this.ctx.getFilterMaps();
        for (FilterMap filterMap : filterMaps) {
            if (!filterMap.getDispatcherTypes().contains((Object)dispatcherType) || !this.matchFiltersURL(filterMap, requestPath)) continue;
            filterChain.addFilter(registrations.get(filterMap.getFilterName()));
        }
        String servletName = servlet.getServletConfig().getServletName();
        for (FilterMap filterMap : filterMaps) {
            if (!filterMap.getDispatcherTypes().contains((Object)dispatcherType) || !this.matchFiltersServlet(filterMap, servletName)) continue;
            filterChain.addFilter(registrations.get(filterMap.getFilterName()));
        }
        return filterChain;
    }

    private String getRequestPath(ServletRequest request) {
        String requestPath = null;
        Object attribute = request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        if (attribute != null) {
            requestPath = attribute.toString();
        }
        return requestPath;
    }

    private String getRequestPath(Request request) {
        String requestPath = null;
        Object attribute = request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        if (attribute != null) {
            requestPath = attribute.toString();
        }
        return requestPath;
    }

    private boolean matchFiltersURL(FilterMap filterMap, String requestPath) {
        if (requestPath == null) {
            return false;
        }
        String testPath = filterMap.getURLPattern();
        if (testPath == null) {
            return false;
        }
        if (testPath.equals(requestPath)) {
            return true;
        }
        if (testPath.equals("/*")) {
            return true;
        }
        if (testPath.endsWith("/*")) {
            if (testPath.regionMatches(0, requestPath, 0, testPath.length() - 2)) {
                if (requestPath.length() == testPath.length() - 2) {
                    return true;
                }
                if ('/' == requestPath.charAt(testPath.length() - 2)) {
                    return true;
                }
            }
            return false;
        }
        if (testPath.startsWith("*.")) {
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            if (slash >= 0 && period > slash && period != requestPath.length() - 1 && requestPath.length() - period == testPath.length() - 1) {
                return testPath.regionMatches(2, requestPath, period + 1, testPath.length() - 2);
            }
        }
        return false;
    }

    private boolean matchFiltersServlet(FilterMap filterMap, String servletName) {
        if (servletName == null) {
            return false;
        }
        return servletName.equals(filterMap.getServletName()) || "*".equals(filterMap.getServletName());
    }
}

