/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;

public final class TaskQueue<E> {
    private volatile boolean isClosed;
    private final Queue<E> queue;
    private final AtomicReference<E> currentElement;
    private final AtomicInteger spaceInBytes = new AtomicInteger();
    private final AtomicInteger refusedBytes = new AtomicInteger();
    private final MutableMaxQueueSize maxQueueSizeHolder;
    private final AtomicInteger writeHandlersCounter = new AtomicInteger();
    protected final Queue<WriteHandler> writeHandlersQueue = new ConcurrentLinkedQueue<WriteHandler>();

    protected TaskQueue(MutableMaxQueueSize maxQueueSizeHolder) {
        this.maxQueueSizeHolder = maxQueueSizeHolder;
        this.currentElement = new AtomicReference();
        this.queue = new ConcurrentLinkedQueue();
    }

    public static <E> TaskQueue<E> createTaskQueue(MutableMaxQueueSize maxQueueSizeHolder) {
        return new TaskQueue<E>(maxQueueSizeHolder);
    }

    public int size() {
        return this.spaceInBytes.get();
    }

    public E poll() {
        E current = this.currentElement.getAndSet(null);
        return current != null ? current : (E)this.queue.poll();
    }

    public int reserveSpace(int amount) {
        return this.spaceInBytes.addAndGet(amount);
    }

    public int releaseSpace(int amount) {
        return this.spaceInBytes.addAndGet(-amount);
    }

    public int releaseSpaceAndNotify(int amount) {
        int space = this.releaseSpace(amount);
        this.doNotify();
        return space;
    }

    public int spaceInBytes() {
        return this.spaceInBytes.get();
    }

    public E obtainCurrentElement() {
        E current = this.currentElement.get();
        return current != null ? current : this.queue.poll();
    }

    public E obtainCurrentElementAndReserve() {
        E current = this.currentElement.getAndSet(null);
        return current != null ? current : (E)this.queue.poll();
    }

    public Queue<E> getQueue() {
        return this.queue;
    }

    public void notifyWritePossible(WriteHandler writeHandler) {
        this.notifyWritePossible(writeHandler, this.maxQueueSizeHolder.getMaxQueueSize());
    }

    public void notifyWritePossible(WriteHandler writeHandler, int maxQueueSize) {
        if (writeHandler == null) {
            return;
        }
        if (this.isClosed) {
            writeHandler.onError(new IOException("Connection is closed"));
            return;
        }
        if (maxQueueSize < 0 || this.spaceInBytes() < maxQueueSize) {
            try {
                writeHandler.onWritePossible();
            }
            catch (Throwable e) {
                writeHandler.onError(e);
            }
            return;
        }
        this.offerWriteHandler(writeHandler);
        if (this.spaceInBytes() < maxQueueSize && this.removeWriteHandler(writeHandler)) {
            try {
                writeHandler.onWritePossible();
            }
            catch (Throwable e) {
                writeHandler.onError(e);
            }
        } else {
            this.checkWriteHandlerOnClose(writeHandler);
        }
    }

    public final boolean forgetWritePossible(WriteHandler writeHandler) {
        return this.removeWriteHandler(writeHandler);
    }

    private void checkWriteHandlerOnClose(WriteHandler writeHandler) {
        if (this.isClosed && this.removeWriteHandler(writeHandler)) {
            writeHandler.onError(new IOException("Connection is closed"));
        }
    }

    public void doNotify() {
        if (this.maxQueueSizeHolder == null || this.writeHandlersCounter.get() == 0) {
            return;
        }
        int maxQueueSize = this.maxQueueSizeHolder.getMaxQueueSize();
        while (this.spaceInBytes() <= maxQueueSize) {
            WriteHandler writeHandler = this.pollWriteHandler();
            if (writeHandler == null) {
                return;
            }
            try {
                writeHandler.onWritePossible();
            }
            catch (Throwable e) {
                writeHandler.onError(e);
            }
        }
    }

    public void setCurrentElement(E task) {
        this.currentElement.set(task);
    }

    public boolean compareAndSetCurrentElement(E expected, E newValue) {
        return this.currentElement.compareAndSet(expected, newValue);
    }

    public boolean remove(E task) {
        return this.queue.remove(task);
    }

    public void offer(E task) {
        this.queue.offer(task);
    }

    public boolean isEmpty() {
        return this.spaceInBytes.get() == 0;
    }

    public void onClose() {
        WriteHandler writeHandler;
        this.isClosed = true;
        IOException error = null;
        if (!this.isEmpty()) {
            AsyncWriteQueueRecord record;
            if (error == null) {
                error = new IOException("Connection closed");
            }
            while ((record = (AsyncWriteQueueRecord)this.obtainCurrentElementAndReserve()) != null) {
                record.notifyFailure(error);
            }
        }
        while ((writeHandler = this.pollWriteHandler()) != null) {
            if (error == null) {
                error = new IOException("Connection closed");
            }
            writeHandler.onError(error);
        }
    }

    private void offerWriteHandler(WriteHandler writeHandler) {
        this.writeHandlersCounter.incrementAndGet();
        this.writeHandlersQueue.offer(writeHandler);
    }

    private boolean removeWriteHandler(WriteHandler writeHandler) {
        if (this.writeHandlersQueue.remove(writeHandler)) {
            this.writeHandlersCounter.decrementAndGet();
            return true;
        }
        return false;
    }

    private WriteHandler pollWriteHandler() {
        WriteHandler record = this.writeHandlersQueue.poll();
        if (record != null) {
            this.writeHandlersCounter.decrementAndGet();
            return record;
        }
        return null;
    }

    public static interface MutableMaxQueueSize {
        public int getMaxQueueSize();
    }
}

