/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.io.EOFException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.PendingWriteQueueLimitExceededException;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLConnectionContext;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.glassfish.grizzly.utils.Exceptions;

public class SSLFilter
extends SSLBaseFilter {
    private static final Logger LOGGER = Grizzly.logger(SSLFilter.class);
    private final Attribute<SSLHandshakeContext> handshakeContextAttr;
    private final SSLEngineConfigurator clientSSLEngineConfigurator;
    private final ConnectionCloseListener closeListener = new ConnectionCloseListener();
    protected volatile int maxPendingBytes = Integer.MAX_VALUE;

    public SSLFilter() {
        this(null, null);
    }

    public SSLFilter(SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator) {
        this(serverSSLEngineConfigurator, clientSSLEngineConfigurator, true);
    }

    public SSLFilter(SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator, boolean renegotiateOnClientAuthWant) {
        super(serverSSLEngineConfigurator, renegotiateOnClientAuthWant);
        this.clientSSLEngineConfigurator = clientSSLEngineConfigurator == null ? new SSLEngineConfigurator(SSLContextConfigurator.DEFAULT_CONFIG.createSSLContext(), true, false, false) : clientSSLEngineConfigurator;
        this.handshakeContextAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("SSLFilter-SSLHandshakeContextAttr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        if (ctx.getMessage() instanceof FileTransfer) {
            throw new IllegalStateException("TLS operations not supported with SendFile messages");
        }
        Connection connection2 = connection;
        synchronized (connection2) {
            SSLConnectionContext sslCtx = SSLUtils.obtainSslConnectionContext(connection);
            SSLEngine sslEngine = sslCtx.getSslEngine();
            if (sslEngine != null && !SSLUtils.isHandshaking(sslEngine)) {
                return sslCtx.isServerMode() ? super.handleWrite(ctx) : this.accurateWrite(ctx, true);
            }
            if (sslEngine == null) {
                this.handshake(connection, null, null, this.clientSSLEngineConfigurator, ctx);
            }
            return this.accurateWrite(ctx, false);
        }
    }

    public int getMaxPendingBytesPerConnection() {
        return this.maxPendingBytes;
    }

    public void setMaxPendingBytesPerConnection(int maxPendingBytes) {
        this.maxPendingBytes = maxPendingBytes;
    }

    public void handshake(Connection connection, CompletionHandler<SSLEngine> completionHandler) throws IOException {
        this.handshake(connection, completionHandler, null, this.clientSSLEngineConfigurator);
    }

    public void handshake(Connection connection, CompletionHandler<SSLEngine> completionHandler, Object dstAddress) throws IOException {
        this.handshake(connection, completionHandler, dstAddress, this.clientSSLEngineConfigurator);
    }

    public void handshake(Connection connection, CompletionHandler<SSLEngine> completionHandler, Object dstAddress, SSLEngineConfigurator sslEngineConfigurator) throws IOException {
        this.handshake(connection, completionHandler, dstAddress, sslEngineConfigurator, this.createContext(connection, FilterChainContext.Operation.WRITE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handshake(Connection<?> connection, CompletionHandler<SSLEngine> completionHandler, Object dstAddress, SSLEngineConfigurator sslEngineConfigurator, FilterChainContext context) throws IOException {
        SSLConnectionContext sslCtx = SSLUtils.obtainSslConnectionContext(connection);
        SSLEngine sslEngine = sslCtx.getSslEngine();
        if (sslEngine == null) {
            sslEngine = sslEngineConfigurator.createSSLEngine();
            sslCtx.configure(sslEngine);
        } else {
            sslEngineConfigurator.configure(sslEngine);
        }
        this.notifyHandshakeStart(connection);
        sslEngine.beginHandshake();
        this.handshakeContextAttr.set(connection, new SSLHandshakeContext(connection, completionHandler));
        connection.addCloseListener(this.closeListener);
        Connection<?> connection2 = connection;
        synchronized (connection2) {
            Buffer buffer = this.doHandshakeStep(sslCtx, context, null);
            assert (buffer == null);
        }
    }

    private NextAction accurateWrite(FilterChainContext ctx, boolean isHandshakeComplete) throws IOException {
        Connection connection = ctx.getConnection();
        SSLHandshakeContext handshakeContext = this.handshakeContextAttr.get(connection);
        if (isHandshakeComplete && handshakeContext == null) {
            return super.handleWrite(ctx);
        }
        if (handshakeContext == null) {
            handshakeContext = new SSLHandshakeContext(connection, null);
            this.handshakeContextAttr.set(connection, handshakeContext);
        }
        if (!handshakeContext.add(ctx)) {
            return super.handleWrite(ctx);
        }
        return ctx.getSuspendAction();
    }

    @Override
    protected void notifyHandshakeComplete(Connection<?> connection, SSLEngine sslEngine) {
        SSLHandshakeContext handshakeContext = this.handshakeContextAttr.get(connection);
        if (handshakeContext != null) {
            connection.removeCloseListener(this.closeListener);
            handshakeContext.completed(sslEngine);
            this.handshakeContextAttr.remove(connection);
        }
        super.notifyHandshakeComplete(connection, sslEngine);
    }

    @Override
    protected void notifyHandshakeFailed(Connection connection, Throwable t) {
        SSLHandshakeContext handshakeContext = this.handshakeContextAttr.get(connection);
        handshakeContext.failed(t);
    }

    private final class ConnectionCloseListener
    implements Connection.CloseListener {
        private ConnectionCloseListener() {
        }

        @Override
        public void onClosed(Connection connection, Connection.CloseType type) throws IOException {
            SSLHandshakeContext handshakeContext = (SSLHandshakeContext)SSLFilter.this.handshakeContextAttr.get(connection);
            if (handshakeContext != null) {
                handshakeContext.failed(new EOFException());
                SSLFilter.this.handshakeContextAttr.remove(connection);
            }
        }
    }

    private final class SSLHandshakeContext {
        private CompletionHandler<SSLEngine> completionHandler;
        private final Connection connection;
        private List<FilterChainContext> pendingWriteContexts;
        private int sizeInBytes = 0;
        private IOException error;
        private boolean isComplete;

        public SSLHandshakeContext(Connection connection, CompletionHandler<SSLEngine> completionHandler) {
            this.connection = connection;
            this.completionHandler = completionHandler;
        }

        public boolean add(FilterChainContext context) throws IOException {
            if (this.error != null) {
                throw this.error;
            }
            if (this.isComplete) {
                return false;
            }
            Buffer buffer = (Buffer)context.getMessage();
            int newSize = this.sizeInBytes + buffer.remaining();
            if (newSize > SSLFilter.this.maxPendingBytes) {
                throw new PendingWriteQueueLimitExceededException("Max queued data limit exceeded: " + newSize + '>' + SSLFilter.this.maxPendingBytes);
            }
            this.sizeInBytes = newSize;
            if (this.pendingWriteContexts == null) {
                this.pendingWriteContexts = new LinkedList<FilterChainContext>();
            }
            this.pendingWriteContexts.add(context);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(SSLEngine result) {
            try {
                Connection connection = this.connection;
                synchronized (connection) {
                    this.isComplete = true;
                    CompletionHandler<SSLEngine> completionHandlerLocal = this.completionHandler;
                    this.completionHandler = null;
                    if (completionHandlerLocal != null) {
                        completionHandlerLocal.completed(result);
                    }
                    List<FilterChainContext> pendingWriteContextsLocal = this.pendingWriteContexts;
                    this.pendingWriteContexts = null;
                    if (pendingWriteContextsLocal != null) {
                        for (FilterChainContext ctx : pendingWriteContextsLocal) {
                            ctx.resume();
                        }
                        pendingWriteContextsLocal.clear();
                        this.sizeInBytes = 0;
                    }
                }
            }
            catch (Exception e) {
                this.failed(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Throwable throwable) {
            Connection connection = this.connection;
            synchronized (connection) {
                this.error = Exceptions.makeIOException(throwable);
                CompletionHandler<SSLEngine> completionHandlerLocal = this.completionHandler;
                this.completionHandler = null;
                if (completionHandlerLocal != null) {
                    completionHandlerLocal.failed(throwable);
                }
                List<FilterChainContext> pendingWriteContextsLocal = this.pendingWriteContexts;
                this.pendingWriteContexts = null;
                if (pendingWriteContextsLocal != null) {
                    for (FilterChainContext ctx : pendingWriteContextsLocal) {
                        ctx.resume();
                    }
                    pendingWriteContextsLocal.clear();
                    this.sizeInBytes = 0;
                }
            }
            this.connection.closeSilently();
        }
    }
}

