/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.threadpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.memory.ThreadLocalPoolProvider;
import org.glassfish.grizzly.monitoring.jmx.AbstractJmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringAware;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.threadpool.DefaultWorkerThread;
import org.glassfish.grizzly.threadpool.ProbeNotifier;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;
import org.glassfish.grizzly.threadpool.jmx.ThreadPool;
import org.glassfish.grizzly.utils.DelayedExecutor;

public abstract class AbstractThreadPool
extends AbstractExecutorService
implements Thread.UncaughtExceptionHandler,
JmxMonitoringAware<ThreadPoolProbe> {
    private static final Logger logger = Grizzly.logger(AbstractThreadPool.class);
    public static final int DEFAULT_MIN_THREAD_COUNT;
    public static final int DEFAULT_MAX_THREAD_COUNT;
    private static final Long NEVER_TIMEOUT;
    public static final int DEFAULT_MAX_TASKS_QUEUED = -1;
    public static final int DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT = 30000;
    protected static final Runnable poison;
    private final AtomicInteger nextThreadId = new AtomicInteger();
    protected final ReentrantLock stateLock = new ReentrantLock();
    protected final Condition stateLockCondition = this.stateLock.newCondition();
    protected final Map<Worker, Long> workers = new HashMap<Worker, Long>();
    protected volatile boolean running = true;
    protected final ThreadPoolConfig config;
    protected final long transactionTimeoutMillis;
    protected final DelayedExecutor.DelayQueue<Worker> delayedQueue;
    private static final DelayedExecutor.Resolver<Worker> transactionResolver;
    protected final AbstractJmxMonitoringConfig<ThreadPoolProbe> monitoringConfig = new AbstractJmxMonitoringConfig<ThreadPoolProbe>(ThreadPoolProbe.class){

        @Override
        public JmxObject createManagementObject() {
            return AbstractThreadPool.this.createJmxManagementObject();
        }
    };

    public AbstractThreadPool(ThreadPoolConfig config) {
        DelayedExecutor transactionMonitor;
        if (config.getMaxPoolSize() < 1) {
            throw new IllegalArgumentException("poolsize < 1");
        }
        this.config = config;
        if (config.getInitialMonitoringConfig().hasProbes()) {
            this.monitoringConfig.addProbes((ThreadPoolProbe[])config.getInitialMonitoringConfig().getProbes());
        }
        if (config.getThreadFactory() == null) {
            config.setThreadFactory(this.getDefaultThreadFactory());
        }
        this.transactionTimeoutMillis = config.getTransactionTimeout(TimeUnit.MILLISECONDS);
        DelayedExecutor delayedExecutor = transactionMonitor = this.transactionTimeoutMillis > 0L ? config.getTransactionMonitor() : null;
        if (transactionMonitor != null) {
            DelayedExecutor.Worker<Worker> transactionWorker = new DelayedExecutor.Worker<Worker>(){

                @Override
                public boolean doWork(Worker worker) {
                    worker.t.interrupt();
                    AbstractThreadPool.this.delayedQueue.add(worker, NEVER_TIMEOUT, TimeUnit.MILLISECONDS);
                    return true;
                }
            };
            this.delayedQueue = transactionMonitor.createDelayQueue(transactionWorker, transactionResolver);
        } else {
            this.delayedQueue = null;
        }
    }

    protected void startWorker(Worker worker) {
        Thread thread = this.config.getThreadFactory().newThread(worker);
        thread.setName(this.config.getPoolName() + '(' + this.nextThreadId() + ')');
        thread.setUncaughtExceptionHandler(this);
        thread.setPriority(this.config.getPriority());
        thread.setDaemon(true);
        worker.t = thread;
        this.workers.put(worker, System.currentTimeMillis());
        worker.t.start();
    }

    public ThreadPoolConfig getConfig() {
        return this.config;
    }

    public Queue<Runnable> getQueue() {
        return this.config.getQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        this.stateLock.lock();
        try {
            ArrayList<Runnable> drained = new ArrayList<Runnable>();
            if (this.running) {
                this.running = false;
                AbstractThreadPool.drain(this.getQueue(), drained);
                for (Runnable task : drained) {
                    this.onTaskDequeued(task);
                }
                this.poisonAll();
                for (Worker w : this.workers.keySet()) {
                    w.t.interrupt();
                }
                ProbeNotifier.notifyThreadPoolStopped(this);
            }
            ArrayList<Runnable> arrayList = drained;
            return arrayList;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.stateLock.lock();
        try {
            if (this.running) {
                this.running = false;
                this.poisonAll();
                this.stateLockCondition.signalAll();
                ProbeNotifier.notifyThreadPoolStopped(this);
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public boolean isShutdown() {
        return !this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        this.stateLock.lock();
        try {
            boolean bl = !this.running && this.workers.isEmpty();
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock mainLock = this.stateLock;
        mainLock.lock();
        try {
            while (true) {
                if (this.isTerminated()) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.stateLockCondition.awaitNanos(nanos);
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    protected void poisonAll() {
        int size = Math.max(this.config.getMaxPoolSize(), this.workers.size()) * 4 / 3;
        Queue<Runnable> q = this.getQueue();
        while (size-- > 0) {
            q.offer(poison);
        }
    }

    protected static void drain(Queue<Runnable> from, Collection<Runnable> to) {
        boolean cont = true;
        while (cont) {
            Runnable r = from.poll();
            cont = r != null;
            if (!cont || r == poison) continue;
            to.add(r);
        }
    }

    protected String nextThreadId() {
        return String.valueOf(this.nextThreadId.incrementAndGet());
    }

    protected void validateNewPoolSize(int corePoolsize, int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolsize < 1 :" + maxPoolSize);
        }
        if (corePoolsize < 1) {
            throw new IllegalArgumentException("corePoolsize < 1 :" + corePoolsize);
        }
        if (corePoolsize > maxPoolSize) {
            throw new IllegalArgumentException("corePoolsize > maxPoolSize: " + corePoolsize + " > " + maxPoolSize);
        }
    }

    protected void beforeExecute(Worker worker, Thread t, Runnable r) {
        if (this.delayedQueue != null) {
            worker.transactionExpirationTime = System.currentTimeMillis() + this.transactionTimeoutMillis;
        }
    }

    protected void afterExecute(Worker worker, Thread thread, Runnable r, Throwable t) {
        if (this.delayedQueue != null) {
            worker.transactionExpirationTime = NEVER_TIMEOUT;
        }
    }

    protected void onTaskCompletedEvent(Runnable task) {
        ProbeNotifier.notifyTaskCompleted(this, task);
    }

    protected void onWorkerStarted(Worker worker) {
        if (this.delayedQueue != null) {
            this.delayedQueue.add(worker, NEVER_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        ProbeNotifier.notifyThreadAllocated(this, worker.t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onWorkerExit(Worker worker) {
        this.stateLock.lock();
        try {
            this.workers.remove(worker);
            if (this.workers.isEmpty()) {
                this.stateLockCondition.signalAll();
            }
        }
        finally {
            this.stateLock.unlock();
        }
        ProbeNotifier.notifyThreadReleased(this, worker.t);
    }

    protected void onMaxNumberOfThreadsReached() {
        ProbeNotifier.notifyMaxNumberOfThreads(this, this.config.getMaxPoolSize());
    }

    protected void onTaskQueued(Runnable task) {
        ProbeNotifier.notifyTaskQueued(this, task);
    }

    protected void onTaskDequeued(Runnable task) {
        ProbeNotifier.notifyTaskDequeued(this, task);
    }

    protected void onTaskQueueOverflow() {
        ProbeNotifier.notifyTaskQueueOverflow(this);
        throw new RejectedExecutionException("The thread pool's task queue is full, limit: " + this.config.getQueueLimit());
    }

    @Override
    public JmxMonitoringConfig<ThreadPoolProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_THREADPOOL_UNCAUGHT_EXCEPTION(thread), throwable);
    }

    JmxObject createJmxManagementObject() {
        return new ThreadPool(this);
    }

    protected ThreadFactory getDefaultThreadFactory() {
        final AtomicInteger counter = new AtomicInteger();
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                MemoryManager mm = AbstractThreadPool.this.config.getMemoryManager();
                ThreadLocalPoolProvider threadLocalPoolProvider = mm instanceof ThreadLocalPoolProvider ? (ThreadLocalPoolProvider)((Object)mm) : null;
                return new DefaultWorkerThread(Grizzly.DEFAULT_ATTRIBUTE_BUILDER, AbstractThreadPool.this.config.getPoolName() + "-WorkerThread(" + counter.getAndIncrement() + ')', threadLocalPoolProvider != null ? threadLocalPoolProvider.createThreadLocalPool() : null, r);
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(this.getClass().getSimpleName());
        sb.append(" config: [").append(this.config.toString()).append("]\r\n");
        sb.append(", is-shutdown=").append(this.isShutdown());
        return sb.toString();
    }

    static {
        NEVER_TIMEOUT = Long.MAX_VALUE;
        int processorsBasedThreadCount = Runtime.getRuntime().availableProcessors();
        DEFAULT_MIN_THREAD_COUNT = processorsBasedThreadCount > 5 ? processorsBasedThreadCount : 5;
        DEFAULT_MAX_THREAD_COUNT = Integer.MAX_VALUE;
        poison = new Runnable(){

            @Override
            public void run() {
            }
        };
        transactionResolver = new DelayedExecutor.Resolver<Worker>(){

            @Override
            public boolean removeTimeout(Worker element) {
                element.transactionExpirationTime = -1L;
                return true;
            }

            @Override
            public long getTimeoutMillis(Worker element) {
                return element.transactionExpirationTime;
            }

            @Override
            public void setTimeoutMillis(Worker element, long timeoutMillis) {
                element.transactionExpirationTime = timeoutMillis;
            }
        };
    }

    public abstract class Worker
    implements Runnable {
        protected Thread t;
        protected volatile long transactionExpirationTime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AbstractThreadPool.this.onWorkerStarted(this);
                this.doWork();
            }
            finally {
                AbstractThreadPool.this.onWorkerExit(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected void doWork() {
            thread = this.t;
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        Thread.interrupted();
                        r = this.getTask();
                        if (r == AbstractThreadPool.poison || r == null) {
                            return;
                        }
                        AbstractThreadPool.this.onTaskDequeued(r);
                        error = null;
                        try {
                            AbstractThreadPool.this.beforeExecute(this, thread, r);
                            r.run();
                            AbstractThreadPool.this.onTaskCompletedEvent(r);
                        }
                        catch (Exception e) {
                            error = e;
                        }
                        finally {
                            AbstractThreadPool.this.afterExecute(this, thread, r, error);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception var2_3) {
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }

        protected abstract Runnable getTask() throws InterruptedException;
    }
}

