/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.PendingWriteQueueLimitExceededException;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.AbstractCodecFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLDecoderTransformer;
import org.glassfish.grizzly.ssl.SSLEncoderTransformer;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLUtils;

public class SSLFilter
extends AbstractCodecFilter<Buffer, Buffer> {
    private static final Logger LOGGER = Grizzly.logger(SSLFilter.class);
    private final Attribute<CompletionHandler<SSLEngine>> handshakeCompletionHandlerAttr;
    private final Attribute<FilterChainContext> initiatingContextAttr;
    private final SSLEngineConfigurator serverSSLEngineConfigurator;
    private final SSLEngineConfigurator clientSSLEngineConfigurator;
    private final boolean renegotiateOnClientAuthWant;
    private final ConnectionCloseListener closeListener = new ConnectionCloseListener();
    protected volatile int maxPendingBytes = Integer.MAX_VALUE;

    public SSLFilter() {
        this((SSLEngineConfigurator)null, (SSLEngineConfigurator)null);
    }

    public SSLFilter(SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator) {
        this(serverSSLEngineConfigurator, clientSSLEngineConfigurator, true);
    }

    public SSLFilter(SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator, boolean renegotiateOnClientAuthWant) {
        super(new SSLDecoderTransformer(), new SSLEncoderTransformer());
        this.renegotiateOnClientAuthWant = renegotiateOnClientAuthWant;
        this.serverSSLEngineConfigurator = serverSSLEngineConfigurator == null ? new SSLEngineConfigurator(SSLContextConfigurator.DEFAULT_CONFIG.createSSLContext(), false, false, false) : serverSSLEngineConfigurator;
        this.clientSSLEngineConfigurator = clientSSLEngineConfigurator == null ? new SSLEngineConfigurator(SSLContextConfigurator.DEFAULT_CONFIG.createSSLContext(), true, false, false) : clientSSLEngineConfigurator;
        this.handshakeCompletionHandlerAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("SSLFilter-HandshakeCompletionHandlerAttr");
        this.initiatingContextAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("SSLFilter-HandshakingInitiatingContextAttr");
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (event.type() == "CERT_EVENT") {
            CertificateEvent ce = (CertificateEvent)event;
            CertificateEvent.access$102(ce, this.getPeerCertificateChain(SSLUtils.getSSLEngine(ctx.getConnection()), ctx, ce.needClientAuth));
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        SSLEngine sslEngine = SSLUtils.getSSLEngine(connection);
        if (sslEngine != null && !SSLUtils.isHandshaking(sslEngine)) {
            return super.handleRead(ctx);
        }
        if (sslEngine == null) {
            sslEngine = this.serverSSLEngineConfigurator.createSSLEngine();
            sslEngine.beginHandshake();
            SSLUtils.setSSLEngine(connection, sslEngine);
        }
        Buffer buffer = this.doHandshakeStep(sslEngine, ctx);
        boolean hasRemaining = buffer.hasRemaining();
        boolean isHandshaking = SSLUtils.isHandshaking(sslEngine);
        if (!isHandshaking) {
            this.notifyHandshakeCompleted(connection, sslEngine);
            if (hasRemaining) {
                ctx.setMessage(buffer);
                return super.handleRead(ctx);
            }
        }
        return ctx.getStopAction(hasRemaining ? buffer : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        if (ctx.getMessage() instanceof FileTransfer) {
            throw new IllegalStateException("TLS operations not supported with SendFile messages");
        }
        Connection connection2 = connection;
        synchronized (connection2) {
            SSLEngine sslEngine = SSLUtils.getSSLEngine(connection);
            if (sslEngine != null && !SSLUtils.isHandshaking(sslEngine)) {
                return this.accurateWrite(ctx, true);
            }
            sslEngine = SSLUtils.getSSLEngine(connection);
            if (sslEngine == null) {
                this.initiatingContextAttr.set(ctx.getConnection(), ctx);
                this.handshake(connection, new PendingWriteCompletionHandler(connection), null, this.clientSSLEngineConfigurator);
            }
            return this.accurateWrite(ctx, false);
        }
    }

    public int getMaxPendingBytesPerConnection() {
        return this.maxPendingBytes;
    }

    public void setMaxPendingBytesPerConnection(int maxPendingBytes) {
        this.maxPendingBytes = maxPendingBytes;
    }

    public void handshake(Connection connection, CompletionHandler<SSLEngine> completionHandler) throws IOException {
        this.handshake(connection, completionHandler, null, this.clientSSLEngineConfigurator);
    }

    public void handshake(Connection connection, CompletionHandler<SSLEngine> completionHandler, Object dstAddress) throws IOException {
        this.handshake(connection, completionHandler, dstAddress, this.clientSSLEngineConfigurator);
    }

    public void handshake(Connection connection, CompletionHandler<SSLEngine> completionHandler, Object dstAddress, SSLEngineConfigurator sslEngineConfigurator) throws IOException {
        SSLEngine sslEngine = SSLUtils.getSSLEngine(connection);
        if (sslEngine == null) {
            sslEngine = sslEngineConfigurator.createSSLEngine();
            sslEngine.beginHandshake();
            SSLUtils.setSSLEngine(connection, sslEngine);
        } else {
            sslEngineConfigurator.configure(sslEngine);
            sslEngine.beginHandshake();
        }
        if (completionHandler != null) {
            this.handshakeCompletionHandlerAttr.set(connection, completionHandler);
            connection.addCloseListener(this.closeListener);
        }
        FilterChainContext ctx = this.createContext(connection, FilterChainContext.Operation.WRITE);
        this.doHandshakeStep(sslEngine, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer doHandshakeStep(SSLEngine sslEngine, FilterChainContext context) throws IOException {
        Connection connection = context.getConnection();
        Object dstAddress = context.getAddress();
        Buffer inputBuffer = (Buffer)context.getMessage();
        boolean isLoggingFinest = LOGGER.isLoggable(Level.FINEST);
        try {
            Connection connection2 = connection;
            synchronized (connection2) {
                SSLEngineResult.HandshakeStatus handshakeStatus = sslEngine.getHandshakeStatus();
                do {
                    if (isLoggingFinest) {
                        LOGGER.log(Level.FINEST, "Loop Engine: {0} handshakeStatus={1}", new Object[]{sslEngine, sslEngine.getHandshakeStatus()});
                    }
                    switch (handshakeStatus) {
                        case NEED_UNWRAP: {
                            if (isLoggingFinest) {
                                LOGGER.log(Level.FINEST, "NEED_UNWRAP Engine: {0}", sslEngine);
                            }
                            if (inputBuffer == null || !inputBuffer.hasRemaining()) {
                                return inputBuffer;
                            }
                            SSLEngineResult sslEngineResult = SSLUtils.handshakeUnwrap(connection, sslEngine, inputBuffer);
                            if (sslEngineResult == null) {
                                return inputBuffer;
                            }
                            SSLEngineResult.Status status = sslEngineResult.getStatus();
                            if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                                return inputBuffer;
                            }
                            if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                                throw new SSLException("Buffer overflow");
                            }
                            handshakeStatus = sslEngine.getHandshakeStatus();
                            break;
                        }
                        case NEED_WRAP: {
                            if (isLoggingFinest) {
                                LOGGER.log(Level.FINEST, "NEED_WRAP Engine: {0}", sslEngine);
                            }
                            Buffer buffer = SSLUtils.handshakeWrap(connection, sslEngine);
                            try {
                                context.write(dstAddress, buffer, null);
                                handshakeStatus = sslEngine.getHandshakeStatus();
                                break;
                            }
                            catch (Exception e) {
                                buffer.dispose();
                                throw new IOException("Unexpected exception", e);
                            }
                        }
                        case NEED_TASK: {
                            if (isLoggingFinest) {
                                LOGGER.log(Level.FINEST, "NEED_TASK Engine: {0}", sslEngine);
                            }
                            SSLUtils.executeDelegatedTask(sslEngine);
                            handshakeStatus = sslEngine.getHandshakeStatus();
                            break;
                        }
                        case FINISHED: 
                        case NOT_HANDSHAKING: {
                            return inputBuffer;
                        }
                    }
                } while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED);
                this.initiatingContextAttr.remove(connection);
                return inputBuffer;
            }
        }
        catch (IOException ioe) {
            FilterChainContext ictx = this.initiatingContextAttr.get(connection);
            try {
                if (ictx != null) {
                    ictx.getFilterChain().fail(ictx, ioe);
                }
            }
            finally {
                this.initiatingContextAttr.remove(connection);
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renegotiate(SSLEngine sslEngine, FilterChainContext context) throws IOException {
        boolean authConfigured;
        if (sslEngine.getWantClientAuth() && !this.renegotiateOnClientAuthWant) {
            return;
        }
        boolean bl = authConfigured = sslEngine.getWantClientAuth() || sslEngine.getNeedClientAuth();
        if (!authConfigured) {
            sslEngine.setNeedClientAuth(true);
        }
        Connection c = context.getConnection();
        sslEngine.getSession().invalidate();
        try {
            sslEngine.beginHandshake();
        }
        catch (SSLHandshakeException e) {
            if (e.toString().toLowerCase().contains("insecure renegotiation") && LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("Secure SSL/TLS renegotiation is not supported by the peer.  This is most likely due to the peer using an older SSL/TLS implementation that does not implement RFC 5746.");
            }
            throw e;
        }
        try {
            Buffer buffer = SSLUtils.handshakeWrap(c, sslEngine);
            try {
                context.write(context.getAddress(), buffer, null);
            }
            catch (Exception e) {
                buffer.dispose();
                throw new IOException("Unexpected exception", e);
            }
            ReadResult result = context.read();
            Buffer m = (Buffer)result.getMessage();
            context.setMessage(m);
            while (SSLUtils.isHandshaking(sslEngine)) {
                this.doHandshakeStep(sslEngine, context);
                if (m.hasRemaining() || !SSLUtils.isHandshaking(sslEngine)) continue;
                result = context.read();
                m = (Buffer)result.getMessage();
                context.setMessage(m);
            }
        }
        catch (Throwable t) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Error during handshake", t);
            }
        }
        finally {
            if (!authConfigured) {
                sslEngine.setNeedClientAuth(false);
            }
        }
    }

    protected Object[] getPeerCertificateChain(SSLEngine sslEngine, FilterChainContext context, boolean needClientAuth) throws IOException {
        Object[] certs = this.getPeerCertificates(sslEngine);
        if (certs != null) {
            return certs;
        }
        if (needClientAuth) {
            this.renegotiate(sslEngine, context);
        }
        if ((certs = this.getPeerCertificates(sslEngine)) == null) {
            return null;
        }
        Object[] x509Certs = this.extractX509Certs((Certificate[])certs);
        if (x509Certs == null || x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    private NextAction accurateWrite(FilterChainContext ctx, boolean isHandshakeComplete) throws IOException {
        Connection connection = ctx.getConnection();
        CompletionHandler<SSLEngine> completionHandler = this.handshakeCompletionHandlerAttr.get(connection);
        boolean isPendingHandler = completionHandler instanceof PendingWriteCompletionHandler;
        if (isHandshakeComplete && !isPendingHandler) {
            return this.doWrite(ctx);
        }
        if (isPendingHandler) {
            if (!((PendingWriteCompletionHandler)completionHandler).add(ctx)) {
                return this.doWrite(ctx);
            }
        } else {
            SSLEngine sslEngine = SSLUtils.getSSLEngine(connection);
            if (sslEngine != null && !SSLUtils.isHandshaking(sslEngine)) {
                return this.doWrite(ctx);
            }
            throw new IllegalStateException("Handshake is not completed!");
        }
        return ctx.getSuspendAction();
    }

    private NextAction doWrite(FilterChainContext ctx) throws IOException {
        NextAction nextAction = super.handleWrite(ctx);
        if (nextAction.type() != 0) {
            throw new IllegalStateException("Unexpected next action type: " + nextAction.type());
        }
        Buffer message = (Buffer)ctx.getMessage();
        Object address = ctx.getAddress();
        FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
        ctx.write(address, (Object)message, (CompletionHandler<WriteResult>)transportContext.getCompletionHandler(), transportContext.getMessageCloner(), transportContext.isBlocking());
        return ctx.getStopAction();
    }

    private X509Certificate[] extractX509Certs(Certificate[] certs) {
        X509Certificate[] x509Certs = new X509Certificate[certs.length];
        int len = certs.length;
        for (int i = 0; i < len; ++i) {
            if (certs[i] instanceof X509Certificate) {
                x509Certs[i] = (X509Certificate)certs[i];
            } else {
                try {
                    byte[] buffer = certs[i].getEncoded();
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "Error translating cert " + certs[i], ex);
                    return null;
                }
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.log(Level.FINE, "Cert #{0} = {1}", new Object[]{i, x509Certs[i]});
        }
        return x509Certs;
    }

    private Certificate[] getPeerCertificates(SSLEngine sslEngine) {
        try {
            return sslEngine.getSession().getPeerCertificates();
        }
        catch (Throwable t) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Error getting client certs", t);
            }
            return null;
        }
    }

    private void notifyHandshakeCompleted(Connection connection, SSLEngine sslEngine) {
        CompletionHandler<SSLEngine> completionHandler = this.handshakeCompletionHandlerAttr.get(connection);
        if (completionHandler != null) {
            connection.removeCloseListener(this.closeListener);
            completionHandler.completed(sslEngine);
            this.handshakeCompletionHandlerAttr.remove(connection);
        }
    }

    public static class CertificateEvent
    implements FilterChainEvent {
        private static final String TYPE = "CERT_EVENT";
        private Object[] certs;
        private final boolean needClientAuth;

        public CertificateEvent(boolean needClientAuth) {
            this.needClientAuth = needClientAuth;
        }

        @Override
        public final Object type() {
            return TYPE;
        }

        public Object[] getCertificates() {
            return this.certs;
        }

        static /* synthetic */ Object[] access$102(CertificateEvent x0, Object[] x1) {
            x0.certs = x1;
            return x1;
        }
    }

    private final class ConnectionCloseListener
    implements Connection.CloseListener {
        private ConnectionCloseListener() {
        }

        @Override
        public void onClosed(Connection connection, Connection.CloseType type) throws IOException {
            CompletionHandler completionHandler = (CompletionHandler)SSLFilter.this.handshakeCompletionHandlerAttr.remove(connection);
            if (completionHandler != null) {
                completionHandler.failed(new EOFException());
            }
        }
    }

    private final class PendingWriteCompletionHandler
    extends EmptyCompletionHandler<SSLEngine> {
        private final Connection connection;
        private final List<FilterChainContext> pendingWriteContexts;
        private int sizeInBytes = 0;
        private IOException error;
        private boolean isComplete;

        public PendingWriteCompletionHandler(Connection connection) {
            this.connection = connection;
            this.pendingWriteContexts = new LinkedList<FilterChainContext>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(FilterChainContext context) throws IOException {
            Connection connection = this.connection;
            synchronized (connection) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.isComplete) {
                    return false;
                }
                Buffer buffer = (Buffer)context.getMessage();
                int newSize = this.sizeInBytes + buffer.remaining();
                if (newSize > SSLFilter.this.maxPendingBytes) {
                    throw new PendingWriteQueueLimitExceededException("Max queued data limit exceeded: " + newSize + '>' + SSLFilter.this.maxPendingBytes);
                }
                this.sizeInBytes = newSize;
                this.pendingWriteContexts.add(context);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(SSLEngine result) {
            try {
                Connection connection = this.connection;
                synchronized (connection) {
                    this.isComplete = true;
                    for (FilterChainContext ctx : this.pendingWriteContexts) {
                        ctx.resume();
                    }
                    this.pendingWriteContexts.clear();
                    this.sizeInBytes = 0;
                }
            }
            catch (Exception e) {
                this.failed(e);
            }
        }

        @Override
        public void cancelled() {
            this.failed(new CancellationException());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable throwable) {
            Connection connection = this.connection;
            synchronized (connection) {
                this.error = throwable instanceof IOException ? (IOException)throwable : new IOException(throwable);
            }
            this.connection.closeSilently();
        }
    }
}

