/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.utils.Holder;
import org.glassfish.grizzly.utils.NullaryFunction;

public class UDPNIOConnection
extends NIOConnection {
    private static final Logger LOGGER = Grizzly.logger(UDPNIOConnection.class);
    Holder<SocketAddress> localSocketAddressHolder;
    Holder<SocketAddress> peerSocketAddressHolder;
    private NIOConnection.SettableIntHolder readBufferSizeHolder;
    private NIOConnection.SettableIntHolder writeBufferSizeHolder;

    public UDPNIOConnection(UDPNIOTransport transport, DatagramChannel channel) {
        super(transport);
        this.channel = channel;
        this.resetProperties();
    }

    public boolean isConnected() {
        return this.channel != null && ((DatagramChannel)this.channel).isConnected();
    }

    @Override
    protected void setSelectionKey(SelectionKey selectionKey) {
        super.setSelectionKey(selectionKey);
    }

    @Override
    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        super.setSelectorRunner(selectorRunner);
    }

    protected boolean notifyReady() {
        return this.connectCloseSemaphor.compareAndSet(null, NOTIFICATION_INITIALIZED);
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.peerSocketAddressHolder.get();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localSocketAddressHolder.get();
    }

    protected final void resetProperties() {
        if (this.channel != null) {
            this.readBufferSizeHolder = new NIOConnection.SettableIntHolder(){

                @Override
                protected int evaluate() {
                    try {
                        return ((DatagramChannel)UDPNIOConnection.this.channel).socket().getReceiveBufferSize();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Can not evaluate receive buffer size", e);
                    }
                }
            };
            this.writeBufferSizeHolder = new NIOConnection.SettableIntHolder(){

                @Override
                protected int evaluate() {
                    try {
                        return ((DatagramChannel)UDPNIOConnection.this.channel).socket().getSendBufferSize();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Can not evaluate send buffer size", e);
                    }
                }
            };
            this.setReadBufferSize(this.transport.getReadBufferSize());
            this.setWriteBufferSize(this.transport.getWriteBufferSize());
            int transportMaxAsyncWriteQueueSize = ((UDPNIOTransport)this.transport).getAsyncQueueIO().getWriter().getMaxPendingBytesPerConnection();
            this.setMaxAsyncWriteQueueSize(transportMaxAsyncWriteQueueSize == -2 ? this.getWriteBufferSize() * 4 : transportMaxAsyncWriteQueueSize);
            this.localSocketAddressHolder = Holder.lazyHolder(new NullaryFunction<SocketAddress>(){

                @Override
                public SocketAddress evaluate() {
                    return ((DatagramChannel)UDPNIOConnection.this.channel).socket().getLocalSocketAddress();
                }
            });
            this.peerSocketAddressHolder = Holder.lazyHolder(new NullaryFunction<SocketAddress>(){

                @Override
                public SocketAddress evaluate() {
                    return ((DatagramChannel)UDPNIOConnection.this.channel).socket().getRemoteSocketAddress();
                }
            });
        }
    }

    @Override
    public int getReadBufferSize() {
        if (this.readBufferSizeHolder == null) {
            throw new IllegalStateException("TCPNIOConnection is not initialized");
        }
        return this.readBufferSizeHolder.getInt();
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        if (this.readBufferSizeHolder == null) {
            throw new IllegalStateException("TCPNIOConnection is not initialized");
        }
        if (readBufferSize > 0) {
            try {
                int currentReadBufferSize = ((DatagramChannel)this.channel).socket().getReceiveBufferSize();
                if (readBufferSize > currentReadBufferSize) {
                    ((DatagramChannel)this.channel).socket().setReceiveBufferSize(readBufferSize);
                }
                this.readBufferSizeHolder.setInt(readBufferSize);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTION_SET_READBUFFER_SIZE_EXCEPTION(), e);
            }
        }
    }

    @Override
    public int getWriteBufferSize() {
        if (this.writeBufferSizeHolder == null) {
            throw new IllegalStateException("TCPNIOConnection is not initialized");
        }
        return this.writeBufferSizeHolder.getInt();
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        if (this.writeBufferSizeHolder == null) {
            throw new IllegalStateException("TCPNIOConnection is not initialized");
        }
        if (writeBufferSize > 0) {
            try {
                int currentSendBufferSize = ((DatagramChannel)this.channel).socket().getSendBufferSize();
                if (writeBufferSize > currentSendBufferSize) {
                    ((DatagramChannel)this.channel).socket().setSendBufferSize(writeBufferSize);
                }
                this.writeBufferSizeHolder.setInt(writeBufferSize);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTION_SET_WRITEBUFFER_SIZE_EXCEPTION(), e);
            }
        }
    }

    protected final void onConnect() throws IOException {
        UDPNIOConnection.notifyProbesConnect(this);
    }

    protected final void onRead(Buffer data, int size) {
        if (size > 0) {
            UDPNIOConnection.notifyProbesRead(this, data, size);
        }
        this.checkEmptyRead(size);
    }

    protected final void onWrite(Buffer data, int size) {
        UDPNIOConnection.notifyProbesWrite(this, data, size);
    }

    void setMonitoringProbes(ConnectionProbe[] monitoringProbes) {
        this.monitoringConfig.addProbes(monitoringProbes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UDPNIOConnection");
        sb.append("{localSocketAddress=").append(this.localSocketAddressHolder);
        sb.append(", peerSocketAddress=").append(this.peerSocketAddressHolder);
        sb.append('}');
        return sb.toString();
    }
}

