/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.utils.Holder;
import org.glassfish.grizzly.utils.NullaryFunction;

public class TCPNIOConnection
extends NIOConnection {
    private static final Logger LOGGER = Grizzly.logger(TCPNIOConnection.class);
    Holder<SocketAddress> localSocketAddressHolder;
    Holder<SocketAddress> peerSocketAddressHolder;
    private NIOConnection.SettableIntHolder readBufferSizeHolder;
    private NIOConnection.SettableIntHolder writeBufferSizeHolder;
    private final AtomicReference<CompletionHandler<Connection>> connectHandlerRef = new AtomicReference();

    public TCPNIOConnection(TCPNIOTransport transport, SelectableChannel channel) {
        super(transport);
        this.channel = channel;
    }

    @Override
    protected void setSelectionKey(SelectionKey selectionKey) {
        super.setSelectionKey(selectionKey);
    }

    @Override
    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        super.setSelectorRunner(selectorRunner);
    }

    @Override
    protected void preClose() {
        this.checkConnectFailed(null);
        super.preClose();
    }

    protected boolean notifyReady() {
        return this.connectCloseSemaphor.compareAndSet(null, NOTIFICATION_INITIALIZED);
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.peerSocketAddressHolder.get();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localSocketAddressHolder.get();
    }

    protected void resetProperties() {
        if (this.channel != null) {
            this.readBufferSizeHolder = new NIOConnection.SettableIntHolder(){

                @Override
                protected int evaluate() {
                    try {
                        return ((SocketChannel)TCPNIOConnection.this.channel).socket().getReceiveBufferSize();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Can not evaluate receive buffer size", e);
                    }
                }
            };
            this.writeBufferSizeHolder = new NIOConnection.SettableIntHolder(){

                @Override
                protected int evaluate() {
                    try {
                        return ((SocketChannel)TCPNIOConnection.this.channel).socket().getSendBufferSize();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Can not evaluate send buffer size", e);
                    }
                }
            };
            this.setReadBufferSize(this.transport.getReadBufferSize());
            this.setWriteBufferSize(this.transport.getWriteBufferSize());
            int transportMaxAsyncWriteQueueSize = ((TCPNIOTransport)this.transport).getAsyncQueueIO().getWriter().getMaxPendingBytesPerConnection();
            this.setMaxAsyncWriteQueueSize(transportMaxAsyncWriteQueueSize == -2 ? this.getWriteBufferSize() * 4 : transportMaxAsyncWriteQueueSize);
            this.localSocketAddressHolder = Holder.lazyHolder(new NullaryFunction<SocketAddress>(){

                @Override
                public SocketAddress evaluate() {
                    return ((SocketChannel)TCPNIOConnection.this.channel).socket().getLocalSocketAddress();
                }
            });
            this.peerSocketAddressHolder = Holder.lazyHolder(new NullaryFunction<SocketAddress>(){

                @Override
                public SocketAddress evaluate() {
                    return ((SocketChannel)TCPNIOConnection.this.channel).socket().getRemoteSocketAddress();
                }
            });
        }
    }

    @Override
    public int getReadBufferSize() {
        if (this.readBufferSizeHolder == null) {
            throw new IllegalStateException("TCPNIOConnection is not initialized");
        }
        return this.readBufferSizeHolder.getInt();
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        if (this.readBufferSizeHolder == null) {
            throw new IllegalStateException("TCPNIOConnection is not initialized");
        }
        if (readBufferSize > 0) {
            try {
                int currentReadBufferSize = ((SocketChannel)this.channel).socket().getReceiveBufferSize();
                if (readBufferSize > currentReadBufferSize) {
                    ((SocketChannel)this.channel).socket().setReceiveBufferSize(readBufferSize);
                }
                this.readBufferSizeHolder.setInt(readBufferSize);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTION_SET_READBUFFER_SIZE_EXCEPTION(), e);
            }
        }
    }

    @Override
    public int getWriteBufferSize() {
        if (this.writeBufferSizeHolder == null) {
            throw new IllegalStateException("TCPNIOConnection is not initialized");
        }
        return this.writeBufferSizeHolder.getInt();
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        if (this.writeBufferSizeHolder == null) {
            throw new IllegalStateException("TCPNIOConnection is not initialized");
        }
        if (writeBufferSize > 0) {
            try {
                int currentSendBufferSize = ((SocketChannel)this.channel).socket().getSendBufferSize();
                if (writeBufferSize > currentSendBufferSize) {
                    ((SocketChannel)this.channel).socket().setSendBufferSize(writeBufferSize);
                }
                this.writeBufferSizeHolder.setInt(writeBufferSize);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTION_SET_WRITEBUFFER_SIZE_EXCEPTION(), e);
            }
        }
    }

    protected final void setConnectCompletionHandler(CompletionHandler<Connection> connectHandler) {
        this.connectHandlerRef.set(connectHandler);
    }

    protected final void onConnect() throws IOException {
        CompletionHandler localConnectHandler = this.connectHandlerRef.getAndSet(null);
        if (localConnectHandler != null) {
            try {
                localConnectHandler.completed(this);
            }
            catch (Exception e) {
                throw new IOException("Connect exception", e);
            }
        }
        TCPNIOConnection.notifyProbesConnect(this);
    }

    protected final void checkConnectFailed(Throwable failure) {
        CompletionHandler localConnectHandler = this.connectHandlerRef.getAndSet(null);
        if (localConnectHandler != null) {
            if (failure == null) {
                failure = new IOException("closed");
            }
            localConnectHandler.failed(failure);
        }
    }

    @Override
    protected void close0(CompletionHandler<Connection> completionHandler, boolean isClosedLocally) {
        super.close0(completionHandler, isClosedLocally);
    }

    protected final void onRead(Buffer data, int size) {
        if (size > 0) {
            TCPNIOConnection.notifyProbesRead(this, data, size);
        }
        this.checkEmptyRead(size);
    }

    protected final void onWrite(Buffer data, long size) {
        TCPNIOConnection.notifyProbesWrite(this, data, size);
    }

    void setMonitoringProbes(ConnectionProbe[] monitoringProbes) {
        this.monitoringConfig.addProbes(monitoringProbes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TCPNIOConnection");
        sb.append("{localSocketAddress=").append(this.localSocketAddressHolder);
        sb.append(", peerSocketAddress=").append(this.peerSocketAddressHolder);
        sb.append('}');
        return sb.toString();
    }
}

