/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.asyncqueue.AsyncQueueRecord;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;

public final class TaskQueue<E> {
    private volatile boolean isClosed;
    private final Queue<E> queue;
    private final AtomicReference<E> currentElement;
    private final AtomicInteger spaceInBytes = new AtomicInteger();
    private final AtomicInteger refusedBytes = new AtomicInteger();
    private final MutableMaxQueueSize maxQueueSizeHolder;
    private final AtomicInteger writeHandlersCounter = new AtomicInteger();
    protected final Queue<WriteHandlerQueueRecord> writeHandlersQueue = new ConcurrentLinkedQueue<WriteHandlerQueueRecord>();

    protected TaskQueue(MutableMaxQueueSize maxQueueSizeHolder) {
        this.maxQueueSizeHolder = maxQueueSizeHolder;
        this.currentElement = new AtomicReference();
        this.queue = new ConcurrentLinkedQueue();
    }

    public static <E> TaskQueue<E> createTaskQueue(MutableMaxQueueSize maxQueueSizeHolder) {
        return new TaskQueue<E>(maxQueueSizeHolder);
    }

    public int reserveSpace(int amount) {
        return this.spaceInBytes.addAndGet(amount);
    }

    public int releaseSpace(int amount) {
        return this.spaceInBytes.addAndGet(-amount);
    }

    public int releaseSpaceAndNotify(int amount) {
        int space = this.releaseSpace(amount);
        this.doNotify();
        return space;
    }

    public int spaceInBytes() {
        return this.spaceInBytes.get();
    }

    public AtomicInteger getRefusedBytes() {
        return this.refusedBytes;
    }

    public E obtainCurrentElement() {
        E current = this.currentElement.get();
        return current != null ? current : this.queue.poll();
    }

    public E obtainCurrentElementAndReserve() {
        E current = this.currentElement.getAndSet(null);
        return current != null ? current : (E)this.queue.poll();
    }

    public Queue<E> getQueue() {
        return this.queue;
    }

    public void notifyWritePossible(WriteHandler writeHandler, int size) {
        int reservedBytes;
        if (writeHandler == null) {
            return;
        }
        if (this.isClosed) {
            writeHandler.onError(new IOException("Connection is closed"));
            return;
        }
        int maxSize = this.maxQueueSizeHolder.getMaxQueueSize();
        if (maxSize < 0 || (reservedBytes = this.spaceInBytes()) == 0 || maxSize - reservedBytes >= size) {
            try {
                writeHandler.onWritePossible();
            }
            catch (Exception e) {
                writeHandler.onError(e);
            }
            return;
        }
        WriteHandlerQueueRecord record = new WriteHandlerQueueRecord(writeHandler, size);
        this.offerWriteHandler(record);
        reservedBytes = this.spaceInBytes();
        if (reservedBytes == 0 && this.removeWriteHandler(record)) {
            try {
                writeHandler.onWritePossible();
            }
            catch (Exception e) {
                writeHandler.onError(e);
            }
        } else {
            this.checkWriteHandlerOnClose(record);
        }
    }

    public final boolean forgetWritePossible(WriteHandler writeHandler) {
        return this.removeWriteHandler(new WriteHandlerQueueRecord(writeHandler, 0));
    }

    private void checkWriteHandlerOnClose(WriteHandlerQueueRecord record) {
        if (this.isClosed && this.removeWriteHandler(record)) {
            record.writeHandler.onError(new IOException("Connection is closed"));
        }
    }

    protected void doNotify() {
        WriteHandlerQueueRecord record;
        if (this.maxQueueSizeHolder == null || this.writeHandlersCounter.get() == 0) {
            return;
        }
        int maxSize = this.maxQueueSizeHolder.getMaxQueueSize();
        while ((record = this.pollWriteHandler()) != null) {
            int reservedBytes = this.spaceInBytes();
            if (reservedBytes == 0 || maxSize - reservedBytes >= record.size) {
                try {
                    record.writeHandler.onWritePossible();
                }
                catch (Exception e) {
                    record.writeHandler.onError(e);
                }
                continue;
            }
            this.offerWriteHandler(record);
            this.checkWriteHandlerOnClose(record);
            return;
        }
    }

    public void setCurrentElement(E task) {
        this.currentElement.set(task);
    }

    public boolean remove(E task) {
        return this.queue.remove(task);
    }

    public void offer(E task) {
        this.queue.offer(task);
    }

    public boolean isEmpty() {
        return this.spaceInBytes.get() == 0;
    }

    public void onClose() {
        Object record;
        this.isClosed = true;
        IOException error = null;
        if (!this.isEmpty()) {
            if (error == null) {
                error = new IOException("Connection closed");
            }
            while ((record = (AsyncWriteQueueRecord)this.obtainCurrentElementAndReserve()) != null) {
                ((AsyncQueueRecord)record).notifyFailure(error);
            }
        }
        while ((record = this.pollWriteHandler()) != null) {
            if (error == null) {
                error = new IOException("Connection closed");
            }
            ((WriteHandlerQueueRecord)record).writeHandler.onError(error);
        }
    }

    private void offerWriteHandler(WriteHandlerQueueRecord record) {
        this.writeHandlersCounter.incrementAndGet();
        this.writeHandlersQueue.offer(record);
    }

    private boolean removeWriteHandler(WriteHandlerQueueRecord record) {
        if (this.writeHandlersQueue.remove(record)) {
            this.writeHandlersCounter.decrementAndGet();
            return true;
        }
        return false;
    }

    private WriteHandlerQueueRecord pollWriteHandler() {
        WriteHandlerQueueRecord record = this.writeHandlersQueue.poll();
        if (record != null) {
            this.writeHandlersCounter.decrementAndGet();
            return record;
        }
        return null;
    }

    public static interface MutableMaxQueueSize {
        public int getMaxQueueSize();
    }

    private static final class WriteHandlerQueueRecord {
        private final int size;
        private final WriteHandler writeHandler;

        public WriteHandlerQueueRecord(WriteHandler writeHandler, int size) {
            this.writeHandler = writeHandler;
            this.size = size;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WriteHandlerQueueRecord other = (WriteHandlerQueueRecord)obj;
            return this.writeHandler == other.writeHandler || this.writeHandler != null && this.writeHandler.equals(other.writeHandler);
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + (this.writeHandler != null ? this.writeHandler.hashCode() : 0);
            return hash;
        }
    }
}

