/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.TransportProbe;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.monitoring.MonitoringAware;
import org.glassfish.grizzly.monitoring.MonitoringConfig;
import org.glassfish.grizzly.monitoring.MonitoringConfigImpl;
import org.glassfish.grizzly.monitoring.jmx.AbstractJmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;
import org.glassfish.grizzly.utils.StateHolder;

public abstract class AbstractTransport
implements Transport {
    protected String name;
    protected volatile boolean isBlocking;
    protected volatile boolean isStandalone;
    protected final StateHolder<Transport.State> state;
    protected Processor processor;
    protected ProcessorSelector processorSelector;
    protected IOStrategy strategy;
    protected MemoryManager memoryManager;
    protected ExecutorService workerThreadPool;
    protected ExecutorService kernelPool;
    protected AttributeBuilder attributeBuilder;
    protected int readBufferSize;
    protected int writeBufferSize;
    protected ThreadPoolConfig workerPoolConfig;
    protected ThreadPoolConfig kernelPoolConfig;
    protected boolean managedWorkerPool = true;
    protected final AbstractJmxMonitoringConfig<TransportProbe> transportMonitoringConfig = new AbstractJmxMonitoringConfig<TransportProbe>(TransportProbe.class){

        @Override
        public JmxObject createManagementObject() {
            return AbstractTransport.this.createJmxManagementObject();
        }
    };
    protected final MonitoringConfigImpl<ConnectionProbe> connectionMonitoringConfig = new MonitoringConfigImpl<ConnectionProbe>(ConnectionProbe.class);
    protected final MonitoringConfigImpl<ThreadPoolProbe> threadPoolMonitoringConfig = new MonitoringConfigImpl<ThreadPoolProbe>(ThreadPoolProbe.class);

    public AbstractTransport(String name) {
        this.name = name;
        this.state = new StateHolder<Transport.State>(Transport.State.STOP);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Override
    public void configureBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public boolean isStandalone() {
        return this.isStandalone;
    }

    @Override
    public StateHolder<Transport.State> getState() {
        return this.state;
    }

    @Override
    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public boolean isStopped() {
        Transport.State currentState = this.state.getState();
        return currentState == Transport.State.STOP || currentState == Transport.State.STOPPING;
    }

    @Override
    public boolean isPaused() {
        return this.state.getState() == Transport.State.PAUSE;
    }

    @Override
    public Processor obtainProcessor(IOEvent ioEvent, Connection connection) {
        if (this.processor != null && this.processor.isInterested(ioEvent)) {
            return this.processor;
        }
        if (this.processorSelector != null) {
            return this.processorSelector.select(ioEvent, connection);
        }
        return null;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void setProcessor(Processor processor) {
        this.processor = processor;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        return this.processorSelector;
    }

    @Override
    public void setProcessorSelector(ProcessorSelector selector) {
        this.processorSelector = selector;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public IOStrategy getIOStrategy() {
        return this.strategy;
    }

    @Override
    public void setIOStrategy(IOStrategy IOStrategy2) {
        this.strategy = IOStrategy2;
        if (this.workerPoolConfig == null) {
            this.setWorkerThreadPoolConfig(this.strategy.createDefaultWorkerPoolConfig(this));
        }
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public void setMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public ExecutorService getWorkerThreadPool() {
        return this.workerThreadPool;
    }

    @Override
    public ExecutorService getKernelThreadPool() {
        return this.kernelPool;
    }

    @Override
    public void setKernelThreadPool(ExecutorService kernelPool) {
        this.kernelPool = kernelPool;
    }

    @Override
    public void setKernelThreadPoolConfig(ThreadPoolConfig kernelPoolConfig) {
        if (this.isStopped()) {
            this.kernelPoolConfig = kernelPoolConfig;
        }
    }

    @Override
    public void setWorkerThreadPoolConfig(ThreadPoolConfig workerPoolConfig) {
        if (this.isStopped()) {
            this.workerPoolConfig = workerPoolConfig;
        }
    }

    @Override
    public ThreadPoolConfig getKernelThreadPoolConfig() {
        return this.isStopped() ? this.kernelPoolConfig : this.kernelPoolConfig.copy();
    }

    @Override
    public ThreadPoolConfig getWorkerThreadPoolConfig() {
        return this.isStopped() ? this.workerPoolConfig : this.workerPoolConfig.copy();
    }

    @Override
    public void setWorkerThreadPool(ExecutorService threadPool) {
        this.managedWorkerPool = false;
        if (threadPool instanceof MonitoringAware) {
            ((MonitoringAware)((Object)threadPool)).getMonitoringConfig().addProbes(this.threadPoolMonitoringConfig.getProbes());
        }
        this.setWorkerThreadPool0(threadPool);
    }

    protected void setWorkerThreadPool0(ExecutorService threadPool) {
        this.workerThreadPool = threadPool;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    protected void setKernelPool0(ExecutorService kernelPool) {
        this.kernelPool = kernelPool;
    }

    @Override
    public AttributeBuilder getAttributeBuilder() {
        return this.attributeBuilder;
    }

    @Override
    public void setAttributeBuilder(AttributeBuilder attributeBuilder) {
        this.attributeBuilder = attributeBuilder;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    protected abstract void closeConnection(Connection var1) throws IOException;

    @Override
    public MonitoringConfig<ConnectionProbe> getConnectionMonitoringConfig() {
        return this.connectionMonitoringConfig;
    }

    @Override
    public JmxMonitoringConfig<TransportProbe> getMonitoringConfig() {
        return this.transportMonitoringConfig;
    }

    @Override
    public MonitoringConfig<ThreadPoolProbe> getThreadPoolMonitoringConfig() {
        return this.threadPoolMonitoringConfig;
    }

    protected static void notifyProbesConfigChanged(AbstractTransport transport) {
        TransportProbe[] probes = (TransportProbe[])transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onConfigChangeEvent(transport);
            }
        }
    }

    @Override
    public abstract void start() throws IOException;

    @Override
    public abstract void stop() throws IOException;

    @Override
    public abstract void pause() throws IOException;

    @Override
    public abstract void resume() throws IOException;

    protected abstract JmxObject createJmxManagementObject();
}

