/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;
import org.glassfish.grizzly.memory.BufferArray;
import org.glassfish.grizzly.nio.AbstractNIOAsyncQueueWriter;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.utils.DebugPoint;

public final class TCPNIOAsyncQueueWriter
extends AbstractNIOAsyncQueueWriter {
    public TCPNIOAsyncQueueWriter(NIOTransport transport) {
        super(transport);
    }

    @Override
    protected AsyncWriteQueueRecord createRecord(Connection connection, Buffer message, Future<WriteResult<Buffer, SocketAddress>> future, WriteResult<Buffer, SocketAddress> currentResult, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult<Buffer, SocketAddress>> interceptor, SocketAddress dstAddress, Buffer outputBuffer, boolean isCloned, boolean isEmptyRecord) {
        return TCPNIOQueueRecord.create(connection, message, future, currentResult, completionHandler, interceptor, dstAddress, outputBuffer, isCloned, isEmptyRecord);
    }

    @Override
    protected int write0(NIOConnection connection, AsyncWriteQueueRecord queueRecord) throws IOException {
        int written;
        WriteResult currentResult = (WriteResult)queueRecord.getCurrentResult();
        Buffer buffer = queueRecord.getOutputBuffer();
        TCPNIOQueueRecord record = (TCPNIOQueueRecord)queueRecord;
        int oldPos = buffer.position();
        if (buffer.isComposite()) {
            BufferArray array = record.bufferArray;
            if (array == null) {
                array = buffer.toBufferArray();
                record.bufferArray = array;
            }
            written = ((TCPNIOTransport)this.transport).write0((Connection)connection, array);
            if (!buffer.hasRemaining()) {
                array.restore();
            }
        } else {
            written = ((TCPNIOTransport)this.transport).write0((Connection)connection, buffer);
        }
        if (written > 0) {
            buffer.position(oldPos + written);
        }
        ((TCPNIOConnection)connection).onWrite(buffer, written);
        if (currentResult != null) {
            currentResult.setMessage(buffer);
            currentResult.setWrittenSize(currentResult.getWrittenSize() + written);
            currentResult.setDstAddress(connection.getPeerAddress());
        }
        return written;
    }

    @Override
    protected final void onReadyToWrite(Connection connection) throws IOException {
        NIOConnection nioConnection = (NIOConnection)connection;
        nioConnection.enableIOEvent(IOEvent.WRITE);
    }

    private static class TCPNIOQueueRecord
    extends AsyncWriteQueueRecord {
        private static final ThreadCache.CachedTypeIndex<TCPNIOQueueRecord> CACHE_IDX = ThreadCache.obtainIndex(TCPNIOQueueRecord.class, 2);
        private BufferArray bufferArray;

        public static AsyncWriteQueueRecord create(Connection connection, Object message, Future future, WriteResult currentResult, CompletionHandler completionHandler, Interceptor interceptor, Object dstAddress, Buffer outputBuffer, boolean isCloned, boolean isEmptyRecord) {
            TCPNIOQueueRecord asyncWriteQueueRecord = ThreadCache.takeFromCache(CACHE_IDX);
            if (asyncWriteQueueRecord != null) {
                asyncWriteQueueRecord.isRecycled = false;
                asyncWriteQueueRecord.set(connection, message, future, currentResult, completionHandler, interceptor, dstAddress, outputBuffer, isCloned, isEmptyRecord);
                return asyncWriteQueueRecord;
            }
            return new TCPNIOQueueRecord(connection, message, future, currentResult, completionHandler, interceptor, dstAddress, outputBuffer, isCloned, isEmptyRecord);
        }

        public TCPNIOQueueRecord(Connection connection, Object message, Future future, WriteResult currentResult, CompletionHandler completionHandler, Interceptor interceptor, Object dstAddress, Buffer outputBuffer, boolean isCloned, boolean isEmptyRecord) {
            super(connection, message, future, currentResult, completionHandler, interceptor, dstAddress, outputBuffer, isCloned, isEmptyRecord);
        }

        @Override
        public void recycle() {
            this.checkRecycled();
            this.reset();
            this.isRecycled = true;
            if (Grizzly.isTrackingThreadCache()) {
                this.recycleTrack = new DebugPoint(new Exception(), Thread.currentThread().getName());
            }
            if (this.bufferArray != null) {
                this.bufferArray.recycle();
                this.bufferArray = null;
            }
            ThreadCache.putToCache(CACHE_IDX, this);
        }
    }
}

