/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.AbstractMemoryManager;
import org.glassfish.grizzly.memory.ByteBufferWrapper;
import org.glassfish.grizzly.memory.HeapBuffer;
import org.glassfish.grizzly.memory.MemoryProbe;
import org.glassfish.grizzly.memory.ProbeNotifier;
import org.glassfish.grizzly.memory.ThreadLocalPool;
import org.glassfish.grizzly.memory.WrapperAware;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;

public class HeapMemoryManager
extends AbstractMemoryManager<HeapBuffer>
implements WrapperAware {
    private static final ThreadCache.CachedTypeIndex<TrimmableHeapBuffer> CACHE_IDX = ThreadCache.obtainIndex(TrimmableHeapBuffer.class, 8);
    private static final ThreadCache.CachedTypeIndex<RecyclableByteBufferWrapper> BBW_CACHE_IDX = ThreadCache.obtainIndex(RecyclableByteBufferWrapper.class, 2);

    @Override
    public HeapBuffer allocate(int size) {
        return this.allocateHeapBuffer(size);
    }

    @Override
    public HeapBuffer allocateAtLeast(int size) {
        return this.allocateHeapBufferAtLeast(size);
    }

    @Override
    public HeapBuffer reallocate(HeapBuffer oldBuffer, int newSize) {
        return this.reallocateHeapBuffer(oldBuffer, newSize);
    }

    @Override
    public void release(HeapBuffer buffer) {
        this.releaseHeapBuffer(buffer);
    }

    @Override
    public JmxMonitoringConfig<MemoryProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    @Override
    public ThreadLocalPool createThreadLocalPool() {
        return new HeapBufferThreadLocalPool(this);
    }

    @Override
    protected JmxObject createJmxManagementObject() {
        return new org.glassfish.grizzly.memory.jmx.HeapMemoryManager(this);
    }

    @Override
    public HeapBuffer wrap(byte[] data) {
        return this.createTrimAwareBuffer(data, 0, data.length);
    }

    @Override
    public HeapBuffer wrap(byte[] data, int offset, int length) {
        return this.createTrimAwareBuffer(data, offset, length);
    }

    @Override
    public HeapBuffer wrap(String s) {
        return this.wrap(s, Charset.defaultCharset());
    }

    @Override
    public HeapBuffer wrap(String s, Charset charset) {
        return this.wrap(s.getBytes(charset));
    }

    @Override
    public Buffer wrap(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return this.wrap(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        }
        return this.createByteBufferWrapper(byteBuffer);
    }

    protected HeapBuffer allocateHeapBuffer(int size) {
        if (size > this.maxBufferSize) {
            return this.createTrimAwareBuffer(size);
        }
        HeapBufferThreadLocalPool threadLocalCache = HeapMemoryManager.getHeapBufferThreadLocalPool();
        if (threadLocalCache != null) {
            int remaining = threadLocalCache.remaining();
            if (remaining == 0 || remaining < size) {
                this.reallocatePoolBuffer();
            }
            return (HeapBuffer)this.allocateFromPool(threadLocalCache, size);
        }
        return this.createTrimAwareBuffer(size);
    }

    protected HeapBuffer allocateHeapBufferAtLeast(int size) {
        if (size > this.maxBufferSize) {
            return this.createTrimAwareBuffer(size);
        }
        HeapBufferThreadLocalPool threadLocalCache = HeapMemoryManager.getHeapBufferThreadLocalPool();
        if (threadLocalCache != null) {
            int remaining = threadLocalCache.remaining();
            if (remaining == 0 || remaining < size) {
                this.reallocatePoolBuffer();
                remaining = threadLocalCache.remaining();
            }
            return (HeapBuffer)this.allocateFromPool(threadLocalCache, remaining);
        }
        return this.createTrimAwareBuffer(size);
    }

    protected HeapBuffer reallocateHeapBuffer(HeapBuffer oldHeapBuffer, int newSize) {
        HeapBuffer newBuffer;
        if (oldHeapBuffer.capacity() >= newSize) {
            return oldHeapBuffer;
        }
        HeapBufferThreadLocalPool memoryPool = HeapMemoryManager.getHeapBufferThreadLocalPool();
        if (memoryPool != null && (newBuffer = memoryPool.reallocate(oldHeapBuffer, newSize)) != null) {
            ProbeNotifier.notifyBufferAllocatedFromPool(this.monitoringConfig, newSize - oldHeapBuffer.capacity());
            return newBuffer;
        }
        HeapBuffer newHeapBuffer = this.allocateHeapBuffer(newSize);
        oldHeapBuffer.flip();
        return newHeapBuffer.put(oldHeapBuffer);
    }

    protected void releaseHeapBuffer(HeapBuffer heapBuffer) {
        HeapBufferThreadLocalPool memoryPool = HeapMemoryManager.getHeapBufferThreadLocalPool();
        if (memoryPool != null && memoryPool.release(heapBuffer.clear())) {
            ProbeNotifier.notifyBufferReleasedToPool(this.monitoringConfig, heapBuffer.capacity());
        }
    }

    private void reallocatePoolBuffer() {
        byte[] heap = new byte[this.maxBufferSize];
        HeapBufferThreadLocalPool threadLocalCache = (HeapBufferThreadLocalPool)HeapMemoryManager.getThreadLocalPool();
        threadLocalCache.reset(heap, 0, this.maxBufferSize);
    }

    TrimmableHeapBuffer createTrimAwareBuffer(int length) {
        return this.createTrimAwareBuffer(new byte[length], 0, length);
    }

    TrimmableHeapBuffer createTrimAwareBuffer(byte[] heap, int offset, int length) {
        TrimmableHeapBuffer buffer = ThreadCache.takeFromCache(CACHE_IDX);
        if (buffer != null) {
            buffer.initialize(this, heap, offset, length);
            return buffer;
        }
        return new TrimmableHeapBuffer(this, heap, offset, length);
    }

    private ByteBufferWrapper createByteBufferWrapper(ByteBuffer underlyingByteBuffer) {
        RecyclableByteBufferWrapper buffer = ThreadCache.takeFromCache(BBW_CACHE_IDX);
        if (buffer != null) {
            buffer.initialize(underlyingByteBuffer);
            return buffer;
        }
        return new RecyclableByteBufferWrapper(underlyingByteBuffer);
    }

    private static HeapBufferThreadLocalPool getHeapBufferThreadLocalPool() {
        return (HeapBufferThreadLocalPool)HeapMemoryManager.getThreadLocalPool();
    }

    private static final class RecyclableByteBufferWrapper
    extends ByteBufferWrapper
    implements Cacheable {
        private RecyclableByteBufferWrapper(ByteBuffer underlyingByteBuffer) {
            super(underlyingByteBuffer);
        }

        @Override
        public void recycle() {
            this.allowBufferDispose = false;
            ThreadCache.putToCache(BBW_CACHE_IDX, this);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.recycle();
        }

        private void initialize(ByteBuffer underlyingByteBuffer) {
            this.visible = underlyingByteBuffer;
            this.disposeStackTrace = null;
        }
    }

    private static final class TrimmableHeapBuffer
    extends HeapBuffer
    implements AbstractMemoryManager.TrimAware {
        private HeapMemoryManager mm;

        private TrimmableHeapBuffer(HeapMemoryManager mm, byte[] heap, int offset, int capacity) {
            super(heap, offset, capacity);
            this.mm = mm;
        }

        @Override
        public void trim() {
            HeapBufferThreadLocalPool threadLocalCache;
            this.checkDispose();
            int sizeToReturn = this.cap - this.pos;
            if (sizeToReturn > 0 && (threadLocalCache = (HeapBufferThreadLocalPool)AbstractMemoryManager.getThreadLocalPool()) != null) {
                if (threadLocalCache.isLastAllocated(this)) {
                    this.flip();
                    this.cap = this.lim;
                    threadLocalCache.reduceLastAllocated(this);
                    return;
                }
                if (threadLocalCache.wantReset(sizeToReturn)) {
                    this.flip();
                    this.cap = this.lim;
                    threadLocalCache.reset(this.heap, this.offset + this.cap, sizeToReturn);
                    return;
                }
            }
            super.trim();
        }

        @Override
        public void recycle() {
            this.allowBufferDispose = false;
            ThreadCache.putToCache(CACHE_IDX, this);
        }

        @Override
        public void dispose() {
            this.prepareDispose();
            this.mm.release(this);
            this.mm = null;
            this.byteBuffer = null;
            this.heap = null;
            this.pos = 0;
            this.offset = 0;
            this.lim = 0;
            this.cap = 0;
            this.recycle();
        }

        @Override
        protected HeapBuffer createHeapBuffer(byte[] heap, int offset, int capacity) {
            return this.mm.createTrimAwareBuffer(heap, offset, capacity);
        }

        void initialize(HeapMemoryManager mm, byte[] heap, int offset, int length) {
            this.mm = mm;
            this.heap = heap;
            this.offset = offset;
            this.pos = 0;
            this.cap = length;
            this.lim = length;
            this.disposeStackTrace = null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TrimmableHeapBuffer that = (TrimmableHeapBuffer)o;
            return !(this.mm == null ? that.mm != null : !this.mm.equals(that.mm));
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.mm != null ? this.mm.hashCode() : 0);
            return result;
        }
    }

    private static final class HeapBufferThreadLocalPool
    implements ThreadLocalPool<HeapBuffer> {
        private byte[] pool;
        private int pos;
        private int lim;
        private final ByteBuffer[] byteBufferCache;
        private int byteBufferCacheSize = 0;
        private final HeapMemoryManager mm;

        public HeapBufferThreadLocalPool(HeapMemoryManager mm) {
            this(mm, 16);
        }

        public HeapBufferThreadLocalPool(HeapMemoryManager mm, int maxByteBufferCacheSize) {
            this.byteBufferCache = new ByteBuffer[maxByteBufferCacheSize];
            this.mm = mm;
        }

        @Override
        public HeapBuffer allocate(int size) {
            TrimmableHeapBuffer allocated = this.mm.createTrimAwareBuffer(this.pool, this.pos, size);
            if (this.byteBufferCacheSize > 0) {
                allocated.byteBuffer = this.byteBufferCache[--this.byteBufferCacheSize];
                this.byteBufferCache[this.byteBufferCacheSize] = null;
            }
            this.pos += size;
            return allocated;
        }

        @Override
        public HeapBuffer reallocate(HeapBuffer heapBuffer, int newSize) {
            if (this.isLastAllocated(heapBuffer)) {
                int diff = newSize - heapBuffer.cap;
                if (this.remaining() >= diff) {
                    this.pos += diff;
                    heapBuffer.cap = newSize;
                    heapBuffer.lim = newSize;
                    return heapBuffer;
                }
            }
            return null;
        }

        @Override
        public boolean release(HeapBuffer heapBuffer) {
            boolean result;
            boolean canCacheByteBuffer;
            boolean bl = canCacheByteBuffer = heapBuffer.byteBuffer != null && this.byteBufferCacheSize < this.byteBufferCache.length;
            if (this.isLastAllocated(heapBuffer)) {
                this.pos -= heapBuffer.cap;
                result = true;
            } else if (this.tryReset(heapBuffer)) {
                result = true;
            } else {
                canCacheByteBuffer = canCacheByteBuffer && this.pool == heapBuffer.heap;
                result = false;
            }
            if (canCacheByteBuffer) {
                this.byteBufferCache[this.byteBufferCacheSize++] = heapBuffer.byteBuffer;
            }
            return result;
        }

        @Override
        public void reset(HeapBuffer heapBuffer) {
            byte[] heap = heapBuffer.array();
            if (this.pool != heap) {
                this.clearByteBufferCache();
            }
            this.pool = heap;
            this.pos = heapBuffer.offset;
            this.lim = this.pos + heapBuffer.cap;
        }

        public void reset(byte[] heap, int offset, int capacity) {
            if (this.pool != heap) {
                this.clearByteBufferCache();
            }
            this.pool = heap;
            this.pos = offset;
            this.lim = capacity;
        }

        @Override
        public boolean tryReset(HeapBuffer heapBuffer) {
            if (this.wantReset(heapBuffer.remaining()) && heapBuffer.array() != this.pool) {
                this.reset(heapBuffer);
                return true;
            }
            return false;
        }

        @Override
        public boolean wantReset(int size) {
            return !this.hasRemaining() || this.remaining() < size;
        }

        @Override
        public boolean isLastAllocated(HeapBuffer oldHeapBuffer) {
            return oldHeapBuffer.heap == this.pool && oldHeapBuffer.offset + oldHeapBuffer.cap == this.pos;
        }

        @Override
        public HeapBuffer reduceLastAllocated(HeapBuffer heapBuffer) {
            this.pos = heapBuffer.offset + heapBuffer.cap;
            return null;
        }

        @Override
        public int remaining() {
            return this.lim - this.pos;
        }

        @Override
        public boolean hasRemaining() {
            return this.pos < this.lim;
        }

        public String toString() {
            return "(pool=" + this.pool.length + " pos=" + this.pos + " cap=" + this.lim + ')';
        }

        private void clearByteBufferCache() {
            Arrays.fill(this.byteBufferCache, 0, this.byteBufferCacheSize, null);
            this.byteBufferCacheSize = 0;
        }
    }
}

