/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import java.util.concurrent.Future;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueRecord;
import org.glassfish.grizzly.utils.DebugPoint;

public class AsyncWriteQueueRecord
extends AsyncQueueRecord<WriteResult> {
    private static final ThreadCache.CachedTypeIndex<AsyncWriteQueueRecord> CACHE_IDX = ThreadCache.obtainIndex(AsyncWriteQueueRecord.class, 2);
    private boolean isEmptyRecord;
    private Object dstAddress;
    private boolean isCloned;
    private Buffer outputBuffer;

    public static AsyncWriteQueueRecord create(Connection connection, Object message, Future future, WriteResult currentResult, CompletionHandler completionHandler, Interceptor interceptor, Object dstAddress, Buffer outputBuffer, boolean isCloned, boolean isEmptyRecord) {
        AsyncWriteQueueRecord asyncWriteQueueRecord = ThreadCache.takeFromCache(CACHE_IDX);
        if (asyncWriteQueueRecord != null) {
            asyncWriteQueueRecord.isRecycled = false;
            asyncWriteQueueRecord.set(connection, message, future, currentResult, completionHandler, interceptor, dstAddress, outputBuffer, isCloned, isEmptyRecord);
            return asyncWriteQueueRecord;
        }
        return new AsyncWriteQueueRecord(connection, message, future, currentResult, completionHandler, interceptor, dstAddress, outputBuffer, isCloned, isEmptyRecord);
    }

    protected AsyncWriteQueueRecord(Connection connection, Object message, Future future, WriteResult currentResult, CompletionHandler completionHandler, Interceptor interceptor, Object dstAddress, Buffer outputBuffer, boolean isCloned, boolean isEmptyRecord) {
        super(connection, message, future, currentResult, completionHandler, interceptor);
        this.dstAddress = dstAddress;
        this.outputBuffer = outputBuffer;
        this.isCloned = isCloned;
        this.isEmptyRecord = isEmptyRecord;
    }

    protected void set(Connection connection, Object message, Future future, WriteResult currentResult, CompletionHandler completionHandler, Interceptor interceptor, Object dstAddress, Buffer outputBuffer, boolean isCloned, boolean isEmptyRecord) {
        super.set(connection, message, future, currentResult, completionHandler, interceptor);
        this.dstAddress = dstAddress;
        this.outputBuffer = outputBuffer;
        this.isCloned = isCloned;
        this.isEmptyRecord = isEmptyRecord;
    }

    public final boolean isCloned() {
        this.checkRecycled();
        return this.isCloned;
    }

    public final void setCloned(boolean isCloned) {
        this.checkRecycled();
        this.isCloned = isCloned;
    }

    public final Object getDstAddress() {
        this.checkRecycled();
        return this.dstAddress;
    }

    public Buffer getOutputBuffer() {
        this.checkRecycled();
        return this.outputBuffer;
    }

    public void setOutputBuffer(Buffer outputBuffer) {
        this.checkRecycled();
        this.outputBuffer = outputBuffer;
    }

    public boolean isEmptyRecord() {
        return this.isEmptyRecord;
    }

    public void setEmptyRecord(boolean isEmptyRecord) {
        this.isEmptyRecord = isEmptyRecord;
    }

    protected final void reset() {
        this.set(null, null, null, null, null, null, null, null, false, false);
    }

    @Override
    public void recycle() {
        this.checkRecycled();
        this.reset();
        this.isRecycled = true;
        if (Grizzly.isTrackingThreadCache()) {
            this.recycleTrack = new DebugPoint(new Exception(), Thread.currentThread().getName());
        }
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

