/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import java.util.concurrent.Future;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.asyncqueue.AsyncQueueRecord;
import org.glassfish.grizzly.utils.DebugPoint;

public final class AsyncReadQueueRecord
extends AsyncQueueRecord<ReadResult> {
    private static final ThreadCache.CachedTypeIndex<AsyncReadQueueRecord> CACHE_IDX = ThreadCache.obtainIndex(AsyncReadQueueRecord.class, 2);
    private Buffer remainderBuffer;

    public static AsyncReadQueueRecord create(Connection connection, Object message, Future future, ReadResult currentResult, CompletionHandler completionHandler, Interceptor<ReadResult> interceptor) {
        AsyncReadQueueRecord asyncReadQueueRecord = ThreadCache.takeFromCache(CACHE_IDX);
        if (asyncReadQueueRecord != null) {
            asyncReadQueueRecord.isRecycled = false;
            asyncReadQueueRecord.set(connection, message, future, currentResult, completionHandler, interceptor);
            return asyncReadQueueRecord;
        }
        return new AsyncReadQueueRecord(connection, message, future, currentResult, completionHandler, interceptor);
    }

    private AsyncReadQueueRecord(Connection connection, Object message, Future future, ReadResult currentResult, CompletionHandler completionHandler, Interceptor<ReadResult> interceptor) {
        super(connection, message, future, currentResult, completionHandler, interceptor);
    }

    public Buffer getRemainderBuffer() {
        this.checkRecycled();
        return this.remainderBuffer;
    }

    public void setRemainderBuffer(Buffer remainderBuffer) {
        this.checkRecycled();
        this.remainderBuffer = remainderBuffer;
    }

    protected final void reset() {
        this.set(null, null, null, null, null, null);
        this.remainderBuffer = null;
    }

    @Override
    public void recycle() {
        this.checkRecycled();
        this.reset();
        this.isRecycled = true;
        if (Grizzly.isTrackingThreadCache()) {
            this.recycleTrack = new DebugPoint(new Exception(), Thread.currentThread().getName());
        }
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

