/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.ThreadCache;

public class ProcessorResult {
    private static final ProcessorResult NOT_RUN_RESULT = new ProcessorResult(Status.NOT_RUN, null, false);
    private static final ProcessorResult COMPLETE_RESULT = new ProcessorResult(Status.COMPLETE, null, false);
    private static final ProcessorResult LEAVE_RESULT = new ProcessorResult(Status.LEAVE, null, false);
    private static final ProcessorResult REREGISTER_RESULT = new ProcessorResult(Status.REREGISTER, null, false);
    private static final ProcessorResult ERROR_RESULT = new ProcessorResult(Status.ERROR);
    private static final ProcessorResult TERMINATE_RESULT = new ProcessorResult(Status.TERMINATE, null, false);
    private static final ThreadCache.CachedTypeIndex<ProcessorResult> CACHE_IDX = ThreadCache.obtainIndex(ProcessorResult.class, 1);
    private final boolean canRecycle;
    private Status status;
    private Object context;

    private static ProcessorResult create() {
        ProcessorResult result = ThreadCache.takeFromCache(CACHE_IDX);
        if (result != null) {
            return result;
        }
        return new ProcessorResult();
    }

    public static ProcessorResult createComplete() {
        return COMPLETE_RESULT;
    }

    public static ProcessorResult createLeave() {
        return LEAVE_RESULT;
    }

    public static ProcessorResult createReregister() {
        return REREGISTER_RESULT;
    }

    public static ProcessorResult createError() {
        return ERROR_RESULT;
    }

    public static ProcessorResult createError(Object description) {
        return ProcessorResult.create().setStatus(Status.ERROR).setContext(description);
    }

    public static ProcessorResult createRerun(Context context) {
        return ProcessorResult.create().setStatus(Status.RERUN).setContext(context);
    }

    public static ProcessorResult createTerminate() {
        return TERMINATE_RESULT;
    }

    public static ProcessorResult createNotRun() {
        return NOT_RUN_RESULT;
    }

    private ProcessorResult() {
        this(null, null);
    }

    private ProcessorResult(Status status) {
        this(status, null);
    }

    private ProcessorResult(Status status, Object context) {
        this(status, context, true);
    }

    private ProcessorResult(Status status, Object context, boolean canRecycle) {
        this.status = status;
        this.context = context;
        this.canRecycle = canRecycle;
    }

    public Status getStatus() {
        return this.status;
    }

    protected ProcessorResult setStatus(Status status) {
        this.status = status;
        return this;
    }

    public Object getContext() {
        return this.context;
    }

    protected ProcessorResult setContext(Object context) {
        this.context = context;
        return this;
    }

    public void recycle() {
        if (this.canRecycle) {
            this.status = null;
            this.context = null;
        }
    }

    public static enum Status {
        COMPLETE,
        LEAVE,
        REREGISTER,
        RERUN,
        ERROR,
        TERMINATE,
        NOT_RUN;

    }
}

