/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventProcessingHandler;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.Reader;
import org.glassfish.grizzly.SocketBinder;
import org.glassfish.grizzly.SocketConnectorHandler;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.StandaloneProcessorSelector;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.Writer;
import org.glassfish.grizzly.asyncqueue.AsyncQueueEnabledTransport;
import org.glassfish.grizzly.asyncqueue.AsyncQueueIO;
import org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainEnabledTransport;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.nio.DefaultSelectionKeyHandler;
import org.glassfish.grizzly.nio.DefaultSelectorHandler;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.RoundRobinConnectionDistributor;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorIO;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorPool;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorsEnabledTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOAsyncQueueReader;
import org.glassfish.grizzly.nio.transport.UDPNIOAsyncQueueWriter;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.UDPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTemporarySelectorReader;
import org.glassfish.grizzly.nio.transport.UDPNIOTemporarySelectorWriter;
import org.glassfish.grizzly.nio.transport.UDPNIOTransportFilter;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;
import org.glassfish.grizzly.utils.Exceptions;

public final class UDPNIOTransport
extends NIOTransport
implements SocketBinder,
SocketConnectorHandler,
AsyncQueueEnabledTransport,
FilterChainEnabledTransport,
TemporarySelectorsEnabledTransport {
    private static final Logger LOGGER = Grizzly.logger(UDPNIOTransport.class);
    private static final String DEFAULT_TRANSPORT_NAME = "UDPNIOTransport";
    protected final int serverSocketSoTimeout = 0;
    protected boolean reuseAddress = true;
    protected int connectionTimeout = 30000;
    protected final Collection<UDPNIOServerConnection> serverConnections;
    protected final AsyncQueueIO<SocketAddress> asyncQueueIO;
    protected TemporarySelectorIO temporarySelectorIO;
    private final Filter transportFilter;
    protected final RegisterChannelCompletionHandler registerChannelCompletionHandler;
    private final UDPNIOConnectorHandler connectorHandler = new TransportConnectorHandler();

    public UDPNIOTransport() {
        this(DEFAULT_TRANSPORT_NAME);
    }

    public UDPNIOTransport(String name) {
        super(name);
        this.readBufferSize = -1;
        this.writeBufferSize = -1;
        this.registerChannelCompletionHandler = new RegisterChannelCompletionHandler();
        this.asyncQueueIO = new AsyncQueueIO<SocketAddress>(new UDPNIOAsyncQueueReader(this), new UDPNIOAsyncQueueWriter(this));
        this.temporarySelectorIO = new TemporarySelectorIO(new UDPNIOTemporarySelectorReader(this), new UDPNIOTemporarySelectorWriter(this));
        this.transportFilter = new UDPNIOTransportFilter(this);
        this.serverConnections = new ConcurrentLinkedQueue<UDPNIOServerConnection>();
    }

    @Override
    public UDPNIOServerConnection bind(int port) throws IOException {
        return this.bind(new InetSocketAddress(port));
    }

    @Override
    public UDPNIOServerConnection bind(String host, int port) throws IOException {
        return this.bind(host, port, 50);
    }

    @Override
    public UDPNIOServerConnection bind(String host, int port, int backlog) throws IOException {
        return this.bind(new InetSocketAddress(host, port), backlog);
    }

    @Override
    public UDPNIOServerConnection bind(SocketAddress socketAddress) throws IOException {
        return this.bind(socketAddress, 4096);
    }

    @Override
    public UDPNIOServerConnection bind(SocketAddress socketAddress, int backlog) throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        DatagramChannel serverDatagramChannel = DatagramChannel.open();
        NIOConnection serverConnection = null;
        try {
            DatagramSocket socket = serverDatagramChannel.socket();
            socket.setReuseAddress(this.reuseAddress);
            socket.setSoTimeout(0);
            socket.bind(socketAddress);
            serverDatagramChannel.configureBlocking(false);
            serverConnection = this.obtainServerNIOConnection(serverDatagramChannel);
            this.serverConnections.add((UDPNIOServerConnection)serverConnection);
            if (!this.isStopped()) {
                ((UDPNIOConnection)serverConnection).register();
            }
            NIOConnection nIOConnection = serverConnection;
            return nIOConnection;
        }
        catch (Exception e) {
            if (serverConnection != null) {
                this.serverConnections.remove(serverConnection);
                try {
                    serverConnection.close();
                }
                catch (IOException ignored) {}
            } else {
                try {
                    serverDatagramChannel.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            throw Exceptions.makeIOException(e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public UDPNIOServerConnection bind(String host, PortRange portRange, int backlog) throws IOException {
        int offset;
        IOException ioException = null;
        int lower = portRange.getLower();
        int range = portRange.getUpper() - lower + 1;
        int start = offset = RANDOM.nextInt(range);
        while (true) {
            int port = lower + offset;
            try {
                UDPNIOServerConnection serverConnection = this.bind(host, port, backlog);
                return serverConnection;
            }
            catch (IOException e) {
                ioException = e;
                if ((offset = (offset + 1) % range) != start) continue;
                throw ioException;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(Connection connection) throws IOException {
        block8: {
            ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
            lock.lock();
            try {
                if (connection == null || !this.serverConnections.remove(connection)) break block8;
                GrizzlyFuture<Connection> future = ((UDPNIOServerConnection)connection).unbind(null);
                try {
                    future.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error unbinding connection: " + connection, e);
                }
                finally {
                    future.markForRecycle(true);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindAll() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            for (UDPNIOServerConnection serverConnection : this.serverConnections) {
                try {
                    this.unbind(serverConnection);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, "Exception occurred when closing server connection: " + serverConnection, e);
                }
            }
            this.serverConnections.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public GrizzlyFuture<Connection> connect() throws IOException {
        return this.connectorHandler.connect();
    }

    public GrizzlyFuture<Connection> connect(String host, int port) throws IOException {
        return this.connectorHandler.connect(host, port);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress) throws IOException {
        return this.connectorHandler.connect(remoteAddress);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, CompletionHandler<Connection> completionHandler) throws IOException {
        return this.connectorHandler.connect(remoteAddress, completionHandler);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        return this.connectorHandler.connect(remoteAddress, localAddress);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) throws IOException {
        return this.connectorHandler.connect(remoteAddress, localAddress, completionHandler);
    }

    @Override
    protected void closeConnection(Connection connection) throws IOException {
        SelectableChannel nioChannel = ((NIOConnection)connection).getChannel();
        if (nioChannel != null) {
            try {
                nioChannel.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "TCPNIOTransport.closeChannel exception", e);
            }
        }
        if (this.asyncQueueIO != null) {
            AsyncQueueWriter<SocketAddress> writer;
            AsyncQueueReader<SocketAddress> reader = this.asyncQueueIO.getReader();
            if (reader != null) {
                reader.onClose(connection);
            }
            if ((writer = this.asyncQueueIO.getWriter()) != null) {
                writer.onClose(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            Transport.State currentState = (Transport.State)((Object)this.state.getState());
            if (currentState != Transport.State.STOP) {
                LOGGER.log(Level.WARNING, "Transport is not in STOP or BOUND state!");
            }
            this.state.setState(Transport.State.STARTING);
            if (this.selectorHandler == null) {
                this.selectorHandler = new DefaultSelectorHandler();
            }
            if (this.selectionKeyHandler == null) {
                this.selectionKeyHandler = new DefaultSelectionKeyHandler();
            }
            if (this.processor == null && this.processorSelector == null) {
                this.processor = new StandaloneProcessor();
            }
            if (this.selectorRunnersCount <= 0) {
                this.selectorRunnersCount = Runtime.getRuntime().availableProcessors();
            }
            if (this.nioChannelDistributor == null) {
                this.nioChannelDistributor = new RoundRobinConnectionDistributor(this);
            }
            if (this.kernelPool == null) {
                this.kernelPoolConfig.setMemoryManager(this.memoryManager);
                this.setKernelPool0(GrizzlyExecutorService.createInstance(this.kernelPoolConfig));
            }
            if (this.workerThreadPool == null && this.workerPoolConfig != null) {
                this.workerPoolConfig.getInitialMonitoringConfig().addProbes((ThreadPoolProbe[])this.getThreadPoolMonitoringConfig().getProbes());
                this.workerPoolConfig.setMemoryManager(this.memoryManager);
                this.setWorkerThreadPool0(GrizzlyExecutorService.createInstance(this.workerPoolConfig));
            }
            int selectorPoolSize = 32;
            if (this.workerThreadPool instanceof AbstractThreadPool) {
                selectorPoolSize = this.strategy instanceof SameThreadIOStrategy ? this.selectorRunnersCount : Math.min(((AbstractThreadPool)this.workerThreadPool).getConfig().getMaxPoolSize(), selectorPoolSize);
            }
            if (this.strategy == null) {
                this.strategy = WorkerThreadIOStrategy.getInstance();
            }
            this.temporarySelectorIO.setSelectorPool(new TemporarySelectorPool(selectorPoolSize));
            this.startSelectorRunners();
            this.registerServerConnections();
            this.state.setState(Transport.State.START);
            UDPNIOTransport.notifyProbesStart(this);
        }
        finally {
            lock.unlock();
        }
    }

    private void registerServerConnections() {
        for (UDPNIOServerConnection serverConnection : this.serverConnections) {
            try {
                serverConnection.register();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception occurred when starting server connection: " + serverConnection, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (this.state.getState() == Transport.State.PAUSE) {
                this.resume();
            }
            this.unbindAll();
            this.state.setState(Transport.State.STOP);
            this.stopSelectorRunners();
            if (this.workerThreadPool != null && this.managedWorkerPool) {
                this.workerThreadPool.shutdown();
                this.workerThreadPool = null;
            }
            if (this.kernelPool != null) {
                this.kernelPool.shutdownNow();
                this.kernelPool = null;
            }
            UDPNIOTransport.notifyProbesStop(this);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (this.state.getState() != Transport.State.START) {
                LOGGER.log(Level.WARNING, "Transport is not in START state!");
            }
            this.state.setState(Transport.State.PAUSE);
            UDPNIOTransport.notifyProbesPause(this);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (this.state.getState() != Transport.State.PAUSE) {
                LOGGER.log(Level.WARNING, "Transport is not in PAUSE state!");
            }
            this.state.setState(Transport.State.START);
            UDPNIOTransport.notifyProbesResume(this);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public synchronized void configureStandalone(boolean isStandalone) {
        if (this.isStandalone != isStandalone) {
            this.isStandalone = isStandalone;
            if (isStandalone) {
                this.processor = StandaloneProcessor.INSTANCE;
                this.processorSelector = StandaloneProcessorSelector.INSTANCE;
            } else {
                this.processor = null;
                this.processorSelector = null;
            }
        }
    }

    @Override
    public Filter getTransportFilter() {
        return this.transportFilter;
    }

    @Override
    public AsyncQueueIO getAsyncQueueIO() {
        return this.asyncQueueIO;
    }

    @Override
    public TemporarySelectorIO getTemporarySelectorIO() {
        return this.temporarySelectorIO;
    }

    @Override
    public void setTemporarySelectorIO(TemporarySelectorIO temporarySelectorIO) {
        this.temporarySelectorIO = temporarySelectorIO;
        UDPNIOTransport.notifyProbesConfigChanged(this);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        UDPNIOTransport.notifyProbesConfigChanged(this);
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        UDPNIOTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public Transport.IOEventReg fireIOEvent(IOEvent ioEvent, Connection connection, IOEventProcessingHandler processingHandler) throws IOException {
        try {
            Processor conProcessor = connection.obtainProcessor(ioEvent);
            if (ProcessorExecutor.execute(Context.create(connection, conProcessor, ioEvent, processingHandler))) {
                return Transport.IOEventReg.REGISTER;
            }
            return Transport.IOEventReg.DEREGISTER;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "IOException occurred on fireIOEvent().connection={0} event={1}", new Object[]{connection, ioEvent});
            throw e;
        }
        catch (Exception e) {
            String text = new StringBuilder(256).append("Unexpected exception occurred fireIOEvent().").append("connection=").append(connection).append(" event=").append((Object)ioEvent).toString();
            LOGGER.log(Level.WARNING, text, e);
            throw new IOException(e.getClass() + ": " + text);
        }
    }

    @Override
    public Reader getReader(Connection connection) {
        return this.getReader(connection.isBlocking());
    }

    @Override
    public Reader getReader(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getReader();
        }
        return this.getAsyncQueueIO().getReader();
    }

    @Override
    public Writer getWriter(Connection connection) {
        return this.getWriter(connection.isBlocking());
    }

    @Override
    public Writer getWriter(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getWriter();
        }
        return this.getAsyncQueueIO().getWriter();
    }

    private int readConnected(UDPNIOConnection connection, Buffer buffer, ReadResult<Buffer, SocketAddress> currentResult) throws IOException {
        boolean hasRead;
        int read;
        SocketAddress peerAddress = connection.getPeerAddress();
        int oldPos = buffer.position();
        if (buffer.isComposite()) {
            ByteBufferArray array = buffer.toByteBufferArray();
            ByteBuffer[] byteBuffers = (ByteBuffer[])array.getArray();
            int size = array.size();
            read = (int)((DatagramChannel)connection.getChannel()).read(byteBuffers, 0, size);
            array.restore();
            array.recycle();
        } else {
            read = ((DatagramChannel)connection.getChannel()).read(buffer.toByteBuffer());
        }
        boolean bl = hasRead = read > 0;
        if (hasRead) {
            buffer.position(oldPos + read);
        }
        if (hasRead && currentResult != null) {
            currentResult.setMessage(buffer);
            currentResult.setReadSize(currentResult.getReadSize() + read);
            currentResult.setSrcAddress(peerAddress);
        }
        return read;
    }

    private int readNonConnected(UDPNIOConnection connection, Buffer buffer, ReadResult<Buffer, SocketAddress> currentResult) throws IOException {
        boolean hasRead;
        int oldPos = buffer.position();
        if (buffer.isComposite()) {
            throw new IllegalStateException("Can not read from non-connection UDP connection into CompositeBuffer");
        }
        ByteBuffer underlyingBB = buffer.toByteBuffer();
        int initialBufferPos = underlyingBB.position();
        SocketAddress peerAddress = ((DatagramChannel)connection.getChannel()).receive(underlyingBB);
        int read = underlyingBB.position() - initialBufferPos;
        boolean bl = hasRead = read > 0;
        if (hasRead) {
            buffer.position(oldPos + read);
        }
        if (hasRead && currentResult != null) {
            currentResult.setMessage(buffer);
            currentResult.setReadSize(currentResult.getReadSize() + read);
            currentResult.setSrcAddress(peerAddress);
        }
        return read;
    }

    public int read(UDPNIOConnection connection, Buffer buffer) throws IOException {
        return this.read(connection, buffer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(UDPNIOConnection connection, Buffer buffer, ReadResult<Buffer, SocketAddress> currentResult) throws IOException {
        boolean isAllocate;
        int read = 0;
        boolean bl = isAllocate = buffer == null && currentResult != null;
        if (isAllocate) {
            buffer = this.memoryManager.allocateAtLeast(connection.getReadBufferSize());
        }
        try {
            read = connection.isConnected() ? this.readConnected(connection, buffer, currentResult) : this.readNonConnected(connection, buffer, currentResult);
            connection.onRead(buffer, read);
        }
        finally {
            if (isAllocate && read <= 0) {
                buffer.dispose();
                buffer = null;
            }
        }
        return read;
    }

    public int write(UDPNIOConnection connection, SocketAddress dstAddress, Buffer buffer) throws IOException {
        return this.write(connection, dstAddress, buffer, null);
    }

    public int write(UDPNIOConnection connection, SocketAddress dstAddress, Buffer buffer, WriteResult<Buffer, SocketAddress> currentResult) throws IOException {
        int written;
        int oldPos = buffer.position();
        if (dstAddress != null) {
            written = ((DatagramChannel)connection.getChannel()).send(buffer.toByteBuffer(), dstAddress);
        } else if (buffer.isComposite()) {
            ByteBufferArray array = buffer.toByteBufferArray();
            ByteBuffer[] byteBuffers = (ByteBuffer[])array.getArray();
            int size = array.size();
            written = (int)((DatagramChannel)connection.getChannel()).write(byteBuffers, 0, size);
            array.restore();
            array.recycle();
        } else {
            written = ((DatagramChannel)connection.getChannel()).write(buffer.toByteBuffer());
        }
        if (written > 0) {
            buffer.position(oldPos + written);
        }
        connection.onWrite(buffer, written);
        if (currentResult != null) {
            currentResult.setMessage(buffer);
            currentResult.setWrittenSize(currentResult.getWrittenSize() + written);
            currentResult.setDstAddress(connection.getPeerAddress());
        }
        return written;
    }

    UDPNIOConnection obtainNIOConnection(DatagramChannel channel) {
        UDPNIOConnection connection = new UDPNIOConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    UDPNIOServerConnection obtainServerNIOConnection(DatagramChannel channel) {
        UDPNIOServerConnection connection = new UDPNIOServerConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    protected void configureNIOConnection(UDPNIOConnection connection) {
        connection.configureBlocking(this.isBlocking);
        connection.configureStandalone(this.isStandalone);
        connection.setProcessor(this.processor);
        connection.setProcessorSelector(this.processorSelector);
        connection.setMonitoringProbes((ConnectionProbe[])this.connectionMonitoringConfig.getProbes());
    }

    @Override
    protected JmxObject createJmxManagementObject() {
        return new org.glassfish.grizzly.nio.transport.jmx.UDPNIOTransport(this);
    }

    private void resetByteBuffers(ByteBuffer[] byteBuffers, int processed) {
        int index = 0;
        while (processed > 0) {
            ByteBuffer byteBuffer = byteBuffers[index++];
            byteBuffer.position(0);
            processed -= byteBuffer.remaining();
        }
    }

    protected class TransportConnectorHandler
    extends UDPNIOConnectorHandler {
        public TransportConnectorHandler() {
            super(UDPNIOTransport.this);
        }

        @Override
        public Processor getProcessor() {
            return UDPNIOTransport.this.getProcessor();
        }

        @Override
        public ProcessorSelector getProcessorSelector() {
            return UDPNIOTransport.this.getProcessorSelector();
        }
    }

    protected class RegisterChannelCompletionHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        protected RegisterChannelCompletionHandler() {
        }

        @Override
        public void completed(RegisterChannelResult result) {
            SelectionKey selectionKey = result.getSelectionKey();
            UDPNIOConnection connection = (UDPNIOConnection)UDPNIOTransport.this.getSelectionKeyHandler().getConnectionForKey(selectionKey);
            if (connection != null) {
                SelectorRunner selectorRunner = result.getSelectorRunner();
                connection.setSelectionKey(selectionKey);
                connection.setSelectorRunner(selectorRunner);
            }
        }
    }
}

