/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.grizzly.ThreadCache;

public final class Charsets {
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private static final ConcurrentHashMap<String, Charset> charsetAliasMap = new ConcurrentHashMap();
    public static final Charset ASCII_CHARSET = Charsets.lookupCharset("ASCII");
    public static final Charset UTF8_CHARSET = Charsets.lookupCharset("UTF-8");
    public static final Charset DEFAULT_CHARSET = Charsets.lookupCharset("ISO-8859-1");
    public static final int CODECS_CACHE_SIZE = 4;
    private static final CharsetCodecResolver DECODER_RESOLVER = new DecoderResolver();
    private static final CharsetCodecResolver ENCODER_RESOLVER = new EncoderResolver();
    private static final ThreadCache.CachedTypeIndex<CodecsCache> CODECS_CACHE = ThreadCache.obtainIndex(CodecsCache.class, 1);

    public static Charset lookupCharset(String charsetName) {
        Charset charset = charsetAliasMap.get(charsetName);
        if (charset == null) {
            Charset newCharset = Charset.forName(charsetName);
            Charset prevCharset = charsetAliasMap.putIfAbsent(charsetName, newCharset);
            charset = prevCharset == null ? newCharset : prevCharset;
        }
        return charset;
    }

    public static CharsetDecoder getCharsetDecoder(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("Charset can not be null");
        }
        CharsetDecoder decoder = Charsets.obtainCodecsCache().getDecoder(charset);
        decoder.reset();
        return decoder;
    }

    public static CharsetEncoder getCharsetEncoder(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("Charset can not be null");
        }
        CharsetEncoder encoder = Charsets.obtainCodecsCache().getEncoder(charset);
        encoder.reset();
        return encoder;
    }

    private static CodecsCache obtainCodecsCache() {
        CodecsCache cache = ThreadCache.getFromCache(CODECS_CACHE);
        if (cache == null) {
            cache = new CodecsCache();
            ThreadCache.putToCache(CODECS_CACHE, cache);
        }
        return cache;
    }

    private static final class EncoderResolver
    implements CharsetCodecResolver {
        private EncoderResolver() {
        }

        @Override
        public Charset charset(Object element) {
            return ((CharsetEncoder)element).charset();
        }

        @Override
        public Object newElement(Charset charset) {
            return charset.newEncoder();
        }
    }

    private static final class DecoderResolver
    implements CharsetCodecResolver {
        private DecoderResolver() {
        }

        @Override
        public Charset charset(Object element) {
            return ((CharsetDecoder)element).charset();
        }

        @Override
        public Object newElement(Charset charset) {
            return charset.newDecoder();
        }
    }

    private static interface CharsetCodecResolver {
        public Charset charset(Object var1);

        public Object newElement(Charset var1);
    }

    private static final class CodecsCache {
        private final Object[] decoders = new Object[4];
        private final Object[] encoders = new Object[4];

        private CodecsCache() {
        }

        public CharsetDecoder getDecoder(Charset charset) {
            return (CharsetDecoder)CodecsCache.obtainElementByCharset(this.decoders, charset, DECODER_RESOLVER);
        }

        public CharsetEncoder getEncoder(Charset charset) {
            return (CharsetEncoder)CodecsCache.obtainElementByCharset(this.encoders, charset, ENCODER_RESOLVER);
        }

        private static Object obtainElementByCharset(Object[] array, Charset charset, CharsetCodecResolver resolver) {
            int i;
            for (i = 0; i < array.length; ++i) {
                Object currentElement = array[i];
                if (currentElement == null) {
                    ++i;
                    break;
                }
                if (!charset.equals(resolver.charset(currentElement))) continue;
                CodecsCache.makeFirst(array, i, currentElement);
                return currentElement;
            }
            Object newElement = resolver.newElement(charset);
            CodecsCache.makeFirst(array, i - 1, newElement);
            return newElement;
        }

        private static void makeFirst(Object[] array, int offs, Object element) {
            for (int i = offs - 1; i >= 0; --i) {
                array[i + 1] = array[i];
            }
            array[0] = element;
        }
    }
}

