/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.attributes.NullaryFunction;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.utils.EchoFilter;

public class FilterChainTest
extends TestCase {
    private static final int PORT = 7788;
    private static final Attribute<AtomicInteger> counterAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(FilterChainTest.class.getName() + ".counter");
    private static final Attribute<CompositeBuffer> bufferAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(FilterChainTest.class.getName() + ".buffer", (NullaryFunction)new NullaryFunction<CompositeBuffer>(){

        public CompositeBuffer evaluate() {
            return CompositeBuffer.newBuffer();
        }
    });
    private static final FilterChainEvent INC_EVENT = new FilterChainEvent(){

        public Object type() {
            return "INC_EVENT";
        }
    };
    private static final FilterChainEvent DEC_EVENT = new FilterChainEvent(){

        public Object type() {
            return "DEC_EVENT";
        }
    };

    public void testEventUpstream() throws Exception {
        TCPNIOConnection connection = new TCPNIOConnection(TCPNIOTransportBuilder.newInstance().build(), null);
        counterAttr.set((AttributeStorage)connection, (Object)new AtomicInteger(0));
        FilterChain chain = FilterChainBuilder.stateless().add((Filter)new EventCounterFilter(0)).add((Filter)new EventCounterFilter(1)).add((Filter)new EventCounterFilter(2)).add((Filter)new EventCounterFilter(3)).build();
        SafeFutureImpl resultFuture = SafeFutureImpl.create();
        EmptyCompletionHandler<FilterChainContext> completionHandler = new EmptyCompletionHandler<FilterChainContext>((FutureImpl)resultFuture){
            final /* synthetic */ FutureImpl val$resultFuture;
            {
                this.val$resultFuture = futureImpl;
            }

            public void completed(FilterChainContext result) {
                this.val$resultFuture.result((Object)true);
            }

            public void failed(Throwable throwable) {
                this.val$resultFuture.failure(throwable);
            }
        };
        GrizzlyFuture f = chain.fireEventUpstream((Connection)connection, INC_EVENT, (CompletionHandler)completionHandler);
        f.get(10L, TimeUnit.SECONDS);
    }

    public void testEventDownstream() throws Exception {
        TCPNIOConnection connection = new TCPNIOConnection(TCPNIOTransportBuilder.newInstance().build(), null);
        counterAttr.set((AttributeStorage)connection, (Object)new AtomicInteger(3));
        FilterChain chain = FilterChainBuilder.stateless().add((Filter)new EventCounterFilter(0)).add((Filter)new EventCounterFilter(1)).add((Filter)new EventCounterFilter(2)).add((Filter)new EventCounterFilter(3)).build();
        SafeFutureImpl resultFuture = SafeFutureImpl.create();
        EmptyCompletionHandler<FilterChainContext> completionHandler = new EmptyCompletionHandler<FilterChainContext>((FutureImpl)resultFuture){
            final /* synthetic */ FutureImpl val$resultFuture;
            {
                this.val$resultFuture = futureImpl;
            }

            public void completed(FilterChainContext result) {
                this.val$resultFuture.result((Object)true);
            }

            public void failed(Throwable throwable) {
                this.val$resultFuture.failure(throwable);
            }
        };
        GrizzlyFuture f = chain.fireEventDownstream((Connection)connection, DEC_EVENT, (CompletionHandler)completionHandler);
        f.get(10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFlush() throws Exception {
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        MemoryManager mm = transport.getMemoryManager();
        Buffer msg = Buffers.wrap((MemoryManager)mm, (String)"Echo this message");
        int msgSize = msg.remaining();
        final AtomicInteger serverEchoCounter = new AtomicInteger();
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new EchoFilter(){

            public NextAction handleRead(FilterChainContext ctx) throws IOException {
                Buffer msg = (Buffer)ctx.getMessage();
                serverEchoCounter.addAndGet(msg.remaining());
                return super.handleRead(ctx);
            }
        });
        transport.setProcessor((Processor)filterChainBuilder.build());
        Connection connection = null;
        try {
            transport.bind(7788);
            transport.start();
            SafeFutureImpl resultEcho = SafeFutureImpl.create();
            FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
            clientFilterChainBuilder.add((Filter)new TransportFilter());
            clientFilterChainBuilder.add((Filter)new BufferWriteFilter());
            clientFilterChainBuilder.add((Filter)new EchoResultFilter(msgSize, (FutureImpl<Integer>)resultEcho));
            FilterChain clientChain = clientFilterChainBuilder.build();
            GrizzlyFuture connectFuture = transport.connect("localhost", 7788);
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            FilterChainTest.assertTrue((connection != null ? 1 : 0) != 0);
            connection.setProcessor((Processor)clientChain);
            connection.write((Object)msg);
            try {
                resultEcho.get(5L, TimeUnit.SECONDS);
                FilterChainTest.fail((String)"No message expected");
            }
            catch (TimeoutException expected) {
                // empty catch block
            }
            GrizzlyFuture f = clientChain.flush(connection, null);
            f.get(10L, TimeUnit.SECONDS);
            FilterChainTest.assertEquals((Object)msgSize, (Object)resultEcho.get(10L, TimeUnit.SECONDS));
            FilterChainTest.assertEquals((int)msgSize, (int)serverEchoCounter.get());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    private static class EventCounterFilter
    extends BaseFilter {
        private final int checkValue;

        public EventCounterFilter(int checkValue) {
            this.checkValue = checkValue;
        }

        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            Connection c = ctx.getConnection();
            AtomicInteger ai = (AtomicInteger)counterAttr.get((AttributeStorage)c);
            int value = ai.get();
            if (event.type() == DEC_EVENT.type()) {
                ai.decrementAndGet();
            } else if (event.type() == INC_EVENT.type()) {
                ai.incrementAndGet();
            } else {
                throw new UnsupportedOperationException("Unsupported event");
            }
            if (value != this.checkValue) {
                throw new IllegalStateException("Unexpected value. Expected=" + this.checkValue + " got=" + value);
            }
            return ctx.getInvokeAction();
        }
    }

    private static class EchoResultFilter
    extends BaseFilter {
        private final int size;
        private final FutureImpl<Integer> future;

        public EchoResultFilter(int size, FutureImpl<Integer> future) {
            this.size = size;
            this.future = future;
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            Buffer msg = (Buffer)ctx.getMessage();
            int msgSize = msg.remaining();
            if (msgSize < this.size) {
                return ctx.getStopAction((Object)msg);
            }
            if (msgSize == this.size) {
                this.future.result((Object)this.size);
                return ctx.getStopAction();
            }
            throw new IllegalStateException("Response is bigger than expected. Expected=" + this.size + " got=" + msgSize);
        }
    }

    private static class BufferWriteFilter
    extends BaseFilter {
        private BufferWriteFilter() {
        }

        public NextAction handleWrite(FilterChainContext ctx) throws IOException {
            Connection c = ctx.getConnection();
            Buffer msg = (Buffer)ctx.getMessage();
            CompositeBuffer buffer = (CompositeBuffer)bufferAttr.get((AttributeStorage)c);
            buffer.append((Object)msg);
            return ctx.getStopAction();
        }

        public NextAction handleEvent(final FilterChainContext ctx, FilterChainEvent event) throws IOException {
            if (event.type() == TransportFilter.FlushEvent.TYPE) {
                Connection c = ctx.getConnection();
                Buffer buffer = (Buffer)bufferAttr.remove((AttributeStorage)c);
                ctx.write((Object)buffer, (CompletionHandler)new EmptyCompletionHandler<WriteResult>(){

                    public void completed(WriteResult result) {
                        ctx.setFilterIdx(ctx.getFilterIdx() - 1);
                        ctx.resume();
                    }

                    public void failed(Throwable throwable) {
                        ctx.fail(throwable);
                        ctx.completeAndRecycle();
                    }
                });
                return ctx.getSuspendAction();
            }
            return ctx.getInvokeAction();
        }
    }
}

