/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.IOException;
import java.io.OutputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.MemoryManager;

public class BufferOutputStream
extends OutputStream {
    final MemoryManager mm;
    private Buffer buffer;

    public BufferOutputStream(Buffer buffer, MemoryManager mm) {
        this.buffer = buffer;
        this.mm = mm;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureCapacity(1);
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureCapacity(len);
        this.buffer.put(b, off, len);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    private void ensureCapacity(int len) {
        if (this.buffer.remaining() < len) {
            this.buffer = this.mm.reallocate(this.buffer, Math.max(this.buffer.capacity() + len, this.buffer.capacity() * 3 / 2 + 1));
        }
    }
}

