/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventProcessingHandler;
import org.glassfish.grizzly.strategies.AbstractIOStrategy;

public final class WorkerThreadIOStrategy
extends AbstractIOStrategy {
    private static final WorkerThreadIOStrategy INSTANCE = new WorkerThreadIOStrategy();
    private static final Logger logger = Grizzly.logger(WorkerThreadIOStrategy.class);

    private WorkerThreadIOStrategy() {
    }

    public static WorkerThreadIOStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean executeIoEvent(final Connection connection, final IOEvent ioEvent) throws IOException {
        IOEventProcessingHandler pp;
        boolean disableInterest = WorkerThreadIOStrategy.isReadWrite(ioEvent);
        if (disableInterest) {
            connection.disableIOEvent(ioEvent);
            pp = enableInterestProcessingHandler;
        } else {
            pp = null;
        }
        if (WorkerThreadIOStrategy.isExecuteInWorkerThread(ioEvent)) {
            WorkerThreadIOStrategy.getWorkerThreadPool(connection).execute(new Runnable(){

                @Override
                public void run() {
                    WorkerThreadIOStrategy.run0(connection, ioEvent, pp);
                }
            });
        } else {
            WorkerThreadIOStrategy.run0(connection, ioEvent, pp);
        }
        return true;
    }

    private static void run0(Connection connection, IOEvent ioEvent, IOEventProcessingHandler processingHandler) {
        WorkerThreadIOStrategy.fireIOEvent(connection, ioEvent, processingHandler, logger);
    }
}

