/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.NullaryFunction;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.utils.DelayedExecutor;

public class IdleTimeoutFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(IdleTimeoutFilter.class);
    public static final Long FOREVER = Long.MAX_VALUE;
    public static final Long FOREVER_SPECIAL = FOREVER - 1L;
    public static final String IDLE_ATTRIBUTE_NAME = "connection-idle-attribute";
    private static final Attribute<IdleRecord> IDLE_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("connection-idle-attribute", new NullaryFunction<IdleRecord>(){

        @Override
        public IdleRecord evaluate() {
            return new IdleRecord();
        }
    });
    private final long timeoutMillis;
    private final DelayedExecutor executor;
    private final DelayedExecutor.DelayQueue<Connection> queue;
    private final boolean wasExecutorStarted;
    private final FilterChainContext.CompletionListener contextCompletionListener = new ContextCompletionListener();

    public IdleTimeoutFilter(long timeout, TimeUnit timeunit) {
        this(new DelayedExecutor(Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = new Thread(r);
                newThread.setDaemon(true);
                return newThread;
            }
        })), true, timeout, timeunit);
    }

    public IdleTimeoutFilter(DelayedExecutor executor, long timeout, TimeUnit timeunit) {
        this(executor, false, timeout, timeunit);
    }

    protected IdleTimeoutFilter(DelayedExecutor executor, boolean needStartExecutor, long timeout, TimeUnit timeunit) {
        this.timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        this.wasExecutorStarted = needStartExecutor;
        if (needStartExecutor) {
            executor.start();
        }
        this.executor = executor;
        this.queue = executor.createDelayQueue(new DelayedExecutor.Worker<Connection>(){

            @Override
            public boolean doWork(Connection connection) {
                try {
                    connection.close().markForRecycle(true);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "SilentConnectionFilter:unexpected exception, when trying to close connection", e);
                }
                return true;
            }
        }, new Resolver());
    }

    public long getTimeout(TimeUnit timeunit) {
        return timeunit.convert(this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        this.queue.add(ctx.getConnection(), FOREVER, TimeUnit.MILLISECONDS);
        this.queueAction(ctx);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        this.queue.add(ctx.getConnection(), FOREVER, TimeUnit.MILLISECONDS);
        this.queueAction(ctx);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        this.queueAction(ctx);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        this.queueAction(ctx);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        this.queue.remove(ctx.getConnection());
        return ctx.getInvokeAction();
    }

    protected void queueAction(FilterChainContext ctx) {
        Connection connection = ctx.getConnection();
        IdleRecord idleRecord = IDLE_ATTR.get(connection);
        if (idleRecord.counter.getAndIncrement() == 0) {
            idleRecord.timeoutMillis.set(FOREVER);
        }
        ctx.addCompletionListener(this.contextCompletionListener);
    }

    protected void finalize() throws Throwable {
        if (this.wasExecutorStarted) {
            this.executor.stop();
        }
        super.finalize();
    }

    private final class ContextCompletionListener
    implements FilterChainContext.CompletionListener {
        private ContextCompletionListener() {
        }

        @Override
        public void onComplete(FilterChainContext ctx) {
            Connection connection = ctx.getConnection();
            IdleRecord idleRecord = (IdleRecord)IDLE_ATTR.get(connection);
            idleRecord.timeoutMillis.set(FOREVER_SPECIAL);
            if (idleRecord.counter.decrementAndGet() == 0) {
                idleRecord.timeoutMillis.compareAndSet(FOREVER_SPECIAL, System.currentTimeMillis() + IdleTimeoutFilter.this.timeoutMillis);
            }
        }
    }

    private static final class IdleRecord {
        private final AtomicLong timeoutMillis;
        private final AtomicInteger counter = new AtomicInteger();

        public IdleRecord() {
            this.timeoutMillis = new AtomicLong();
        }
    }

    private static final class Resolver
    implements DelayedExecutor.Resolver<Connection> {
        private Resolver() {
        }

        @Override
        public boolean removeTimeout(Connection connection) {
            ((IdleRecord)IDLE_ATTR.get(connection)).timeoutMillis.set(0L);
            return true;
        }

        @Override
        public Long getTimeoutMillis(Connection connection) {
            return ((IdleRecord)IDLE_ATTR.get(connection)).timeoutMillis.get();
        }

        @Override
        public void setTimeoutMillis(Connection connection, long timeoutMillis) {
            ((IdleRecord)IDLE_ATTR.get(connection)).timeoutMillis.set(timeoutMillis);
        }
    }
}

