/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractWriter;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.PendingWriteQueueLimitExceededException;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;

public abstract class AbstractNIOAsyncQueueWriter
extends AbstractWriter<SocketAddress>
implements AsyncQueueWriter<SocketAddress> {
    private static final Logger logger = Grizzly.logger(AbstractNIOAsyncQueueWriter.class);
    private static final AsyncWriteQueueRecord LOCK_RECORD = AsyncWriteQueueRecord.create(null, null, null, null, null, null, null, null, false);
    protected final NIOTransport transport;
    protected volatile int maxPendingBytes = -1;
    private IOException cachedIOException;

    public AbstractNIOAsyncQueueWriter(NIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public boolean canWrite(Connection connection, int size) {
        if (this.maxPendingBytes < 0) {
            return true;
        }
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = ((NIOConnection)connection).getAsyncWriteQueue();
        return connectionQueue.spaceInBytes() + size < this.maxPendingBytes;
    }

    @Override
    public void setMaxPendingBytesPerConnection(int maxPendingBytes) {
        this.maxPendingBytes = maxPendingBytes <= 0 ? -1 : maxPendingBytes;
    }

    @Override
    public int getMaxPendingBytesPerConnection() {
        return this.maxPendingBytes;
    }

    @Override
    public GrizzlyFuture<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult<Buffer, SocketAddress>> interceptor) throws IOException {
        return this.write(connection, dstAddress, buffer, completionHandler, interceptor, null);
    }

    @Override
    public GrizzlyFuture<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult<Buffer, SocketAddress>> interceptor, MessageCloner<Buffer> cloner) throws IOException {
        boolean isLogFine = logger.isLoggable(Level.FINEST);
        if (connection == null) {
            throw new IOException("Connection is null");
        }
        if (!connection.isOpen()) {
            throw new IOException("Connection is closed");
        }
        NIOConnection nioConnection = (NIOConnection)connection;
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = nioConnection.getAsyncWriteQueue();
        WriteResult<Buffer, SocketAddress> currentResult = WriteResult.create(connection, buffer, dstAddress, 0);
        AsyncWriteQueueRecord queueRecord = this.createRecord(connection, buffer, null, currentResult, completionHandler, interceptor, dstAddress, buffer, false);
        Queue<AsyncWriteQueueRecord> queue = connectionQueue.getQueue();
        AtomicReference<AsyncWriteQueueRecord> currentElement = connectionQueue.getCurrentElementAtomic();
        int bufferSize = buffer.remaining();
        int pendingBytes = this.maxPendingBytes > 0 ? connectionQueue.reserveSpace(bufferSize) : bufferSize;
        boolean isLocked = currentElement.compareAndSet(null, LOCK_RECORD);
        if (isLogFine) {
            logger.log(Level.FINEST, "AsyncQueueWriter.write connection={0} record={1} directWrite={2}", new Object[]{connection, queueRecord, isLocked});
        }
        try {
            if (isLocked) {
                int bytesWritten = this.write0(nioConnection, queueRecord);
                if (this.maxPendingBytes > 0) {
                    connectionQueue.releaseSpaceAndNotify(bytesWritten);
                }
            } else if (this.maxPendingBytes > 0 && pendingBytes > this.maxPendingBytes && bufferSize > 0) {
                connectionQueue.releaseSpace(bufferSize);
                throw new PendingWriteQueueLimitExceededException("Max queued data limit exceeded: " + pendingBytes + '>' + this.maxPendingBytes);
            }
            if (isLocked && this.isFinished(queueRecord)) {
                AsyncWriteQueueRecord nextRecord = queue.poll();
                currentElement.set(nextRecord);
                if (isLogFine) {
                    logger.log(Level.FINEST, "AsyncQueueWriter.write completed connection={0} record={1} nextRecord={2}", new Object[]{connection, queueRecord, nextRecord});
                }
                this.onWriteComplete(queueRecord);
                if (nextRecord == null) {
                    nextRecord = queue.peek();
                    if (isLogFine) {
                        logger.log(Level.FINEST, "AsyncQueueWriter.write peek connection={0} nextRecord={1}", new Object[]{connection, nextRecord});
                    }
                    if (nextRecord != null && currentElement.compareAndSet(null, nextRecord)) {
                        if (isLogFine) {
                            logger.log(Level.FINEST, "AsyncQueueWriter.write peek, onReadyToWrite. connection={0}", connection);
                        }
                        if (queue.remove(nextRecord)) {
                            this.onReadyToWrite(connection);
                        }
                    }
                } else {
                    if (isLogFine) {
                        logger.log(Level.FINEST, "AsyncQueueWriter.write onReadyToWrite. connection={0}", connection);
                    }
                    this.onReadyToWrite(connection);
                }
                return ReadyFutureImpl.create(currentResult);
            }
            SafeFutureImpl<WriteResult<Buffer, SocketAddress>> future = SafeFutureImpl.create();
            queueRecord.setFuture(future);
            if (cloner != null) {
                if (isLogFine) {
                    logger.log(Level.FINEST, "AsyncQueueWriter.write clone. connection={0}", connection);
                }
                buffer = cloner.clone(connection, buffer);
                queueRecord.setMessage(buffer);
                queueRecord.setOutputBuffer(buffer);
                queueRecord.setCloned(true);
            }
            if (isLocked) {
                if (isLogFine) {
                    logger.log(Level.FINEST, "AsyncQueueWriter.write onReadyToWrite. connection={0}", connection);
                }
                currentElement.set(queueRecord);
                this.onReadyToWrite(connection);
            } else {
                if (isLogFine) {
                    logger.log(Level.FINEST, "AsyncQueueWriter.write queue record. connection={0} record={1}", new Object[]{connection, queueRecord});
                }
                connectionQueue.getQueue().offer(queueRecord);
                if (currentElement.compareAndSet(null, queueRecord)) {
                    if (isLogFine) {
                        logger.log(Level.FINEST, "AsyncQueueWriter.write set record as current. connection={0} record={1}", new Object[]{connection, queueRecord});
                    }
                    if (queue.remove(queueRecord)) {
                        this.onReadyToWrite(connection);
                    }
                }
                if (!connection.isOpen() && queue.remove(queueRecord)) {
                    if (isLogFine) {
                        logger.log(Level.FINEST, "AsyncQueueWriter.write connection is closed. connection={0} record={1}", new Object[]{connection, queueRecord});
                    }
                    this.onWriteFailure(connection, queueRecord, new IOException("Connection is closed"));
                }
            }
            return future;
        }
        catch (IOException e) {
            if (isLogFine) {
                logger.log(Level.FINEST, "AsyncQueueWriter.write exception. connection=" + connection + " record=" + queueRecord, e);
            }
            this.onWriteFailure(connection, queueRecord, e);
            return ReadyFutureImpl.create(e);
        }
    }

    protected AsyncWriteQueueRecord createRecord(Connection connection, Buffer message, Future<WriteResult<Buffer, SocketAddress>> future, WriteResult<Buffer, SocketAddress> currentResult, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult<Buffer, SocketAddress>> interceptor, SocketAddress dstAddress, Buffer outputBuffer, boolean isCloned) {
        return AsyncWriteQueueRecord.create(connection, message, future, currentResult, completionHandler, interceptor, dstAddress, outputBuffer, isCloned);
    }

    @Override
    public final boolean isReady(Connection connection) {
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = ((NIOConnection)connection).getAsyncWriteQueue();
        return connectionQueue != null && (connectionQueue.getCurrentElement() != null || connectionQueue.getQueue() != null && !connectionQueue.getQueue().isEmpty());
    }

    @Override
    public void processAsync(Connection connection) throws IOException {
        boolean isLogFine = logger.isLoggable(Level.FINEST);
        NIOConnection nioConnection = (NIOConnection)connection;
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = nioConnection.getAsyncWriteQueue();
        Queue<AsyncWriteQueueRecord> queue = connectionQueue.getQueue();
        AtomicReference<AsyncWriteQueueRecord> currentElement = connectionQueue.getCurrentElementAtomic();
        AsyncWriteQueueRecord queueRecord = currentElement.get();
        if (isLogFine) {
            logger.log(Level.FINEST, "AsyncQueueWriter.processAsync connection={0} record={1} isLockRecord={2}", new Object[]{connection, queueRecord, queueRecord == LOCK_RECORD});
        }
        if (queueRecord == LOCK_RECORD) {
            return;
        }
        try {
            while (queueRecord != null) {
                if (isLogFine) {
                    logger.log(Level.FINEST, "AsyncQueueWriter.processAsync doWrite connection={0} record={1}", new Object[]{connection, queueRecord});
                }
                int bytesWritten = this.write0(nioConnection, queueRecord);
                connectionQueue.releaseSpaceAndNotify(bytesWritten);
                if (this.isFinished(queueRecord)) {
                    if (isLogFine) {
                        logger.log(Level.FINEST, "AsyncQueueWriter.processAsync finished connection={0} record={1}", new Object[]{connection, queueRecord});
                    }
                    AsyncWriteQueueRecord nextRecord = queue.poll();
                    currentElement.set(nextRecord);
                    this.onWriteComplete(queueRecord);
                    queueRecord = nextRecord;
                    if (isLogFine) {
                        logger.log(Level.FINEST, "AsyncQueueWriter.processAsync nextRecord connection={0} nextRecord={1}", new Object[]{connection, queueRecord});
                    }
                    if (queueRecord != null) continue;
                    queueRecord = queue.peek();
                    if (isLogFine) {
                        logger.log(Level.FINEST, "AsyncQueueWriter.processAsync peekRecord connection={0} peekRecord={1}", new Object[]{connection, queueRecord});
                    }
                    if (queueRecord != null && currentElement.compareAndSet(null, queueRecord)) {
                        if (isLogFine) {
                            logger.log(Level.FINEST, "AsyncQueueWriter.processAsync set as current connection={0} peekRecord={1}", new Object[]{connection, queueRecord});
                        }
                        if (queue.remove(queueRecord)) continue;
                    }
                } else {
                    if (isLogFine) {
                        logger.log(Level.FINEST, "AsyncQueueWriter.processAsync onReadyToWrite connection={0} peekRecord={1}", new Object[]{connection, queueRecord});
                    }
                    this.onReadyToWrite(connection);
                }
                break;
            }
        }
        catch (IOException e) {
            if (isLogFine) {
                logger.log(Level.FINEST, "AsyncQueueWriter.processAsync exception connection=" + connection + " peekRecord=" + queueRecord, e);
            }
            this.onWriteFailure(connection, queueRecord, e);
        }
    }

    @Override
    public void onClose(Connection connection) {
        NIOConnection nioConnection = (NIOConnection)connection;
        TaskQueue<AsyncWriteQueueRecord> writeQueue = nioConnection.getAsyncWriteQueue();
        if (writeQueue != null) {
            Queue<AsyncWriteQueueRecord> recordsQueue;
            AsyncWriteQueueRecord record = writeQueue.getCurrentElementAtomic().getAndSet(LOCK_RECORD);
            IOException error = this.cachedIOException;
            if (error == null) {
                this.cachedIOException = error = new IOException("Connection closed");
            }
            if (record != LOCK_RECORD) {
                this.failWriteRecord(record, error);
            }
            if ((recordsQueue = writeQueue.getQueue()) != null) {
                while ((record = recordsQueue.poll()) != null) {
                    this.failWriteRecord(record, error);
                }
            }
        }
    }

    @Override
    public final void close() {
    }

    protected final void onWriteComplete(AsyncWriteQueueRecord record) throws IOException {
        WriteResult currentResult = (WriteResult)record.getCurrentResult();
        FutureImpl future = (FutureImpl)record.getFuture();
        CompletionHandler completionHandler = record.getCompletionHandler();
        Object originalMessage = record.getOriginalMessage();
        record.recycle();
        if (future != null) {
            future.result(currentResult);
        }
        if (completionHandler != null) {
            completionHandler.completed(currentResult);
        }
        if (originalMessage instanceof Buffer) {
            ((Buffer)originalMessage).tryDispose();
        }
    }

    protected final void onWriteIncomplete(AsyncWriteQueueRecord record) throws IOException {
        WriteResult currentResult = (WriteResult)record.getCurrentResult();
        CompletionHandler completionHandler = record.getCompletionHandler();
        if (completionHandler != null) {
            completionHandler.updated(currentResult);
        }
    }

    protected final void onWriteFailure(Connection connection, AsyncWriteQueueRecord failedRecord, IOException e) {
        this.failWriteRecord(failedRecord, e);
        try {
            connection.close().markForRecycle(true);
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    protected final void failWriteRecord(AsyncWriteQueueRecord record, Throwable e) {
        boolean hasFuture;
        if (record == null) {
            return;
        }
        FutureImpl future = (FutureImpl)record.getFuture();
        boolean bl = hasFuture = future != null;
        if (!hasFuture || !future.isDone()) {
            CompletionHandler completionHandler = record.getCompletionHandler();
            if (completionHandler != null) {
                completionHandler.failed(e);
            }
            if (hasFuture) {
                future.failure(e);
            }
        }
    }

    private boolean isFinished(AsyncWriteQueueRecord queueRecord) {
        Buffer buffer = queueRecord.getOutputBuffer();
        return !buffer.hasRemaining();
    }

    protected abstract int write0(NIOConnection var1, AsyncWriteQueueRecord var2) throws IOException;

    protected abstract void onReadyToWrite(Connection var1) throws IOException;
}

