/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.compression.lzma;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.compression.lzma.LZMADecoder;
import org.glassfish.grizzly.compression.lzma.LZMAEncoder;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

public class LZMAFilter
extends BaseFilter {
    private final LZMAEncoder encoder = new LZMAEncoder();
    private final LZMADecoder decoder = new LZMADecoder();

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer input;
        Connection connection = ctx.getConnection();
        TransformationResult result = this.decoder.transform(connection, input = (Buffer)ctx.getMessage());
        Buffer remainder = result.getExternalRemainder();
        if (remainder == null) {
            input.tryDispose();
        } else {
            input.shrink();
        }
        try {
            switch (result.getStatus()) {
                case COMPLETE: {
                    ctx.setMessage(result.getMessage());
                    this.decoder.finish(connection);
                    NextAction nextAction = ctx.getInvokeAction(remainder);
                    return nextAction;
                }
                case INCOMPLETE: {
                    NextAction nextAction = ctx.getStopAction(remainder);
                    return nextAction;
                }
                case ERROR: {
                    throw new IllegalStateException("LZMA decode error. Code: " + result.getErrorCode() + " Description: " + result.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + (Object)((Object)result.getStatus()));
        }
        finally {
            result.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        int origLim;
        Connection connection = ctx.getConnection();
        Buffer input = (Buffer)ctx.getMessage();
        int numOfPackets = input.remaining() / 512;
        int curLim = origLim = input.limit();
        int pos = input.position();
        MemoryManager mm = ctx.getConnection().getTransport().getMemoryManager();
        Buffer finalBuffer = null;
        try {
            do {
                if (numOfPackets > 0) {
                    input.limit(pos + 512);
                } else {
                    input.limit(origLim);
                }
                TransformationResult result = this.encoder.transform(connection, input);
                switch (result.getStatus()) {
                    case COMPLETE: {
                        this.encoder.finish(connection);
                    }
                    case INCOMPLETE: {
                        Buffer readyBuffer = (Buffer)result.getMessage();
                        if (readyBuffer != null) {
                            finalBuffer = Buffers.appendBuffers(mm, finalBuffer, readyBuffer);
                            break;
                        }
                        input.position(pos);
                        input.limit(curLim);
                        NextAction nextAction = ctx.getStopAction();
                        return nextAction;
                    }
                    case ERROR: {
                        input.position(pos);
                        input.limit(curLim);
                        throw new IllegalStateException("LZMA encode error. Code: " + result.getErrorCode() + " Description: " + result.getErrorDescription());
                    }
                    default: {
                        result.recycle();
                        input.position(0);
                        input.limit(curLim);
                        throw new IllegalStateException("Unexpected status: " + (Object)((Object)result.getStatus()));
                    }
                }
                curLim = input.limit();
                pos = input.position();
                result.recycle();
            } while (--numOfPackets > -1);
            ctx.setMessage(finalBuffer);
            NextAction nextAction = ctx.getInvokeAction();
            return nextAction;
        }
        finally {
            input.dispose();
        }
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        this.decoder.release(connection);
        this.encoder.release(connection);
        return super.handleClose(ctx);
    }
}

