/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.compression.lzma;

import java.io.IOException;
import org.glassfish.grizzly.AbstractTransformer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.compression.lzma.BufferInputStream;
import org.glassfish.grizzly.compression.lzma.BufferOutputStream;
import org.glassfish.grizzly.compression.lzma.impl.Decoder;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

public class LZMADecoder
extends AbstractTransformer<Buffer, Buffer> {
    private static final ThreadCache.CachedTypeIndex<LZMAInputState> CACHE_IDX = ThreadCache.obtainIndex(LZMAInputState.class, 2);

    @Override
    public String getName() {
        return "lzma-decoder";
    }

    @Override
    public boolean hasInputRemaining(AttributeStorage storage, Buffer input) {
        return input.hasRemaining();
    }

    @Override
    protected TransformationResult<Buffer, Buffer> transformImpl(AttributeStorage storage, Buffer input) throws TransformationException {
        MemoryManager memoryManager = this.obtainMemoryManager(storage);
        LZMAInputState state = (LZMAInputState)this.obtainStateObject(storage);
        if (!state.isInitialized() && !this.initializeInput(state, input)) {
            return TransformationResult.createIncompletedResult(input);
        }
        Buffer decodedBuffer = null;
        if (input.hasRemaining() && this.eosMarkerPresent(input)) {
            decodedBuffer = this.decodeBuffer(memoryManager, input, state);
        }
        boolean hasRemainder = input.hasRemaining();
        if (decodedBuffer == null || !decodedBuffer.hasRemaining()) {
            return TransformationResult.createIncompletedResult(hasRemainder ? input : null);
        }
        return TransformationResult.createCompletedResult(decodedBuffer, hasRemainder ? input : null);
    }

    private boolean eosMarkerPresent(Buffer input) {
        int idx = input.limit() - 1;
        byte b = input.get(idx);
        return b == 0;
    }

    @Override
    protected AbstractTransformer.LastResultAwareState<Buffer, Buffer> createStateObject() {
        return LZMADecoder.create();
    }

    public static LZMAInputState create() {
        LZMAInputState state = ThreadCache.takeFromCache(CACHE_IDX);
        if (state != null) {
            return state;
        }
        return new LZMAInputState();
    }

    public void finish(AttributeStorage storage) {
        LZMAInputState state = (LZMAInputState)this.obtainStateObject(storage);
        state.recycle();
    }

    private boolean initializeInput(LZMAInputState state, Buffer input) {
        return input.remaining() >= 5 && state.initialize(input);
    }

    private Buffer decodeBuffer(MemoryManager memoryManager, Buffer buffer, LZMAInputState state) {
        int lastInflated;
        state.getInputStream().setBuffer(buffer);
        Buffer resultBuffer = null;
        do {
            int pos = buffer.position();
            Object decodedBuffer = memoryManager.allocate(512);
            state.getOutputStream().setBuffer((Buffer)decodedBuffer, memoryManager);
            try {
                state.getDecoder().Code(state.getInputStream(), state.getOutputStream(), -1L);
            }
            catch (IOException e) {
                decodedBuffer.dispose();
                throw new IllegalStateException(e);
            }
            decodedBuffer = state.getOutputStream().getBuffer();
            lastInflated = decodedBuffer.position();
            if (decodedBuffer.position() > 0) {
                decodedBuffer.trim();
                resultBuffer = Buffers.appendBuffers(memoryManager, resultBuffer, (Buffer)decodedBuffer);
                continue;
            }
            decodedBuffer.dispose();
            buffer.position(pos);
        } while (lastInflated > 0);
        return resultBuffer;
    }

    private static class LZMAInputState
    extends AbstractTransformer.LastResultAwareState<Buffer, Buffer>
    implements Cacheable {
        private Decoder decoder = new Decoder();
        private BufferInputStream inputStream = new BufferInputStream();
        private BufferOutputStream outputStream = new BufferOutputStream();
        private boolean initialized;
        private byte[] decoderConfigBits = new byte[5];

        private LZMAInputState() {
        }

        public boolean initialize(Buffer buffer) {
            buffer.get(this.decoderConfigBits);
            this.initialized = this.decoder.SetDecoderProperties(this.decoderConfigBits);
            return this.initialized;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public Decoder getDecoder() {
            return this.decoder;
        }

        public BufferInputStream getInputStream() {
            return this.inputStream;
        }

        public BufferOutputStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        public void recycle() {
            this.inputStream.recycle();
            this.outputStream.recycle();
            this.initialized = false;
            this.lastResult = null;
            ThreadCache.putToCache(CACHE_IDX, this);
        }
    }
}

