/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.compression.lzma;

import java.io.IOException;
import java.io.InputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;

class BufferInputStream
extends InputStream
implements Cacheable {
    private Buffer src;

    BufferInputStream() {
    }

    public void setBuffer(Buffer src) {
        this.src = src;
    }

    @Override
    public void recycle() {
        this.src = null;
    }

    @Override
    public int read() throws IOException {
        if (!this.src.hasRemaining()) {
            return -1;
        }
        return this.src.get() & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.src.hasRemaining()) {
            return -1;
        }
        int cur = this.src.remaining();
        this.src.get(b, off, Math.min(this.src.remaining(), len));
        return cur - this.src.remaining();
    }

    @Override
    public void close() throws IOException {
    }
}

