/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortRange {
    private static final Pattern FORMAT = Pattern.compile("(\\d+)(?:(?:,|:)(\\d+))?");
    private final int lower;
    private final int upper;
    private static final Random _random = new Random();

    public PortRange(int low, int high) {
        if (low < 0 || high < low || 65535 < high) {
            throw new IllegalArgumentException("Invalid range");
        }
        this.lower = low;
        this.upper = high;
    }

    public PortRange(int port) {
        this(port, port);
    }

    public static PortRange valueOf(String s) throws IllegalArgumentException {
        try {
            Matcher m = FORMAT.matcher(s);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid range: " + s);
            }
            int low = Integer.parseInt(m.group(1));
            int high = m.groupCount() == 1 ? low : Integer.parseInt(m.group(2));
            return new PortRange(low, high);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid range: " + s);
        }
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public String toString() {
        return String.format("%d:%d", this.lower, this.upper);
    }
}

