/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.EventExecutor;
import org.glassfish.grizzly.Grizzly;

public class WorkerThreadExecutor
implements EventExecutor {
    private static final Logger LOGGER = Grizzly.logger(WorkerThreadExecutor.class);
    private final ExecutorService workerThreadPool;

    public WorkerThreadExecutor(ExecutorService workerThreadPool) {
        this.workerThreadPool = workerThreadPool;
    }

    @Override
    public void execute(Runnable task) {
        try {
            this.workerThreadPool.execute(task);
        }
        catch (RejectedExecutionException e) {
            LOGGER.log(Level.FINE, "Task " + task + " was rejected by ThreadPool. Reason: ", e);
        }
    }

    @Override
    public boolean isCurrentThreadExecutor() {
        return false;
    }
}

