/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.utils.LinkedTransferQueue;
import org.glassfish.grizzly.utils.conditions.Condition;

public final class StateHolder<E> {
    private static Logger _logger = Grizzly.logger(StateHolder.class);
    private volatile E state;
    private final ReentrantReadWriteLock readWriteLock;
    private Collection<ConditionElement> conditionListeners;

    public StateHolder() {
        this(null);
    }

    public StateHolder(E initialState) {
        this.state = initialState;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.conditionListeners = new LinkedTransferQueue<ConditionElement>();
    }

    public E getState() {
        return this.state;
    }

    public void setState(E state) {
        this.readWriteLock.writeLock().lock();
        this.state = state;
        this.readWriteLock.readLock().lock();
        this.readWriteLock.writeLock().unlock();
        this.notifyConditionListeners();
        this.readWriteLock.readLock().unlock();
    }

    public ReentrantReadWriteLock getStateLocker() {
        return this.readWriteLock;
    }

    public Future<E> notifyWhenStateIsEqual(final E state, CompletionHandler<E> completionHandler) {
        return this.notifyWhenConditionMatchState(new Condition(){

            @Override
            public boolean check() {
                return state == StateHolder.this.state;
            }
        }, completionHandler);
    }

    public Future<E> notifyWhenStateIsNotEqual(final E state, CompletionHandler<E> completionHandler) {
        return this.notifyWhenConditionMatchState(new Condition(){

            @Override
            public boolean check() {
                return state != StateHolder.this.state;
            }
        }, completionHandler);
    }

    public Future<E> notifyWhenConditionMatchState(Condition condition, CompletionHandler<E> completionHandler) {
        GrizzlyFuture<Object> resultFuture;
        this.readWriteLock.readLock().lock();
        if (condition.check()) {
            if (completionHandler != null) {
                completionHandler.completed(this.state);
            }
            resultFuture = ReadyFutureImpl.create(this.state);
        } else {
            SafeFutureImpl future = SafeFutureImpl.create();
            ConditionElement elem = new ConditionElement(condition, future, completionHandler);
            this.conditionListeners.add(elem);
            resultFuture = future;
        }
        this.readWriteLock.readLock().unlock();
        return resultFuture;
    }

    protected void notifyConditionListeners() {
        Iterator<ConditionElement> it = this.conditionListeners.iterator();
        while (it.hasNext()) {
            ConditionElement element = it.next();
            try {
                if (!element.condition.check()) continue;
                it.remove();
                if (element.completionHandler != null) {
                    element.completionHandler.completed(this.state);
                }
                element.future.result(this.state);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Error calling ConditionListener", e);
            }
        }
    }

    protected final class ConditionElement {
        private final Condition condition;
        private final FutureImpl future;
        private final CompletionHandler completionHandler;

        public ConditionElement(Condition condition, FutureImpl future, CompletionHandler completionHandler) {
            this.condition = condition;
            this.future = future;
            this.completionHandler = completionHandler;
        }

        public CompletionHandler getCompletionHandler() {
            return this.completionHandler;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public FutureImpl getFuture() {
            return this.future;
        }
    }
}

