/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.utils.DelayedExecutor;

public class IdleTimeoutFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(IdleTimeoutFilter.class);
    public static final long UNLIMITED_TIMEOUT = -1L;
    public static final long UNSET_TIMEOUT = 0L;
    public static final String IDLE_ATTRIBUTE_NAME = "connection-idle-attribute";
    public static final Attribute<Long> idleAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("connection-idle-attribute");
    private volatile boolean isHandleAccepted;
    private volatile boolean isHandleConnected;
    private final long timeoutMillis;
    private final DelayedExecutor executor;
    private final DelayedExecutor.DelayQueue<Connection> queue;
    private final boolean wasExecutorStarted;

    public IdleTimeoutFilter(long timeout, TimeUnit timeunit) {
        this(new DelayedExecutor(Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = new Thread(r);
                newThread.setDaemon(true);
                return newThread;
            }
        })), true, timeout, timeunit);
    }

    public IdleTimeoutFilter(DelayedExecutor executor, long timeout, TimeUnit timeunit) {
        this(executor, false, timeout, timeunit);
    }

    protected IdleTimeoutFilter(DelayedExecutor executor, boolean needStartExecutor, long timeout, TimeUnit timeunit) {
        this.timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        this.wasExecutorStarted = needStartExecutor;
        if (needStartExecutor) {
            executor.start();
        }
        this.executor = executor;
        this.queue = executor.createDelayQueue(new DelayedExecutor.Worker<Connection>(){

            @Override
            public void doWork(Connection connection) {
                try {
                    connection.close().markForRecycle(true);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "SilentConnectionFilter:unexpected exception, when trying to close connection", e);
                }
            }
        }, new Resolver());
        this.isHandleAccepted = true;
        this.isHandleConnected = true;
    }

    public long getTimeout(TimeUnit timeunit) {
        return timeunit.convert(this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public boolean isHandleAccepted() {
        return this.isHandleAccepted;
    }

    public void setHandleAccepted(boolean isHandleAccepted) {
        this.isHandleAccepted = isHandleAccepted;
    }

    public boolean isHandleConnected() {
        return this.isHandleConnected;
    }

    public void setHandleConnected(boolean isHandleConnected) {
        this.isHandleConnected = isHandleConnected;
    }

    @Override
    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        if (this.isHandleAccepted) {
            this.queue.add(ctx.getConnection(), this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        if (this.isHandleConnected()) {
            this.queue.add(ctx.getConnection(), this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        this.resetTimeout(ctx.getConnection());
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        this.resetTimeout(ctx.getConnection());
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        this.queue.remove(ctx.getConnection());
        return ctx.getInvokeAction();
    }

    protected void resetTimeout(Connection connection) {
        idleAttribute.set(connection, (Long)(System.currentTimeMillis() + this.timeoutMillis));
    }

    protected void finalize() throws Throwable {
        if (this.wasExecutorStarted) {
            this.executor.stop();
        }
        super.finalize();
    }

    private static final class Resolver
    implements DelayedExecutor.Resolver<Connection> {
        private Resolver() {
        }

        @Override
        public boolean removeTimeout(Connection connection) {
            return idleAttribute.remove(connection) != null;
        }

        @Override
        public Long getTimeoutMillis(Connection connection) {
            return idleAttribute.get(connection);
        }

        @Override
        public void setTimeoutMillis(Connection connection, long timeoutMillis) {
            idleAttribute.set(connection, (Long)timeoutMillis);
        }
    }
}

