/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.threadpool;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.threadpool.FixedThreadPool;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

final class QueueLimitedThreadPool
extends FixedThreadPool {
    private final int maxQueuedTasks;
    private final AtomicInteger queueSize = new AtomicInteger();

    QueueLimitedThreadPool(ThreadPoolConfig config) {
        super(config);
        if (config.getQueueLimit() < 0) {
            throw new IllegalArgumentException("maxQueuedTasks < 0");
        }
        this.maxQueuedTasks = config.getQueueLimit();
    }

    @Override
    public final void execute(Runnable command) {
        if (command == null) {
            throw new IllegalArgumentException("Runnable task is null");
        }
        if (this.running) {
            if (this.queueSize.incrementAndGet() <= this.maxQueuedTasks && this.workQueue.offer(command)) {
                this.onTaskQueued(command);
                return;
            }
            this.onTaskQueueOverflow();
            return;
        }
        throw new RejectedExecutionException("ThreadPool is not running");
    }

    @Override
    protected void onTaskQueueOverflow() {
        this.queueSize.decrementAndGet();
        super.onTaskQueueOverflow();
    }

    @Override
    protected final void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.queueSize.decrementAndGet();
    }
}

