/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.PostProcessor;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.strategies.AbstractStrategy;
import org.glassfish.grizzly.utils.CurrentThreadExecutor;
import org.glassfish.grizzly.utils.WorkerThreadExecutor;

public final class WorkerThreadStrategy
extends AbstractStrategy {
    private static final Logger logger = Grizzly.logger(WorkerThreadStrategy.class);
    private final Executor sameThreadExecutor;
    private final Executor workerThreadExecutor;

    public WorkerThreadStrategy(ExecutorService workerThreadPool) {
        this(new CurrentThreadExecutor(), new WorkerThreadExecutor(workerThreadPool));
    }

    protected WorkerThreadStrategy(Executor sameThreadProcessorExecutor, Executor workerThreadProcessorExecutor) {
        this.sameThreadExecutor = sameThreadProcessorExecutor;
        this.workerThreadExecutor = workerThreadProcessorExecutor;
    }

    @Override
    public boolean executeIoEvent(final Connection connection, final IOEvent ioEvent) throws IOException {
        PostProcessor pp;
        boolean disableInterest;
        NIOConnection nioConnection = (NIOConnection)connection;
        boolean bl = disableInterest = ioEvent == IOEvent.READ || ioEvent == IOEvent.WRITE;
        if (disableInterest) {
            nioConnection.disableIOEvent(ioEvent);
            pp = enableInterestPostProcessor;
        } else {
            pp = null;
        }
        Executor executor = this.getExecutor(ioEvent);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    connection.getTransport().fireIOEvent(ioEvent, connection, pp);
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "Uncaught exception: ", e);
                    try {
                        connection.close().markForRecycle(true);
                    }
                    catch (IOException ee) {
                        logger.log(Level.WARNING, "Exception occurred when closing the connection: ", ee);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Uncaught exception: ", e);
                    try {
                        connection.close().markForRecycle(true);
                    }
                    catch (IOException ee) {
                        logger.log(Level.WARNING, "Exception occurred when closing the connection: ", ee);
                    }
                }
            }
        });
        return true;
    }

    private Executor getExecutor(IOEvent ioEvent) {
        switch (ioEvent) {
            case READ: 
            case WRITE: 
            case CLOSED: {
                return this.workerThreadExecutor;
            }
        }
        return this.sameThreadExecutor;
    }
}

