/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Strategy;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.strategies.SameThreadStrategy;
import org.glassfish.grizzly.strategies.WorkerThreadStrategy;
import org.glassfish.grizzly.utils.CurrentThreadExecutor;
import org.glassfish.grizzly.utils.WorkerThreadExecutor;

public final class SimpleDynamicStrategy
implements Strategy {
    private final SameThreadStrategy sameThreadStrategy = new SameThreadStrategy();
    private final WorkerThreadStrategy workerThreadStrategy;
    private static final int WORKER_THREAD_THRESHOLD = 1;

    public SimpleDynamicStrategy(ExecutorService workerThreadPool) {
        this(new CurrentThreadExecutor(), new WorkerThreadExecutor(workerThreadPool));
    }

    protected SimpleDynamicStrategy(Executor sameThreadProcessorExecutor, Executor workerThreadProcessorExecutor) {
        this.workerThreadStrategy = new WorkerThreadStrategy(sameThreadProcessorExecutor, workerThreadProcessorExecutor);
    }

    @Override
    public boolean executeIoEvent(Connection connection, IOEvent ioEvent) throws IOException {
        NIOConnection nioConnection = (NIOConnection)connection;
        int lastSelectedKeysCount = nioConnection.getSelectorRunner().getLastSelectedKeysCount();
        if (lastSelectedKeysCount <= 1) {
            return this.sameThreadStrategy.executeIoEvent(connection, ioEvent);
        }
        return this.workerThreadStrategy.executeIoEvent(connection, ioEvent);
    }
}

