/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.PostProcessor;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.strategies.AbstractStrategy;
import org.glassfish.grizzly.utils.WorkerThreadExecutor;

public final class LeaderFollowerStrategy
extends AbstractStrategy {
    private final Executor workerThreadExecutor;

    public LeaderFollowerStrategy(ExecutorService workerThreadPool) {
        this(new WorkerThreadExecutor(workerThreadPool));
    }

    protected LeaderFollowerStrategy(Executor workerThreadProcessorExecutor) {
        this.workerThreadExecutor = workerThreadProcessorExecutor;
    }

    @Override
    public boolean executeIoEvent(Connection connection, IOEvent ioEvent) throws IOException {
        Executor executor = this.getExecutor(ioEvent);
        boolean isReadWrite = ioEvent == IOEvent.READ || ioEvent == IOEvent.WRITE;
        NIOConnection nioConnection = (NIOConnection)connection;
        PostProcessor pp = null;
        if (isReadWrite) {
            nioConnection.disableIOEvent(ioEvent);
            pp = enableInterestPostProcessor;
        }
        if (executor != null) {
            SelectorRunner runner = nioConnection.getSelectorRunner();
            runner.postpone();
            executor.execute(runner);
            connection.getTransport().fireIOEvent(ioEvent, connection, pp);
            return false;
        }
        connection.getTransport().fireIOEvent(ioEvent, connection, pp);
        return true;
    }

    private Executor getExecutor(IOEvent ioEvent) {
        switch (ioEvent) {
            case READ: 
            case WRITE: 
            case CLOSED: {
                return this.workerThreadExecutor;
            }
        }
        return null;
    }
}

