/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;

public class SSLUtils {
    public static final String SSL_ENGINE_ATTR_NAME = "SSLEngineAttr";
    public static final Attribute<SSLEngine> sslEngineAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("SSLEngineAttr");

    public static SSLEngine getSSLEngine(AttributeStorage storage) {
        return sslEngineAttribute.get(storage);
    }

    public static void setSSLEngine(AttributeStorage storage, SSLEngine sslEngine) {
        sslEngineAttribute.set(storage, sslEngine);
    }

    public static void executeDelegatedTask(SSLEngine sslEngine) {
        Runnable runnable;
        while ((runnable = sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }

    public static boolean isHandshaking(SSLEngine sslEngine) {
        SSLEngineResult.HandshakeStatus handshakeStatus = sslEngine.getHandshakeStatus();
        return handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    static void clearOrCompact(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        if (!buffer.hasRemaining()) {
            buffer.clear();
        } else if (buffer.position() > 0) {
            buffer.compact();
        }
    }
}

