/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.AbstractCodecFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.PendingWriteQueueLimitExceededException;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLDecoderTransformer;
import org.glassfish.grizzly.ssl.SSLEncoderTransformer;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLUtils;

public final class SSLFilter
extends AbstractCodecFilter<Buffer, Buffer> {
    private static final Logger LOGGER = Grizzly.logger(SSLFilter.class);
    private static final byte CHANGE_CIPHER_SPECT_CONTENT_TYPE = 20;
    private static final byte ALERT_CONTENT_TYPE = 21;
    private static final byte HANDSHAKE_CONTENT_TYPE = 22;
    private static final byte APPLICATION_DATA_CONTENT_TYPE = 23;
    private static final int SSLV3_RECORD_HEADER_SIZE = 5;
    private static final int SSL20_HELLO_VERSION = 2;
    private static final int MIN_VERSION = 768;
    private static final int MAX_MAJOR_VERSION = 3;
    private final Attribute<CompletionHandler> handshakeCompletionHandlerAttr;
    private final SSLEngineConfigurator serverSSLEngineConfigurator;
    private final SSLEngineConfigurator clientSSLEngineConfigurator;
    private final ConnectionCloseListener closeListener = new ConnectionCloseListener();
    protected volatile int maxPendingBytes = Integer.MAX_VALUE;

    public SSLFilter() {
        this((SSLEngineConfigurator)null, (SSLEngineConfigurator)null);
    }

    public SSLFilter(SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator) {
        super(new SSLDecoderTransformer(), new SSLEncoderTransformer());
        this.serverSSLEngineConfigurator = serverSSLEngineConfigurator == null ? new SSLEngineConfigurator(SSLContextConfigurator.DEFAULT_CONFIG.createSSLContext(), false, false, false) : serverSSLEngineConfigurator;
        this.clientSSLEngineConfigurator = clientSSLEngineConfigurator == null ? new SSLEngineConfigurator(SSLContextConfigurator.DEFAULT_CONFIG.createSSLContext(), true, false, false) : clientSSLEngineConfigurator;
        this.handshakeCompletionHandlerAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("SSLFilter-HandshakeCompletionHandlerAttr");
    }

    public int getMaxPendingBytesPerConnection() {
        return this.maxPendingBytes;
    }

    public void setMaxPendingBytesPerConnection(int maxPendingBytes) {
        this.maxPendingBytes = maxPendingBytes;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        SSLEngine sslEngine = SSLUtils.getSSLEngine(connection);
        if (sslEngine != null && !SSLUtils.isHandshaking(sslEngine)) {
            return super.handleRead(ctx);
        }
        if (sslEngine == null) {
            sslEngine = this.serverSSLEngineConfigurator.createSSLEngine();
            sslEngine.beginHandshake();
            SSLUtils.setSSLEngine(connection, sslEngine);
        }
        Buffer buffer = this.doHandshakeStep(sslEngine, ctx);
        boolean hasRemaining = buffer.hasRemaining();
        boolean isHandshaking = SSLUtils.isHandshaking(sslEngine);
        if (!isHandshaking) {
            this.notifyHandshakeCompleted(connection, sslEngine);
            if (hasRemaining) {
                ctx.setMessage(buffer);
                return super.handleRead(ctx);
            }
        }
        return ctx.getStopAction(hasRemaining ? buffer : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        SSLEngine sslEngine = SSLUtils.getSSLEngine(connection);
        if (sslEngine != null && !SSLUtils.isHandshaking(sslEngine)) {
            return this.accurateWrite(ctx, true);
        }
        Connection connection2 = connection;
        synchronized (connection2) {
            sslEngine = SSLUtils.getSSLEngine(connection);
            if (sslEngine == null) {
                this.handshake(connection, new PendingWriteCompletionHandler(connection), null, this.clientSSLEngineConfigurator);
            }
            return this.accurateWrite(ctx, false);
        }
    }

    private NextAction accurateWrite(FilterChainContext ctx, boolean isHandshakeComplete) throws IOException {
        Connection connection = ctx.getConnection();
        CompletionHandler completionHandler = this.handshakeCompletionHandlerAttr.get(connection);
        boolean isPendingHandler = completionHandler instanceof PendingWriteCompletionHandler;
        if (isHandshakeComplete && !isPendingHandler) {
            return super.handleWrite(ctx);
        }
        if (isPendingHandler) {
            if (!((PendingWriteCompletionHandler)completionHandler).add(ctx)) {
                return super.handleWrite(ctx);
            }
        } else {
            SSLEngine sslEngine = SSLUtils.getSSLEngine(connection);
            if (sslEngine != null && !SSLUtils.isHandshaking(sslEngine)) {
                return super.handleWrite(ctx);
            }
            throw new IllegalStateException("Handshake is not completed!");
        }
        return ctx.getSuspendAction();
    }

    public void handshake(Connection connection, CompletionHandler<SSLEngine> completionHandler) throws IOException {
        this.handshake(connection, completionHandler, null, this.clientSSLEngineConfigurator);
    }

    public void handshake(Connection connection, CompletionHandler<SSLEngine> completionHandler, Object dstAddress) throws IOException {
        this.handshake(connection, completionHandler, dstAddress, this.clientSSLEngineConfigurator);
    }

    public void handshake(Connection connection, CompletionHandler<SSLEngine> completionHandler, Object dstAddress, SSLEngineConfigurator sslEngineConfigurator) throws IOException {
        SSLEngine sslEngine = SSLUtils.getSSLEngine(connection);
        if (sslEngine == null) {
            sslEngine = sslEngineConfigurator.createSSLEngine();
            sslEngine.beginHandshake();
            SSLUtils.setSSLEngine(connection, sslEngine);
        } else {
            sslEngineConfigurator.configure(sslEngine);
            sslEngine.beginHandshake();
        }
        if (completionHandler != null) {
            this.handshakeCompletionHandlerAttr.set(connection, completionHandler);
            connection.addCloseListener(this.closeListener);
        }
        FilterChainContext ctx = this.createContext(connection, FilterChainContext.Operation.WRITE);
        this.doHandshakeStep(sslEngine, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer doHandshakeStep(SSLEngine sslEngine, FilterChainContext context) throws IOException {
        Connection connection = context.getConnection();
        Object dstAddress = context.getAddress();
        Buffer inputBuffer = (Buffer)context.getMessage();
        boolean isLoggingFinest = LOGGER.isLoggable(Level.FINEST);
        Connection connection2 = connection;
        synchronized (connection2) {
            SSLSession sslSession = sslEngine.getSession();
            int appBufferSize = sslSession.getApplicationBufferSize();
            SSLEngineResult.HandshakeStatus handshakeStatus = sslEngine.getHandshakeStatus();
            MemoryManager memoryManager = connection.getTransport().getMemoryManager();
            do {
                if (isLoggingFinest) {
                    LOGGER.log(Level.FINEST, "Loop Engine: {0} handshakeStatus={1}", new Object[]{sslEngine, sslEngine.getHandshakeStatus()});
                }
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        SSLEngineResult sslEngineResult;
                        Object outputBuffer;
                        if (isLoggingFinest) {
                            LOGGER.log(Level.FINEST, "NEED_UNWRAP Engine: {0}", sslEngine);
                        }
                        if (inputBuffer == null || !inputBuffer.hasRemaining()) {
                            return inputBuffer;
                        }
                        int expectedLength = SSLFilter.getSSLPacketSize(inputBuffer);
                        if (expectedLength == -1 || inputBuffer.remaining() < expectedLength) {
                            return inputBuffer;
                        }
                        int pos = inputBuffer.position();
                        if (!inputBuffer.isComposite()) {
                            ByteBuffer inputBB = inputBuffer.toByteBuffer();
                            outputBuffer = memoryManager.allocate(appBufferSize);
                            sslEngineResult = sslEngine.unwrap(inputBB, outputBuffer.toByteBuffer());
                            outputBuffer.dispose();
                            inputBuffer.position(pos + sslEngineResult.bytesConsumed());
                            if (inputBuffer.hasRemaining()) {
                                inputBuffer.compact();
                                inputBuffer.trim();
                            }
                        } else {
                            ByteBuffer inputByteBuffer = inputBuffer.toByteBuffer(pos, pos + expectedLength);
                            outputBuffer = memoryManager.allocate(appBufferSize);
                            sslEngineResult = sslEngine.unwrap(inputByteBuffer, outputBuffer.toByteBuffer());
                            inputBuffer.position(pos + sslEngineResult.bytesConsumed());
                            outputBuffer.dispose();
                        }
                        SSLEngineResult.Status status = sslEngineResult.getStatus();
                        if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                            return inputBuffer;
                        }
                        if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                            throw new SSLException("Buffer overflow");
                        }
                        handshakeStatus = sslEngine.getHandshakeStatus();
                        break;
                    }
                    case NEED_WRAP: {
                        SSLEngineResult sslEngineResult;
                        if (isLoggingFinest) {
                            LOGGER.log(Level.FINEST, "NEED_WRAP Engine: {0}", sslEngine);
                        }
                        Object buffer = memoryManager.allocate(sslEngine.getSession().getPacketBufferSize());
                        buffer.allowBufferDispose(true);
                        try {
                            sslEngineResult = sslEngine.wrap(Buffers.EMPTY_BYTE_BUFFER, buffer.toByteBuffer());
                            buffer.position(sslEngineResult.bytesProduced());
                            buffer.trim();
                            context.write(dstAddress, buffer, null);
                            handshakeStatus = sslEngine.getHandshakeStatus();
                            break;
                        }
                        catch (SSLException e) {
                            buffer.dispose();
                            throw e;
                        }
                        catch (IOException e) {
                            buffer.dispose();
                            throw e;
                        }
                        catch (Exception e) {
                            buffer.dispose();
                            throw new IOException("Unexpected exception", e);
                        }
                    }
                    case NEED_TASK: {
                        if (isLoggingFinest) {
                            LOGGER.log(Level.FINEST, "NEED_TASK Engine: {0}", sslEngine);
                        }
                        SSLUtils.executeDelegatedTask(sslEngine);
                        handshakeStatus = sslEngine.getHandshakeStatus();
                        break;
                    }
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        return inputBuffer;
                    }
                }
            } while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED);
            return inputBuffer;
        }
    }

    private void notifyHandshakeCompleted(Connection connection, SSLEngine sslEngine) {
        CompletionHandler completionHandler = this.handshakeCompletionHandlerAttr.get(connection);
        if (completionHandler != null) {
            connection.removeCloseListener(this.closeListener);
            completionHandler.completed(sslEngine);
            this.handshakeCompletionHandlerAttr.remove(connection);
        }
    }

    protected static int getSSLPacketSize(Buffer buf) throws SSLException {
        int len;
        if (buf.remaining() < 5) {
            return -1;
        }
        int pos = buf.position();
        byte byteZero = buf.get(pos);
        if (byteZero >= 20 && byteZero <= 23) {
            byte minor;
            byte major = buf.get(pos + 1);
            int v = major << 8 | (minor = buf.get(pos + 2));
            if (v < 768 || major > 3) {
                throw new SSLException("Unsupported record version major=" + major + " minor=" + minor);
            }
            len = ((buf.get(pos + 3) & 0xFF) << 8) + (buf.get(pos + 4) & 0xFF) + 5;
        } else {
            boolean isShort;
            boolean bl = isShort = (byteZero & 0x80) != 0;
            if (isShort && (buf.get(pos + 2) == 1 || buf.get(pos + 2) == 4)) {
                byte minor;
                byte major = buf.get(pos + 3);
                int v = major << 8 | (minor = buf.get(pos + 4));
                if ((v < 768 || major > 3) && v != 2) {
                    throw new SSLException("Unsupported record version major=" + major + " minor=" + minor);
                }
                int mask = isShort ? 127 : 63;
                len = ((byteZero & mask) << 8) + (buf.get(pos + 1) & 0xFF) + (isShort ? 2 : 3);
            } else {
                throw new SSLException("Unrecognized SSL message, plaintext connection?");
            }
        }
        return len;
    }

    private final class ConnectionCloseListener
    implements Connection.CloseListener {
        private ConnectionCloseListener() {
        }

        @Override
        public void onClosed(Connection connection) throws IOException {
            CompletionHandler completionHandler = (CompletionHandler)SSLFilter.this.handshakeCompletionHandlerAttr.remove(connection);
            if (completionHandler != null) {
                completionHandler.failed(new EOFException());
            }
        }
    }

    private final class PendingWriteCompletionHandler
    extends EmptyCompletionHandler<SSLEngine> {
        private final Connection connection;
        private final List<FilterChainContext> pendingWriteContexts;
        private int sizeInBytes = 0;
        private IOException error;
        private boolean isComplete;

        public PendingWriteCompletionHandler(Connection connection) {
            this.connection = connection;
            this.pendingWriteContexts = new LinkedList<FilterChainContext>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(FilterChainContext context) throws IOException {
            Connection connection = this.connection;
            synchronized (connection) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.isComplete) {
                    return false;
                }
                Buffer buffer = (Buffer)context.getMessage();
                int newSize = this.sizeInBytes + buffer.remaining();
                if (newSize > SSLFilter.this.maxPendingBytes) {
                    throw new PendingWriteQueueLimitExceededException("Max queued data limit exceeded: " + newSize + ">" + SSLFilter.this.maxPendingBytes);
                }
                this.sizeInBytes = newSize;
                this.pendingWriteContexts.add(context);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(SSLEngine result) {
            try {
                Connection connection = this.connection;
                synchronized (connection) {
                    this.isComplete = true;
                    for (FilterChainContext ctx : this.pendingWriteContexts) {
                        ctx.resume();
                    }
                    this.pendingWriteContexts.clear();
                    this.sizeInBytes = 0;
                }
            }
            catch (Exception e) {
                this.failed(e);
            }
        }

        @Override
        public void cancelled() {
            this.failed(new CancellationException());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable throwable) {
            Connection connection = this.connection;
            synchronized (connection) {
                this.error = throwable instanceof IOException ? (IOException)throwable : new IOException(throwable);
            }
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

