/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.glassfish.grizzly.AbstractTransformer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.TransportFactory;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.ssl.SSLUtils;

public final class SSLEncoderTransformer
extends AbstractTransformer<Buffer, Buffer> {
    public static final int NEED_HANDSHAKE_ERROR = 1;
    public static final int BUFFER_UNDERFLOW_ERROR = 2;
    public static final int BUFFER_OVERFLOW_ERROR = 3;
    private static final Logger LOGGER = Grizzly.logger(SSLEncoderTransformer.class);
    private static final TransformationResult<Buffer, Buffer> HANDSHAKE_NOT_EXECUTED_RESULT = TransformationResult.createErrorResult(1, "Handshake was not executed");
    private final MemoryManager<Buffer> memoryManager;

    public SSLEncoderTransformer() {
        this(TransportFactory.getInstance().getDefaultMemoryManager());
    }

    public SSLEncoderTransformer(MemoryManager<Buffer> memoryManager) {
        this.memoryManager = memoryManager;
    }

    @Override
    public String getName() {
        return SSLEncoderTransformer.class.getName();
    }

    @Override
    protected TransformationResult<Buffer, Buffer> transformImpl(AttributeStorage state, Buffer originalMessage) throws TransformationException {
        SSLEngine sslEngine = SSLUtils.getSSLEngine(state);
        if (sslEngine == null) {
            return HANDSHAKE_NOT_EXECUTED_RESULT;
        }
        Buffer targetBuffer = this.memoryManager.allocate(sslEngine.getSession().getPacketBufferSize());
        TransformationResult<Buffer, Buffer> transformationResult = null;
        try {
            SSLEngineResult sslEngineResult;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "SSLEncoder engine: {0} input: {1} output: {2}", new Object[]{sslEngine, originalMessage, targetBuffer});
            }
            int pos = originalMessage.position();
            if (!originalMessage.isComposite()) {
                sslEngineResult = sslEngine.wrap(originalMessage.toByteBuffer(), targetBuffer.toByteBuffer());
            } else {
                int appBufferSize = sslEngine.getSession().getApplicationBufferSize();
                ByteBuffer originalByteBuffer = originalMessage.toByteBuffer(pos, pos + Math.min(appBufferSize, originalMessage.remaining()));
                sslEngineResult = sslEngine.wrap(originalByteBuffer, targetBuffer.toByteBuffer());
            }
            originalMessage.position(pos + sslEngineResult.bytesConsumed());
            targetBuffer.position(sslEngineResult.bytesProduced());
            SSLEngineResult.Status status = sslEngineResult.getStatus();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "SSLEncoder done engine: {0} result: {1} input: {2} output: {3}", new Object[]{sslEngine, sslEngineResult, originalMessage, targetBuffer});
            }
            if (status == SSLEngineResult.Status.OK) {
                targetBuffer.trim();
                transformationResult = TransformationResult.createCompletedResult(targetBuffer, originalMessage);
            } else if (status == SSLEngineResult.Status.CLOSED) {
                targetBuffer.dispose();
                transformationResult = TransformationResult.createCompletedResult(Buffers.EMPTY_BUFFER, originalMessage);
            } else {
                targetBuffer.dispose();
                if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    transformationResult = TransformationResult.createErrorResult(2, "Buffer underflow during wrap operation");
                } else if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    transformationResult = TransformationResult.createErrorResult(3, "Buffer overflow during wrap operation");
                }
            }
        }
        catch (SSLException e) {
            targetBuffer.dispose();
            throw new TransformationException(e);
        }
        return transformationResult;
    }

    @Override
    public boolean hasInputRemaining(AttributeStorage storage, Buffer input) {
        return input != null && input.hasRemaining();
    }
}

