/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractSocketConnectorHandler;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.PostProcessor;
import org.glassfish.grizzly.ProcessorResult;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectionKeyHandler;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;

public class UDPNIOConnectorHandler
extends AbstractSocketConnectorHandler {
    private static final Logger LOGGER = Grizzly.logger(UDPNIOConnectorHandler.class);
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    protected boolean isReuseAddress;
    protected int connectionTimeout = 30000;
    private static final boolean[] isRegisterMap = new boolean[]{true, false, true, false, false, false, true};

    public UDPNIOConnectorHandler(UDPNIOTransport transport) {
        super(transport);
        this.connectionTimeout = transport.getConnectionTimeout();
        this.isReuseAddress = transport.isReuseAddress();
    }

    public GrizzlyFuture<Connection> connect() throws IOException {
        return this.connect((SocketAddress)null, (SocketAddress)null, (CompletionHandler)null);
    }

    @Override
    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) throws IOException {
        if (!this.transport.isBlocking()) {
            return this.connectAsync(remoteAddress, localAddress, completionHandler);
        }
        return this.connectSync(remoteAddress, localAddress, completionHandler);
    }

    protected GrizzlyFuture<Connection> connectSync(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) throws IOException {
        GrizzlyFuture<Connection> future = this.connectAsync(remoteAddress, localAddress, completionHandler);
        this.waitNIOFuture(future);
        return future;
    }

    protected GrizzlyFuture<Connection> connectAsync(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) throws IOException {
        DatagramChannel datagramChannel = DatagramChannel.open();
        DatagramSocket socket = datagramChannel.socket();
        socket.setReuseAddress(this.isReuseAddress);
        if (localAddress != null) {
            socket.bind(localAddress);
        }
        datagramChannel.configureBlocking(false);
        if (remoteAddress != null) {
            datagramChannel.connect(remoteAddress);
        }
        UDPNIOTransport nioTransport = (UDPNIOTransport)this.transport;
        UDPNIOConnection newConnection = nioTransport.obtainNIOConnection(datagramChannel);
        this.preConfigure(newConnection);
        newConnection.setProcessor(this.getProcessor());
        newConnection.setProcessorSelector(this.getProcessorSelector());
        SafeFutureImpl<Connection> connectFuture = SafeFutureImpl.create();
        GrizzlyFuture<RegisterChannelResult> registerChannelFuture = nioTransport.getNioChannelDistributor().registerChannelAsync(datagramChannel, 0, newConnection, new ConnectHandler(connectFuture, completionHandler));
        registerChannelFuture.markForRecycle(false);
        return connectFuture;
    }

    public boolean isReuseAddress() {
        return this.isReuseAddress;
    }

    public void setReuseAddress(boolean isReuseAddress) {
        this.isReuseAddress = isReuseAddress;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    protected <E> E waitNIOFuture(Future<E> future) throws IOException {
        try {
            return future.get(this.connectionTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException("Connection was interrupted!");
        }
        catch (TimeoutException e) {
            throw new IOException("Channel registration on Selector timeout!");
        }
        catch (ExecutionException e) {
            Throwable internalException = e.getCause();
            if (internalException instanceof IOException) {
                throw (IOException)internalException;
            }
            throw new IOException("Unexpected exception connection exception. " + internalException.getClass().getName() + ": " + internalException.getMessage());
        }
        catch (CancellationException e) {
            throw new IOException("Connection was cancelled!");
        }
    }

    private static void fireConnectEvent(UDPNIOConnection connection, FutureImpl<Connection> connectFuture, CompletionHandler<Connection> completionHandler) throws IOException {
        try {
            UDPNIOTransport udpTransport = (UDPNIOTransport)connection.getTransport();
            udpTransport.fireIOEvent(IOEvent.CONNECTED, connection, new EnableReadPostProcessor(connectFuture, completionHandler));
        }
        catch (Exception e) {
            if (completionHandler != null) {
                completionHandler.failed(e);
            }
            connectFuture.failure(e);
            throw new IOException("Connect exception", e);
        }
    }

    private static class EnableReadPostProcessor
    implements PostProcessor {
        private final FutureImpl<Connection> connectFuture;
        private final CompletionHandler<Connection> completionHandler;

        private EnableReadPostProcessor(FutureImpl connectFuture, CompletionHandler<Connection> completionHandler) {
            this.connectFuture = connectFuture;
            this.completionHandler = completionHandler;
        }

        @Override
        public void process(Context context, ProcessorResult.Status status) throws IOException {
            if (isRegisterMap[status.ordinal()]) {
                NIOConnection connection = (NIOConnection)context.getConnection();
                if (this.completionHandler != null) {
                    this.completionHandler.completed(connection);
                }
                this.connectFuture.result(connection);
                if (!connection.isStandalone()) {
                    connection.enableIOEvent(IOEvent.READ);
                }
            }
        }
    }

    private final class ConnectHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        private final FutureImpl<Connection> connectFuture;
        private final CompletionHandler<Connection> completionHandler;

        private ConnectHandler(FutureImpl<Connection> connectFuture, CompletionHandler<Connection> completionHandler) {
            this.connectFuture = connectFuture;
            this.completionHandler = completionHandler;
        }

        @Override
        public void completed(RegisterChannelResult result) {
            UDPNIOTransport transport = (UDPNIOTransport)UDPNIOConnectorHandler.this.transport;
            transport.registerChannelCompletionHandler.completed(result);
            SelectionKey selectionKey = result.getSelectionKey();
            SelectionKeyHandler selectionKeyHandler = transport.getSelectionKeyHandler();
            UDPNIOConnection connection = (UDPNIOConnection)selectionKeyHandler.getConnectionForKey(selectionKey);
            try {
                connection.onConnect();
                UDPNIOConnectorHandler.fireConnectEvent(connection, this.connectFuture, this.completionHandler);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Exception happened, when trying to connect the channel", e);
            }
        }
    }
}

