/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.Reader;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.streams.AbstractStreamReader;
import org.glassfish.grizzly.streams.BufferedInput;

public final class DefaultStreamReader
extends AbstractStreamReader {
    public DefaultStreamReader(Connection connection) {
        super(connection, new Input());
        ((Input)this.input).parentStreamReader = this;
    }

    public Input getSource() {
        return (Input)this.input;
    }

    public static final class Input
    extends BufferedInput {
        private DefaultStreamReader parentStreamReader;
        private boolean isDone;

        @Override
        protected void onOpenInputSource() throws IOException {
            this.isDone = false;
            Connection connection = this.parentStreamReader.getConnection();
            Transport transport = connection.getTransport();
            Reader reader = transport.getReader(connection);
            reader.read(connection, null, null, new Interceptor(){

                public int intercept(int event, Object context, Object result) {
                    if (event == 1) {
                        ReadResult readResult = (ReadResult)result;
                        Buffer buffer = (Buffer)readResult.getMessage();
                        readResult.setMessage(null);
                        if (buffer == null) {
                            return 2;
                        }
                        buffer.trim();
                        Input.this.append(buffer);
                        if (Input.this.isDone) {
                            return 1;
                        }
                        return 6;
                    }
                    return 0;
                }
            });
        }

        @Override
        protected void onCloseInputSource() throws IOException {
            this.isDone = true;
        }

        @Override
        protected void notifyCompleted(CompletionHandler<Integer> completionHandler) {
            if (completionHandler != null) {
                completionHandler.completed(this.compositeBuffer.remaining());
            }
        }

        @Override
        protected void notifyFailure(CompletionHandler<Integer> completionHandler, Throwable failure) {
            if (completionHandler != null) {
                completionHandler.failed(failure);
            }
        }
    }
}

