/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.tmpselectors;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractWriter;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorsEnabledTransport;

public abstract class TemporarySelectorWriter
extends AbstractWriter<SocketAddress> {
    private static final Logger LOGGER = Grizzly.logger(TemporarySelectorWriter.class);
    protected final TemporarySelectorsEnabledTransport transport;

    public TemporarySelectorWriter(TemporarySelectorsEnabledTransport transport) {
        this.transport = transport;
    }

    @Override
    public GrizzlyFuture<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult<Buffer, SocketAddress>> interceptor) throws IOException {
        return this.write(connection, dstAddress, buffer, completionHandler, interceptor, ((NIOConnection)connection).getWriteTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public GrizzlyFuture<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer message, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult<Buffer, SocketAddress>> interceptor, long timeout, TimeUnit timeunit) throws IOException {
        if (message == null) {
            throw new IllegalStateException("Message cannot be null.");
        }
        if (connection == null || !(connection instanceof NIOConnection)) {
            throw new IllegalStateException("Connection should be NIOConnection and cannot be null.");
        }
        WriteResult writeResult = WriteResult.create(connection, message, dstAddress, 0);
        this.write0(connection, dstAddress, message, writeResult, timeout, timeunit);
        ReadyFutureImpl<WriteResult<Buffer, SocketAddress>> writeFuture = ReadyFutureImpl.create(writeResult);
        if (completionHandler != null) {
            completionHandler.completed(writeResult);
        }
        message.tryDispose();
        return writeFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int write0(Connection connection, SocketAddress dstAddress, Buffer buffer, WriteResult currentResult, long timeout, TimeUnit timeunit) throws IOException {
        NIOConnection nioConnection = (NIOConnection)connection;
        SelectableChannel channel = nioConnection.getChannel();
        long writeTimeout = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        int bytesWritten = 0;
        try {
            while (buffer.hasRemaining()) {
                int len = this.writeNow0(connection, dstAddress, buffer, currentResult);
                if (len > 0) {
                    attempts = 0;
                    bytesWritten += len;
                    continue;
                }
                ++attempts;
                if (writeSelector == null) {
                    writeSelector = this.transport.getTemporarySelectorIO().getSelectorPool().poll();
                    if (writeSelector == null) continue;
                    key = channel.register(writeSelector, 4);
                }
                if (writeSelector.select(writeTimeout) != 0 || attempts <= 2) continue;
                throw new IOException("Client disconnected");
            }
        }
        finally {
            this.transport.getTemporarySelectorIO().recycleTemporaryArtifacts(writeSelector, key);
        }
        return bytesWritten;
    }

    public TemporarySelectorsEnabledTransport getTransport() {
        return this.transport;
    }

    protected abstract int writeNow0(Connection var1, SocketAddress var2, Buffer var3, WriteResult var4) throws IOException;
}

