/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Strategy;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.nio.AbstractNIOConnection;
import org.glassfish.grizzly.nio.AbstractNIOTransport;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.SelectionKeyHandler;
import org.glassfish.grizzly.nio.SelectorFactory;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorHandlerTask;
import org.glassfish.grizzly.threadpool.WorkerThread;
import org.glassfish.grizzly.utils.LinkedTransferQueue;
import org.glassfish.grizzly.utils.StateHolder;

public final class SelectorRunner
implements Runnable {
    private static final Logger logger = Grizzly.logger(SelectorRunner.class);
    private final NIOTransport transport;
    private final StateHolder<Transport.State> stateHolder;
    private final Queue<SelectorHandlerTask> pendingTasks;
    private final Queue<SelectorHandlerTask> postponedTasks;
    private volatile Selector selector;
    private volatile Thread selectorRunnerThread;
    private boolean isResume;
    private int lastSelectedKeysCount;
    private Iterator<SelectionKey> iterator;
    private SelectionKey key = null;
    private int keyReadyOps;

    public SelectorRunner(NIOTransport transport) {
        this(transport, null);
    }

    public SelectorRunner(NIOTransport transport, Selector selector) {
        this.transport = transport;
        this.selector = selector;
        this.stateHolder = new StateHolder<Transport.State>(Transport.State.STOP);
        this.pendingTasks = new LinkedTransferQueue<SelectorHandlerTask>();
        this.postponedTasks = new LinkedList<SelectorHandlerTask>();
    }

    public NIOTransport getTransport() {
        return this.transport;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public Thread getRunnerThread() {
        return this.selectorRunnerThread;
    }

    public StateHolder<Transport.State> getStateHolder() {
        return this.stateHolder;
    }

    public Transport.State getState() {
        return this.stateHolder.getState();
    }

    public void postpone() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof WorkerThread) {
            ((WorkerThread)((Object)currentThread)).setSelectorThread(false);
        }
        this.selectorRunnerThread = null;
        this.isResume = true;
    }

    public synchronized void start() {
        if (this.stateHolder.getState() != Transport.State.STOP) {
            logger.log(Level.WARNING, "SelectorRunner is not in the stopped state!");
        }
        this.stateHolder.setState(Transport.State.STARTING);
        this.transport.getThreadPool().execute(this);
    }

    public void startBlocking(int timeout) throws TimeoutException {
        this.start();
        Future<Transport.State> future = this.stateHolder.notifyWhenStateIsEqual(Transport.State.START, null);
        try {
            future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException ignored) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void stop() {
        this.stateHolder.setState(Transport.State.STOPPING);
        this.wakeupSelector();
        this.pendingTasks.clear();
        this.postponedTasks.clear();
        Selector localSelector = this.selector;
        if (localSelector != null) {
            try {
                SelectionKey[] keys = new SelectionKey[]{};
                while (true) {
                    try {
                        keys = localSelector.keys().toArray(keys);
                    }
                    catch (ConcurrentModificationException ignore) {
                        continue;
                    }
                    break;
                }
                for (SelectionKey selectionKey : keys) {
                    NIOConnection connection = this.transport.getSelectionKeyHandler().getConnectionForKey(selectionKey);
                    try {
                        ((AbstractNIOTransport)this.transport).closeConnection(connection);
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
            }
            catch (ClosedSelectorException closedSelectorException) {
                // empty catch block
            }
        }
    }

    public void stopBlocking(int timeout) throws TimeoutException {
        this.stop();
        Future<Transport.State> future = this.stateHolder.notifyWhenStateIsEqual(Transport.State.STOP, null);
        try {
            future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException ignored) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void wakeupSelector() {
        Selector localSelector = this.selector;
        if (localSelector != null) {
            try {
                localSelector.wakeup();
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error during selector wakeup", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread currentThread;
        this.selectorRunnerThread = currentThread = Thread.currentThread();
        boolean isWorkerThread = currentThread instanceof WorkerThread;
        if (isWorkerThread) {
            ((WorkerThread)((Object)currentThread)).setSelectorThread(true);
        }
        if (!this.isResume) {
            this.selectorRunnerThread.setName(this.selectorRunnerThread.getName() + " SelectorRunner");
            this.stateHolder.setState(Transport.State.START);
        }
        StateHolder<Transport.State> transportStateHolder = this.transport.getState();
        boolean isSkipping = false;
        try {
            while (!isSkipping && !this.isStop()) {
                if (transportStateHolder.getState() != Transport.State.PAUSE) {
                    isSkipping = !this.doSelect();
                    continue;
                }
                try {
                    Future<Transport.State> future = transportStateHolder.notifyWhenStateIsNotEqual(Transport.State.PAUSE, null);
                    future.get(5000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception ignored) {}
            }
        }
        finally {
            if (!isSkipping) {
                this.stateHolder.setState(Transport.State.STOP);
                this.selectorRunnerThread = null;
            }
            if (isWorkerThread) {
                ((WorkerThread)((Object)currentThread)).setSelectorThread(false);
            }
        }
    }

    protected boolean doSelect() {
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        try {
            if (this.isResume) {
                this.isResume = false;
                if (this.keyReadyOps != 0 && !this.iterateKeyEvents()) {
                    return false;
                }
                if (!this.iterateKeys()) {
                    return false;
                }
            }
            this.lastSelectedKeysCount = 0;
            selectorHandler.preSelect(this);
            Set<SelectionKey> readyKeys = selectorHandler.select(this);
            if (this.stateHolder.getState() == Transport.State.STOPPING) {
                return false;
            }
            this.lastSelectedKeysCount = readyKeys.size();
            if (this.lastSelectedKeysCount != 0) {
                this.iterator = readyKeys.iterator();
                if (!this.iterateKeys()) {
                    return false;
                }
            }
            this.iterator = null;
            selectorHandler.postSelect(this);
        }
        catch (ClosedSelectorException e) {
            if (this.isRunning() && selectorHandler.onSelectorClosed(this)) {
                return true;
            }
            this.notifyConnectionException(this.key, "Selector was unexpectedly closed", e, Level.SEVERE, Level.FINE);
        }
        catch (Exception e) {
            this.notifyConnectionException(this.key, "doSelect exception", e, Level.SEVERE, Level.FINE);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "doSelect exception", t);
            this.transport.notifyTransportError(t);
        }
        return true;
    }

    private boolean iterateKeys() {
        while (this.iterator.hasNext()) {
            try {
                this.key = this.iterator.next();
                this.iterator.remove();
                if (this.key.isValid()) {
                    this.keyReadyOps = this.key.readyOps();
                    if (this.iterateKeyEvents()) continue;
                    return false;
                }
                this.transport.getSelectionKeyHandler().cancel(this.key);
            }
            catch (IOException e) {
                this.keyReadyOps = 0;
                this.notifyConnectionException(this.key, "Unexpected IOException. Channel " + this.key.channel() + " will be closed.", e, Level.WARNING, Level.FINE);
            }
            catch (CancelledKeyException e) {
                this.keyReadyOps = 0;
                this.notifyConnectionException(this.key, "Unexpected CancelledKeyException. Channel " + this.key.channel() + " will be closed.", e, Level.FINE, Level.FINE);
            }
        }
        return true;
    }

    private boolean iterateKeyEvents() throws IOException {
        SelectionKeyHandler selectionKeyHandler = this.transport.getSelectionKeyHandler();
        Strategy strategy = this.transport.getStrategy();
        IOEvent[] ioEvents = selectionKeyHandler.getIOEvents(this.keyReadyOps);
        AbstractNIOConnection connection = (AbstractNIOConnection)selectionKeyHandler.getConnectionForKey(this.key);
        for (IOEvent ioEvent : ioEvents) {
            AbstractNIOConnection.notifyIOEventReady(connection, ioEvent);
            int interest = selectionKeyHandler.ioEvent2SelectionKeyInterest(ioEvent);
            this.keyReadyOps &= ~interest;
            if (!selectionKeyHandler.onProcessInterest(this.key, interest) || strategy.executeIoEvent(connection, ioEvent)) continue;
            return false;
        }
        return true;
    }

    public Queue<SelectorHandlerTask> getPendingTasks() {
        return this.pendingTasks;
    }

    public Queue<SelectorHandlerTask> getPostponedTasks() {
        return this.postponedTasks;
    }

    private boolean isStop() {
        Transport.State state = this.stateHolder.getState();
        if (state == Transport.State.STOP || state == Transport.State.STOPPING) {
            return true;
        }
        state = this.transport.getState().getState();
        return state == Transport.State.STOP || state == Transport.State.STOPPING;
    }

    private boolean isRunning() {
        return this.stateHolder.getState() == Transport.State.START && this.transport.getState().getState() == Transport.State.START;
    }

    private void notifyConnectionException(SelectionKey key, String description, Exception e, Level runLogLevel, Level stoppedLogLevel) {
        if (this.isRunning()) {
            logger.log(runLogLevel, description, e);
            if (key != null) {
                try {
                    this.transport.getSelectionKeyHandler().cancel(key);
                }
                catch (IOException cancelException) {
                    logger.log(Level.FINE, "IOException during cancelling key", cancelException);
                }
            }
            this.transport.notifyTransportError(e);
        } else {
            logger.log(stoppedLogLevel, description, e);
        }
    }

    public int getLastSelectedKeysCount() {
        return this.lastSelectedKeysCount;
    }

    protected final void switchToNewSelector() throws IOException {
        Selector oldSelector = this.selector;
        Selector newSelector = SelectorFactory.instance().create();
        Set<SelectionKey> keys = oldSelector.keys();
        for (SelectionKey selectionKey : keys) {
            try {
                selectionKey.channel().register(newSelector, selectionKey.interestOps(), selectionKey.attachment());
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error switching channel to a new selector", e);
            }
        }
        this.selector = newSelector;
        try {
            oldSelector.close();
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }
}

