/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.TransportFactory;
import org.glassfish.grizzly.nio.DefaultSelectionKeyHandler;
import org.glassfish.grizzly.nio.DefaultSelectorHandler;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.SelectionKeyHandler;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorPool;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;

public abstract class NIOTransportFactory
extends TransportFactory {
    protected SelectorHandler defaultSelectorHandler;
    protected SelectionKeyHandler defaultSelectionKeyHandler;
    protected TemporarySelectorPool defaultTemporarySelectorPool;

    public SelectorHandler getDefaultSelectorHandler() {
        return this.defaultSelectorHandler;
    }

    public void setDefaultSelectorHandler(SelectorHandler defaultSelectorHandler) {
        this.defaultSelectorHandler = defaultSelectorHandler;
    }

    public SelectionKeyHandler getDefaultSelectionKeyHandler() {
        return this.defaultSelectionKeyHandler;
    }

    public void setDefaultSelectionKeyHandler(SelectionKeyHandler defaultSelectionKeyHandler) {
        this.defaultSelectionKeyHandler = defaultSelectionKeyHandler;
    }

    public TemporarySelectorPool getDefaultTemporarySelectorPool() {
        return this.defaultTemporarySelectorPool;
    }

    public void setDefaultTemporarySelectorPool(TemporarySelectorPool defaultTemporarySelectorPool) {
        this.defaultTemporarySelectorPool = defaultTemporarySelectorPool;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.defaultSelectorHandler = new DefaultSelectorHandler();
        this.defaultSelectionKeyHandler = new DefaultSelectionKeyHandler();
        int selectorPoolSize = 32;
        if (this.defaultWorkerThreadPool instanceof AbstractThreadPool) {
            selectorPoolSize = Math.min(((AbstractThreadPool)this.defaultWorkerThreadPool).getConfig().getMaxPoolSize(), selectorPoolSize);
        }
        this.defaultTemporarySelectorPool = new TemporarySelectorPool(selectorPoolSize);
    }

    @Override
    protected <T extends Transport> T setupTransport(T transport) {
        transport = super.setupTransport(transport);
        NIOTransport nioTransport = (NIOTransport)transport;
        nioTransport.setSelectorHandler(this.defaultSelectorHandler);
        nioTransport.setSelectionKeyHandler(this.defaultSelectionKeyHandler);
        return transport;
    }
}

