/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.nio.channels.Selector;
import org.glassfish.grizzly.AbstractTransport;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.TransportProbe;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.SelectionKeyHandler;
import org.glassfish.grizzly.nio.SelectorFactory;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorRunner;

public abstract class AbstractNIOTransport
extends AbstractTransport
implements NIOTransport {
    protected SelectorHandler selectorHandler;
    protected SelectionKeyHandler selectionKeyHandler;
    protected int selectorRunnersCount;
    protected SelectorRunner[] selectorRunners;
    protected NIOChannelDistributor nioChannelDistributor;

    public AbstractNIOTransport(String name) {
        super(name);
    }

    @Override
    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    @Override
    public void setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
        AbstractNIOTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    @Override
    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
        AbstractNIOTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public int getSelectorRunnersCount() {
        return this.selectorRunnersCount;
    }

    @Override
    public void setSelectorRunnersCount(int selectorRunnersCount) {
        this.selectorRunnersCount = selectorRunnersCount;
        AbstractNIOTransport.notifyProbesConfigChanged(this);
    }

    protected synchronized void startSelectorRunners() throws IOException {
        this.selectorRunners = new SelectorRunner[this.selectorRunnersCount];
        for (int i = 0; i < this.selectorRunnersCount; ++i) {
            SelectorRunner runner = new SelectorRunner(this, SelectorFactory.instance().create());
            runner.start();
            this.selectorRunners[i] = runner;
        }
    }

    protected synchronized void stopSelectorRunners() throws IOException {
        if (this.selectorRunners == null) {
            return;
        }
        for (int i = 0; i < this.selectorRunners.length; ++i) {
            SelectorRunner runner = this.selectorRunners[i];
            if (runner == null) continue;
            runner.stop();
            this.selectorRunners[i] = null;
            Selector selector = runner.getSelector();
            if (selector == null) continue;
            try {
                selector.close();
                continue;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        this.selectorRunners = null;
    }

    @Override
    public NIOChannelDistributor getNioChannelDistributor() {
        return this.nioChannelDistributor;
    }

    @Override
    public void setNioChannelDistributor(NIOChannelDistributor nioChannelDistributor) {
        this.nioChannelDistributor = nioChannelDistributor;
        AbstractNIOTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public void notifyTransportError(Throwable error) {
        AbstractNIOTransport.notifyProbesError(this, error);
    }

    protected SelectorRunner[] getSelectorRunners() {
        return this.selectorRunners;
    }

    protected static void notifyProbesError(AbstractNIOTransport transport, Throwable error) {
        TransportProbe[] probes = (TransportProbe[])transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onErrorEvent(transport, error);
            }
        }
    }

    protected static void notifyProbesStart(AbstractNIOTransport transport) {
        TransportProbe[] probes = (TransportProbe[])transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onStartEvent(transport);
            }
        }
    }

    protected static void notifyProbesStop(AbstractNIOTransport transport) {
        TransportProbe[] probes = (TransportProbe[])transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onStopEvent(transport);
            }
        }
    }

    protected static void notifyProbesPause(AbstractNIOTransport transport) {
        TransportProbe[] probes = (TransportProbe[])transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onPauseEvent(transport);
            }
        }
    }

    protected static void notifyProbesResume(AbstractNIOTransport transport) {
        TransportProbe[] probes = (TransportProbe[])transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onResumeEvent(transport);
            }
        }
    }

    @Override
    protected abstract void closeConnection(Connection var1) throws IOException;
}

