/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.StandaloneProcessorSelector;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncReadQueueRecord;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.IndexedAttributeHolder;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.monitoring.MonitoringConfig;
import org.glassfish.grizzly.monitoring.MonitoringConfigImpl;
import org.glassfish.grizzly.nio.AbstractNIOTransport;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectionKeyHandler;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.utils.LinkedTransferQueue;

public abstract class AbstractNIOConnection
implements NIOConnection {
    private static final Logger logger = Grizzly.logger(AbstractNIOConnection.class);
    protected final NIOTransport transport;
    protected volatile int readBufferSize;
    protected volatile int writeBufferSize;
    protected volatile long readTimeoutMillis = 30000L;
    protected volatile long writeTimeoutMillis = 30000L;
    protected volatile SelectorRunner selectorRunner;
    protected volatile SelectableChannel channel;
    protected volatile SelectionKey selectionKey;
    protected volatile Processor processor;
    protected volatile ProcessorSelector processorSelector;
    protected final AttributeHolder attributes;
    protected final TaskQueue<AsyncReadQueueRecord> asyncReadQueue;
    protected final TaskQueue<AsyncWriteQueueRecord> asyncWriteQueue;
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    protected volatile boolean isBlocking;
    protected volatile boolean isStandalone;
    private final Queue<Connection.CloseListener> closeListeners = new LinkedTransferQueue<Connection.CloseListener>();
    protected final MonitoringConfigImpl<ConnectionProbe> monitoringConfig = new MonitoringConfigImpl<ConnectionProbe>(ConnectionProbe.class);

    public AbstractNIOConnection(NIOTransport transport) {
        this.transport = transport;
        this.asyncReadQueue = TaskQueue.createSafeTaskQueue();
        this.asyncWriteQueue = TaskQueue.createSafeTaskQueue();
        this.attributes = new IndexedAttributeHolder(transport.getAttributeBuilder());
    }

    @Override
    public void configureBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    @Override
    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Override
    public synchronized void configureStandalone(boolean isStandalone) {
        if (this.isStandalone != isStandalone) {
            this.isStandalone = isStandalone;
            if (isStandalone) {
                this.processor = StandaloneProcessor.INSTANCE;
                this.processorSelector = StandaloneProcessorSelector.INSTANCE;
            } else {
                this.processor = this.transport.getProcessor();
                this.processorSelector = this.transport.getProcessorSelector();
            }
        }
    }

    @Override
    public boolean isStandalone() {
        return this.isStandalone;
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    @Override
    public long getReadTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setReadTimeout(long timeout, TimeUnit timeUnit) {
        this.readTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    @Override
    public long getWriteTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.writeTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setWriteTimeout(long timeout, TimeUnit timeUnit) {
        this.writeTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    @Override
    public SelectorRunner getSelectorRunner() {
        return this.selectorRunner;
    }

    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        this.selectorRunner = selectorRunner;
    }

    @Override
    public void attachToSelectorRunner(SelectorRunner selectorRunner) throws IOException {
        this.detachSelectorRunner();
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        GrizzlyFuture<RegisterChannelResult> future = selectorHandler.registerChannelAsync(selectorRunner, this.channel, 0, this, null);
        try {
            RegisterChannelResult result = (RegisterChannelResult)future.get(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
            this.selectorRunner = selectorRunner;
            this.selectionKey = result.getSelectionKey();
        }
        catch (InterruptedException e) {
            throw new IOException("", e);
        }
        catch (ExecutionException e) {
            throw new IOException("", e.getCause());
        }
        catch (TimeoutException e) {
            throw new IOException("", e);
        }
    }

    @Override
    public void detachSelectorRunner() throws IOException {
        SelectorRunner selectorRunnerLocal = this.selectorRunner;
        this.selectionKey = null;
        this.selectorRunner = null;
        if (selectorRunnerLocal != null) {
            this.transport.getSelectorHandler().unregisterChannel(selectorRunnerLocal, this.channel);
        }
    }

    @Override
    public SelectableChannel getChannel() {
        return this.channel;
    }

    protected void setChannel(SelectableChannel channel) {
        this.channel = channel;
    }

    @Override
    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    protected void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
        this.setChannel(selectionKey.channel());
    }

    @Override
    public Processor obtainProcessor(IOEvent ioEvent) {
        Processor selectedProcessor;
        if (this.processor == null && this.processorSelector == null) {
            return this.transport.obtainProcessor(ioEvent, this);
        }
        if (this.processor != null && this.processor.isInterested(ioEvent)) {
            return this.processor;
        }
        if (this.processorSelector != null && (selectedProcessor = this.processorSelector.select(ioEvent, this)) != null) {
            return selectedProcessor;
        }
        return null;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void setProcessor(Processor preferableProcessor) {
        this.processor = preferableProcessor;
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        return this.processorSelector;
    }

    @Override
    public void setProcessorSelector(ProcessorSelector preferableProcessorSelector) {
        this.processorSelector = preferableProcessorSelector;
    }

    public TaskQueue<AsyncReadQueueRecord> getAsyncReadQueue() {
        return this.asyncReadQueue;
    }

    public TaskQueue<AsyncWriteQueueRecord> getAsyncWriteQueue() {
        return this.asyncWriteQueue;
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    @Override
    public <M> GrizzlyFuture<ReadResult<M, SocketAddress>> read() throws IOException {
        return this.read((CompletionHandler<ReadResult<M, SocketAddress>>)null);
    }

    @Override
    public <M> GrizzlyFuture<ReadResult<M, SocketAddress>> read(CompletionHandler<ReadResult<M, SocketAddress>> completionHandler) throws IOException {
        Processor obtainedProcessor = this.obtainProcessor(IOEvent.READ);
        return obtainedProcessor.read(this, completionHandler);
    }

    @Override
    public <M> GrizzlyFuture<WriteResult<M, SocketAddress>> write(M message) throws IOException {
        return this.write(null, message, null);
    }

    @Override
    public <M> GrizzlyFuture<WriteResult<M, SocketAddress>> write(M message, CompletionHandler<WriteResult<M, SocketAddress>> completionHandler) throws IOException {
        return this.write(null, message, completionHandler);
    }

    @Override
    public <M> GrizzlyFuture<WriteResult<M, SocketAddress>> write(SocketAddress dstAddress, M message, CompletionHandler<WriteResult<M, SocketAddress>> completionHandler) throws IOException {
        Processor obtainedProcessor = this.obtainProcessor(IOEvent.WRITE);
        return obtainedProcessor.write(this, dstAddress, message, completionHandler);
    }

    @Override
    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen() && !this.isClosed.get();
    }

    @Override
    public GrizzlyFuture close() throws IOException {
        if (!this.isClosed.getAndSet(true)) {
            this.preClose();
            this.notifyCloseListeners();
            AbstractNIOConnection.notifyProbesClose(this);
            return this.transport.getSelectorHandler().executeInSelectorThread(this.selectorRunner, new Runnable(){

                @Override
                public void run() {
                    try {
                        ((AbstractNIOTransport)AbstractNIOConnection.this.transport).closeConnection(AbstractNIOConnection.this);
                    }
                    catch (IOException e) {
                        logger.log(Level.FINE, "Error during connection close", e);
                    }
                }
            }, null);
        }
        return ReadyFutureImpl.create(this);
    }

    @Override
    public void addCloseListener(Connection.CloseListener closeListener) {
        if (!this.isClosed.get()) {
            this.closeListeners.add(closeListener);
            if (this.isClosed.get() && this.closeListeners.remove(closeListener)) {
                try {
                    closeListener.onClosed(this);
                }
                catch (IOException ignored) {}
            }
        } else {
            try {
                closeListener.onClosed(this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean removeCloseListener(Connection.CloseListener closeListener) {
        return this.closeListeners.remove(closeListener);
    }

    @Override
    public void notifyConnectionError(Throwable error) {
        AbstractNIOConnection.notifyProbesError(this, error);
    }

    @Override
    public final MonitoringConfig<ConnectionProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    protected static void notifyProbesBind(AbstractNIOConnection connection) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onBindEvent(connection);
            }
        }
    }

    protected static void notifyProbesAccept(AbstractNIOConnection connection) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onAcceptEvent(connection);
            }
        }
    }

    protected static void notifyProbesConnect(AbstractNIOConnection connection) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onConnectEvent(connection);
            }
        }
    }

    protected static void notifyProbesRead(AbstractNIOConnection connection, Buffer data, int size) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onReadEvent(connection, data, size);
            }
        }
    }

    protected static void notifyProbesWrite(AbstractNIOConnection connection, Buffer data, int size) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onWriteEvent(connection, data, size);
            }
        }
    }

    protected static void notifyIOEventReady(AbstractNIOConnection connection, IOEvent ioEvent) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onIOEventReadyEvent(connection, ioEvent);
            }
        }
    }

    protected static void notifyIOEventEnabled(AbstractNIOConnection connection, IOEvent ioEvent) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onIOEventEnableEvent(connection, ioEvent);
            }
        }
    }

    protected static void notifyIOEventDisabled(AbstractNIOConnection connection, IOEvent ioEvent) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onIOEventDisableEvent(connection, ioEvent);
            }
        }
    }

    protected static void notifyProbesClose(AbstractNIOConnection connection) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onCloseEvent(connection);
            }
        }
    }

    protected static void notifyProbesError(AbstractNIOConnection connection, Throwable error) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onErrorEvent(connection, error);
            }
        }
    }

    private void notifyCloseListeners() {
        Connection.CloseListener closeListener;
        while ((closeListener = this.closeListeners.poll()) != null) {
            try {
                closeListener.onClosed(this);
            }
            catch (IOException iOException) {}
        }
    }

    protected abstract void preClose();

    @Override
    public final void enableIOEvent(IOEvent ioEvent) throws IOException {
        SelectionKeyHandler selectionKeyHandler = this.transport.getSelectionKeyHandler();
        int interest = selectionKeyHandler.ioEvent2SelectionKeyInterest(ioEvent);
        if (interest == 0) {
            return;
        }
        AbstractNIOConnection.notifyIOEventEnabled(this, ioEvent);
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        selectorHandler.registerKeyInterest(this.selectorRunner, this.selectionKey, selectionKeyHandler.ioEvent2SelectionKeyInterest(ioEvent));
    }

    @Override
    public final void disableIOEvent(IOEvent ioEvent) throws IOException {
        SelectionKeyHandler selectionKeyHandler = this.transport.getSelectionKeyHandler();
        int interest = selectionKeyHandler.ioEvent2SelectionKeyInterest(ioEvent);
        if (interest == 0) {
            return;
        }
        AbstractNIOConnection.notifyIOEventDisabled(this, ioEvent);
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        selectorHandler.unregisterKeyInterest(this.selectorRunner, this.selectionKey, interest);
    }
}

