/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractReader;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.glassfish.grizzly.asyncqueue.AsyncReadQueueRecord;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.AbstractNIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;

public abstract class AbstractNIOAsyncQueueReader
extends AbstractReader<SocketAddress>
implements AsyncQueueReader<SocketAddress> {
    private static final Logger LOGGER = Grizzly.logger(AbstractNIOAsyncQueueReader.class);
    private static final AsyncReadQueueRecord LOCK_RECORD = AsyncReadQueueRecord.create(null, null, null, null, null);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected int defaultBufferSize = 8192;
    protected NIOTransport transport;

    public AbstractNIOAsyncQueueReader(NIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public GrizzlyFuture<ReadResult<Buffer, SocketAddress>> read(Connection connection, Buffer buffer, CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler, Interceptor<ReadResult> interceptor) throws IOException {
        if (connection == null) {
            throw new IOException("Connection is null");
        }
        if (!connection.isOpen()) {
            throw new IOException("Connection is closed");
        }
        TaskQueue<AsyncReadQueueRecord> connectionQueue = ((AbstractNIOConnection)connection).getAsyncReadQueue();
        ReadResult currentResult = ReadResult.create(connection, buffer, null, 0);
        AsyncReadQueueRecord queueRecord = AsyncReadQueueRecord.create(buffer, null, currentResult, completionHandler, interceptor);
        Queue<AsyncReadQueueRecord> queue = connectionQueue.getQueue();
        AtomicReference<AsyncReadQueueRecord> currentElement = connectionQueue.getCurrentElementAtomic();
        boolean isLocked = currentElement.compareAndSet(null, LOCK_RECORD);
        try {
            if (isLocked) {
                this.doRead(connection, queueRecord);
                int interceptInstructions = this.intercept(connection, 1, queueRecord, currentResult);
                if ((interceptInstructions & 1) != 0 || interceptor == null && this.isFinished(connection, queueRecord)) {
                    AsyncReadQueueRecord nextRecord = queue.poll();
                    currentElement.set(nextRecord);
                    this.onReadComplete(connection, queueRecord);
                    if (nextRecord == null) {
                        nextRecord = queue.peek();
                        if (nextRecord != null && currentElement.compareAndSet(null, nextRecord) && queue.remove(nextRecord)) {
                            this.onReadyToRead(connection);
                        }
                    } else {
                        this.onReadyToRead(connection);
                    }
                    this.intercept(connection, 2, queueRecord, null);
                    queueRecord.recycle();
                    return ReadyFutureImpl.create(currentResult);
                }
                if ((interceptInstructions & 4) != 0) {
                    currentResult.setMessage(null);
                    currentResult.setReadSize(0);
                    queueRecord.setMessage(null);
                }
                SafeFutureImpl<ReadResult<Buffer, SocketAddress>> future = SafeFutureImpl.create();
                queueRecord.setFuture(future);
                currentElement.set(queueRecord);
                this.onReadIncomplete(connection, queueRecord);
                this.onReadyToRead(connection);
                this.intercept(connection, 3, queueRecord, null);
                return future;
            }
            SafeFutureImpl<ReadResult<Buffer, SocketAddress>> future = SafeFutureImpl.create();
            queueRecord.setFuture(future);
            connectionQueue.getQueue().offer(queueRecord);
            if (currentElement.compareAndSet(null, queueRecord) && queue.remove(queueRecord)) {
                this.onReadyToRead(connection);
            }
            if (!connection.isOpen() && queue.remove(queueRecord)) {
                this.onReadFailure(connection, queueRecord, new EOFException("Connection is closed"));
            }
            return future;
        }
        catch (IOException e) {
            this.onReadFailure(connection, queueRecord, e);
            return ReadyFutureImpl.create(e);
        }
    }

    @Override
    public final boolean isReady(Connection connection) {
        TaskQueue<AsyncReadQueueRecord> connectionQueue = ((AbstractNIOConnection)connection).getAsyncReadQueue();
        return connectionQueue != null && (connectionQueue.getCurrentElement() != null || connectionQueue.getQueue() != null && !connectionQueue.getQueue().isEmpty());
    }

    @Override
    public void processAsync(Connection connection) throws IOException {
        TaskQueue<AsyncReadQueueRecord> connectionQueue = ((AbstractNIOConnection)connection).getAsyncReadQueue();
        Queue<AsyncReadQueueRecord> queue = connectionQueue.getQueue();
        AtomicReference<AsyncReadQueueRecord> currentElement = connectionQueue.getCurrentElementAtomic();
        AsyncReadQueueRecord queueRecord = currentElement.get();
        if (queueRecord == LOCK_RECORD) {
            return;
        }
        try {
            while (queueRecord != null) {
                ReadResult currentResult = (ReadResult)queueRecord.getCurrentResult();
                this.doRead(connection, queueRecord);
                Interceptor interceptor = queueRecord.getInterceptor();
                int interceptInstructions = this.intercept(connection, 1, queueRecord, currentResult);
                if ((interceptInstructions & 1) != 0 || interceptor == null && this.isFinished(connection, queueRecord)) {
                    AsyncReadQueueRecord nextRecord = queue.poll();
                    currentElement.set(nextRecord);
                    this.onReadComplete(connection, queueRecord);
                    this.intercept(connection, 2, queueRecord, null);
                    queueRecord.recycle();
                    queueRecord = nextRecord;
                    if (queueRecord != null || (queueRecord = queue.peek()) != null && currentElement.compareAndSet(null, queueRecord) && queue.remove(queueRecord)) continue;
                } else {
                    if ((interceptInstructions & 4) != 0) {
                        currentResult.setMessage(null);
                        currentResult.setReadSize(0);
                        queueRecord.setMessage(null);
                    }
                    this.onReadIncomplete(connection, queueRecord);
                    this.intercept(connection, 3, queueRecord, null);
                    this.onReadyToRead(connection);
                }
                break;
            }
        }
        catch (IOException e) {
            this.onReadFailure(connection, queueRecord, e);
        }
        catch (Exception e) {
            String message = "Unexpected exception occurred in AsyncQueueReader";
            LOGGER.log(Level.SEVERE, message, e);
            IOException ioe = new IOException(e.getClass() + ": " + message);
            this.onReadFailure(connection, queueRecord, ioe);
        }
    }

    @Override
    public void onClose(Connection connection) {
        AbstractNIOConnection nioConnection = (AbstractNIOConnection)connection;
        TaskQueue<AsyncReadQueueRecord> readQueue = nioConnection.getAsyncReadQueue();
        if (readQueue != null) {
            Queue<AsyncReadQueueRecord> recordsQueue;
            AsyncReadQueueRecord record = readQueue.getCurrentElementAtomic().getAndSet(LOCK_RECORD);
            EOFException error = new EOFException("Connection closed");
            if (record != LOCK_RECORD) {
                this.failReadRecord(connection, record, error);
            }
            if ((recordsQueue = readQueue.getQueue()) != null) {
                while ((record = recordsQueue.poll()) != null) {
                    this.failReadRecord(connection, record, error);
                }
            }
        }
    }

    @Override
    public final void close() {
    }

    protected final int doRead(Connection connection, AsyncReadQueueRecord queueRecord) throws IOException {
        ReadResult currentResult;
        Object message = queueRecord.getMessage();
        Buffer buffer = (Buffer)message;
        int readBytes = this.read0(connection, buffer, currentResult = (ReadResult)queueRecord.getCurrentResult());
        if (readBytes == -1) {
            throw new EOFException();
        }
        return readBytes;
    }

    protected final void onReadComplete(Connection connection, AsyncReadQueueRecord record) throws IOException {
        CompletionHandler completionHandler;
        ReadResult currentResult = (ReadResult)record.getCurrentResult();
        FutureImpl future = (FutureImpl)record.getFuture();
        if (future != null) {
            future.result(currentResult);
        }
        if ((completionHandler = record.getCompletionHandler()) != null) {
            completionHandler.completed(currentResult);
        }
    }

    protected final void onReadIncomplete(Connection connection, AsyncReadQueueRecord record) throws IOException {
        ReadResult currentResult = (ReadResult)record.getCurrentResult();
        CompletionHandler completionHandler = record.getCompletionHandler();
        if (completionHandler != null) {
            completionHandler.updated(currentResult);
        }
    }

    protected final void onReadFailure(Connection connection, AsyncReadQueueRecord failedRecord, IOException e) {
        this.failReadRecord(connection, failedRecord, e);
        try {
            connection.close().markForRecycle(true);
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    protected final void failReadRecord(Connection connection, AsyncReadQueueRecord record, Throwable e) {
        boolean hasFuture;
        if (record == null) {
            return;
        }
        FutureImpl future = (FutureImpl)record.getFuture();
        boolean bl = hasFuture = future != null;
        if (!hasFuture || !future.isDone()) {
            CompletionHandler completionHandler = record.getCompletionHandler();
            if (completionHandler != null) {
                completionHandler.failed(e);
            }
            if (hasFuture) {
                future.failure(e);
            }
        }
    }

    private int intercept(Connection connection, int event, AsyncReadQueueRecord asyncQueueRecord, ReadResult currentResult) {
        Interceptor<ReadResult> interceptor = asyncQueueRecord.getInterceptor();
        if (interceptor != null) {
            return interceptor.intercept(event, asyncQueueRecord, currentResult);
        }
        return 0;
    }

    private <E> boolean isFinished(Connection connection, AsyncReadQueueRecord queueRecord) {
        ReadResult readResult = (ReadResult)queueRecord.getCurrentResult();
        Object message = readResult.getMessage();
        return readResult.getReadSize() > 0 || !((Buffer)message).hasRemaining();
    }

    protected abstract int read0(Connection var1, Buffer var2, ReadResult<Buffer, SocketAddress> var3) throws IOException;

    protected abstract void onReadyToRead(Connection var1) throws IOException;
}

