/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.memory.MemoryProbe;
import org.glassfish.grizzly.memory.ProbeNotifier;
import org.glassfish.grizzly.memory.ThreadLocalPool;
import org.glassfish.grizzly.memory.ThreadLocalPoolProvider;
import org.glassfish.grizzly.monitoring.jmx.AbstractJmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.threadpool.DefaultWorkerThread;

public abstract class AbstractMemoryManager<E extends Buffer>
implements MemoryManager<E>,
ThreadLocalPoolProvider {
    public static final int DEFAULT_MAX_BUFFER_SIZE = 131072;
    public static final int DEFAULT_SMALL_BUFFER_SIZE = 32;
    protected final AbstractJmxMonitoringConfig<MemoryProbe> monitoringConfig = new AbstractJmxMonitoringConfig<MemoryProbe>(MemoryProbe.class){

        @Override
        public JmxObject createManagementObject() {
            return AbstractMemoryManager.this.createJmxManagementObject();
        }
    };
    protected final int maxBufferSize;
    protected final int smallBufferSize;

    public AbstractMemoryManager() {
        this(131072, 32);
    }

    public AbstractMemoryManager(int maxBufferSize, int smallBufferSize) {
        this.maxBufferSize = maxBufferSize;
        this.smallBufferSize = smallBufferSize;
    }

    public int getReadyThreadBufferSize() {
        ThreadLocalPool threadLocalPool = AbstractMemoryManager.getThreadLocalPool();
        if (threadLocalPool != null) {
            return threadLocalPool.remaining();
        }
        return 0;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public int getSmallBufferSize() {
        return this.smallBufferSize;
    }

    protected Object allocateFromPool(ThreadLocalPool threadLocalCache, int size) {
        if (threadLocalCache.remaining() >= size) {
            ProbeNotifier.notifyBufferAllocatedFromPool(this.monitoringConfig, size);
            return threadLocalCache.allocate(size);
        }
        return null;
    }

    protected abstract JmxObject createJmxManagementObject();

    protected static ThreadLocalPool getThreadLocalPool() {
        Thread t = Thread.currentThread();
        if (t instanceof DefaultWorkerThread) {
            return ((DefaultWorkerThread)t).getMemoryPool();
        }
        return null;
    }

    protected abstract SmallBuffer createSmallBuffer();

    protected static interface TrimAware
    extends Cacheable {
    }

    protected static interface SmallBuffer
    extends Cacheable {
    }
}

