/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.attributes;

import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.attributes.IndexedAttributeAccessor;
import org.glassfish.grizzly.attributes.NullaryFunction;

public final class Attribute<T> {
    private final AttributeBuilder builder;
    private final String name;
    private final NullaryFunction<T> initializer;
    private final T defaultValue;
    private final int attributeIndex;

    public String toString() {
        return "Attribute[" + this.name + ":" + this.attributeIndex + "]";
    }

    protected Attribute(AttributeBuilder builder, String name, int index, T defaultValue) {
        this.builder = builder;
        this.name = name;
        this.attributeIndex = index;
        this.initializer = null;
        this.defaultValue = defaultValue;
    }

    protected Attribute(AttributeBuilder builder, String name, int index, NullaryFunction<T> initializer) {
        this.builder = builder;
        this.name = name;
        this.attributeIndex = index;
        this.initializer = initializer;
        this.defaultValue = null;
    }

    public T peek(AttributeHolder attributeHolder) {
        return this.weakGet(attributeHolder);
    }

    public T peek(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return this.peek(holder);
        }
        return null;
    }

    public T get(AttributeHolder attributeHolder) {
        T result = this.weakGet(attributeHolder);
        if (result == null && (result = this.initializer != null ? this.initializer.evaluate() : this.defaultValue) != null) {
            this.set(attributeHolder, result);
        }
        return result;
    }

    public T get(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return this.get(holder);
        }
        T result = this.initializer != null ? this.initializer.evaluate() : this.defaultValue;
        if (result != null) {
            this.set(storage, result);
        }
        return result;
    }

    public void set(AttributeHolder attributeHolder, T value) {
        IndexedAttributeAccessor indexedAccessor = attributeHolder.getIndexedAttributeAccessor();
        if (indexedAccessor != null) {
            indexedAccessor.setAttribute(this.attributeIndex, value);
        } else {
            attributeHolder.setAttribute(this.name, value);
        }
    }

    public void set(AttributeStorage storage, T value) {
        this.set(storage.getAttributes(), value);
    }

    public T remove(AttributeHolder attributeHolder) {
        T result = this.weakGet(attributeHolder);
        if (result != null) {
            this.set(attributeHolder, null);
        }
        return result;
    }

    public T remove(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return this.remove(holder);
        }
        return null;
    }

    public boolean isSet(AttributeHolder attributeHolder) {
        return this.weakGet(attributeHolder) != null;
    }

    public boolean isSet(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return this.isSet(holder);
        }
        return false;
    }

    public String name() {
        return this.name;
    }

    public int index() {
        return this.attributeIndex;
    }

    private T weakGet(AttributeHolder attributeHolder) {
        IndexedAttributeAccessor indexedAccessor = attributeHolder.getIndexedAttributeAccessor();
        Object result = indexedAccessor != null ? indexedAccessor.getAttribute(this.attributeIndex) : attributeHolder.getAttribute(this.name);
        return (T)result;
    }
}

