/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.grizzly.utils.LinkedTransferQueue;

public abstract class TaskQueue<E> {
    private static final AtomicReferenceFieldUpdater<QueueMonitor, Boolean> MONITOR = AtomicReferenceFieldUpdater.newUpdater(QueueMonitor.class, Boolean.class, "invalid");
    protected final Queue<E> queue;
    protected final Queue<QueueMonitor> monitorQueue;

    protected TaskQueue(Queue<E> queue) {
        this.queue = queue;
        this.monitorQueue = new ConcurrentLinkedQueue<QueueMonitor>();
    }

    public static <E> TaskQueue<E> createSafeTaskQueue() {
        return new SafeTaskQueue();
    }

    public static <E> TaskQueue<E> createUnSafeTaskQueue() {
        return new UnSafeTaskQueue();
    }

    public abstract int reserveSpace(int var1);

    public abstract int releaseSpace(int var1, boolean var2);

    public abstract int spaceInBytes();

    public abstract E getCurrentElement();

    public abstract AtomicReference<E> getCurrentElementAtomic();

    public Queue<E> getQueue() {
        return this.queue;
    }

    public boolean addQueueMonitor(QueueMonitor monitor) {
        if (monitor.shouldNotify()) {
            monitor.onNotify();
            return false;
        }
        this.monitorQueue.offer(monitor);
        return true;
    }

    public void removeQueueMonitor(QueueMonitor monitor) {
        this.monitorQueue.remove(monitor);
    }

    protected void doNotify() {
        if (!this.monitorQueue.isEmpty()) {
            Iterator i = this.monitorQueue.iterator();
            while (i.hasNext()) {
                QueueMonitor m = (QueueMonitor)i.next();
                if (!MONITOR.get(m).booleanValue()) {
                    if (!m.shouldNotify() || !MONITOR.compareAndSet(m, Boolean.FALSE, Boolean.TRUE)) continue;
                    m.onNotify();
                    continue;
                }
                i.remove();
            }
        }
    }

    public static abstract class QueueMonitor {
        volatile Boolean invalid = Boolean.FALSE;

        public abstract void onNotify();

        public abstract boolean shouldNotify();
    }

    public static final class UnSafeTaskQueue<E>
    extends TaskQueue<E> {
        private E currentElement;
        private int spaceInBytes;
        protected final ReentrantLock queuedActionLock = new ReentrantLock();

        protected UnSafeTaskQueue() {
            super(new LinkedList());
        }

        @Override
        public E getCurrentElement() {
            return this.currentElement;
        }

        @Override
        public AtomicReference<E> getCurrentElementAtomic() {
            throw new UnsupportedOperationException("Is not supported for unsafe queue");
        }

        public ReentrantLock getQueuedActionLock() {
            return this.queuedActionLock;
        }

        @Override
        public int reserveSpace(int amount) {
            this.spaceInBytes += amount;
            return this.spaceInBytes;
        }

        @Override
        public int releaseSpace(int amount, boolean notify) {
            this.spaceInBytes -= amount;
            if (notify) {
                this.doNotify();
            }
            return this.spaceInBytes;
        }

        @Override
        public int spaceInBytes() {
            return this.spaceInBytes;
        }
    }

    public static final class SafeTaskQueue<E>
    extends TaskQueue<E> {
        final AtomicReference<E> currentElement;
        final AtomicInteger spaceInBytes = new AtomicInteger();

        protected SafeTaskQueue() {
            super(new LinkedTransferQueue());
            this.currentElement = new AtomicReference();
        }

        @Override
        public E getCurrentElement() {
            return this.currentElement.get();
        }

        @Override
        public AtomicReference<E> getCurrentElementAtomic() {
            return this.currentElement;
        }

        @Override
        public int reserveSpace(int amount) {
            return this.spaceInBytes.addAndGet(amount);
        }

        @Override
        public int releaseSpace(int amount, boolean notify) {
            int space = this.spaceInBytes.addAndGet(-amount);
            if (notify) {
                this.doNotify();
            }
            return space;
        }

        @Override
        public int spaceInBytes() {
            return this.spaceInBytes.get();
        }
    }
}

