/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Result;
import org.glassfish.grizzly.ThreadCache;

public final class WriteResult<K, L>
implements Result,
Cacheable {
    private static final ThreadCache.CachedTypeIndex<WriteResult> CACHE_IDX = ThreadCache.obtainIndex(WriteResult.class, 4);
    private boolean isRecycled = false;
    private Connection connection;
    private K message;
    private L dstAddress;
    private int writtenSize;

    public static WriteResult create(Connection connection) {
        WriteResult writeResult = ThreadCache.takeFromCache(CACHE_IDX);
        if (writeResult != null) {
            writeResult.connection = connection;
            writeResult.isRecycled = false;
            return writeResult;
        }
        return new WriteResult(connection);
    }

    public static <K, L> WriteResult create(Connection connection, K message, L dstAddress, int writeSize) {
        WriteResult writeResult = ThreadCache.takeFromCache(CACHE_IDX);
        if (writeResult != null) {
            writeResult.connection = connection;
            writeResult.message = message;
            writeResult.dstAddress = dstAddress;
            writeResult.writtenSize = writeSize;
            writeResult.isRecycled = false;
            return writeResult;
        }
        return new WriteResult<K, L>(connection, message, dstAddress, writeSize);
    }

    private WriteResult(Connection connection) {
        this(connection, null, null, 0);
    }

    private WriteResult(Connection connection, K message, L dstAddress, int writeSize) {
        this.connection = connection;
        this.message = message;
        this.dstAddress = dstAddress;
        this.writtenSize = writeSize;
    }

    @Override
    public final Connection getConnection() {
        this.checkRecycled();
        return this.connection;
    }

    public final K getMessage() {
        this.checkRecycled();
        return this.message;
    }

    public final void setMessage(K message) {
        this.checkRecycled();
        this.message = message;
    }

    public final L getDstAddress() {
        this.checkRecycled();
        return this.dstAddress;
    }

    public final void setDstAddress(L dstAddress) {
        this.checkRecycled();
        this.dstAddress = dstAddress;
    }

    public final int getWrittenSize() {
        this.checkRecycled();
        return this.writtenSize;
    }

    public final void setWrittenSize(int writeSize) {
        this.checkRecycled();
        this.writtenSize = writeSize;
    }

    private void checkRecycled() {
        if (Grizzly.isTrackingThreadCache() && this.isRecycled) {
            throw new IllegalStateException("ReadResult has been recycled!");
        }
    }

    private void reset() {
        this.connection = null;
        this.message = null;
        this.dstAddress = null;
        this.writtenSize = 0;
    }

    @Override
    public void recycle() {
        this.reset();
        this.isRecycled = true;
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

