/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Result;
import org.glassfish.grizzly.ThreadCache;

public class ReadResult<K, L>
implements Result,
Cacheable {
    private static final ThreadCache.CachedTypeIndex<ReadResult> CACHE_IDX = ThreadCache.obtainIndex(ReadResult.class, 4);
    private boolean isRecycled = false;
    private Connection connection;
    private K message;
    private L srcAddress;
    private int readSize;

    public static ReadResult create(Connection connection) {
        ReadResult readResult = ThreadCache.takeFromCache(CACHE_IDX);
        if (readResult != null) {
            readResult.connection = connection;
            readResult.isRecycled = false;
            return readResult;
        }
        return new ReadResult(connection);
    }

    public static <K, L> ReadResult create(Connection connection, K message, L srcAddress, int readSize) {
        ReadResult readResult = ThreadCache.takeFromCache(CACHE_IDX);
        if (readResult != null) {
            readResult.connection = connection;
            readResult.message = message;
            readResult.srcAddress = srcAddress;
            readResult.readSize = readSize;
            readResult.isRecycled = false;
            return readResult;
        }
        return new ReadResult<K, L>(connection, message, srcAddress, readSize);
    }

    protected ReadResult(Connection connection) {
        this(connection, null, null, 0);
    }

    protected ReadResult(Connection connection, K message, L srcAddress, int readSize) {
        this.connection = connection;
        this.message = message;
        this.srcAddress = srcAddress;
        this.readSize = readSize;
    }

    @Override
    public final Connection getConnection() {
        this.checkRecycled();
        return this.connection;
    }

    public final K getMessage() {
        this.checkRecycled();
        return this.message;
    }

    public final void setMessage(K message) {
        this.checkRecycled();
        this.message = message;
    }

    public final L getSrcAddress() {
        this.checkRecycled();
        return this.srcAddress;
    }

    public final void setSrcAddress(L srcAddress) {
        this.checkRecycled();
        this.srcAddress = srcAddress;
    }

    public final int getReadSize() {
        this.checkRecycled();
        return this.readSize;
    }

    public final void setReadSize(int readSize) {
        this.checkRecycled();
        this.readSize = readSize;
    }

    private void reset() {
        this.connection = null;
        this.message = null;
        this.srcAddress = null;
        this.readSize = 0;
    }

    private void checkRecycled() {
        if (Grizzly.isTrackingThreadCache() && this.isRecycled) {
            throw new IllegalStateException("ReadResult has been recycled!");
        }
    }

    @Override
    public void recycle() {
        this.reset();
        this.isRecycled = true;
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

