/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.util.logging.Logger;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.PostProcessor;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorResult;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.attributes.IndexedAttributeHolder;

public class Context
implements AttributeStorage,
Cacheable {
    private static final Logger LOGGER = Grizzly.logger(Context.class);
    private static final Processor NULL_PROCESSOR = new NullProcessor();
    private static final ThreadCache.CachedTypeIndex<Context> CACHE_IDX = ThreadCache.obtainIndex(Context.class, 4);
    private Connection connection;
    private IOEvent ioEvent = IOEvent.NONE;
    private Processor processor;
    private final AttributeHolder attributes = new IndexedAttributeHolder(Grizzly.DEFAULT_ATTRIBUTE_BUILDER);
    private PostProcessor postProcessor;

    public static Context create(Connection connection) {
        Context context = ThreadCache.takeFromCache(CACHE_IDX);
        if (context == null) {
            context = new Context();
        }
        context.setConnection(connection);
        return context;
    }

    public static Context create(Connection connection, Processor processor, IOEvent ioEvent) {
        Object context = processor != null ? processor.obtainContext(connection) : NULL_PROCESSOR.obtainContext(connection);
        ((Context)context).setIoEvent(ioEvent);
        return context;
    }

    public IOEvent getIoEvent() {
        return this.ioEvent;
    }

    public void setIoEvent(IOEvent ioEvent) {
        this.ioEvent = ioEvent;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public PostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public void setPostProcessor(PostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    public void reset() {
        this.attributes.recycle();
        this.processor = null;
        this.postProcessor = null;
        this.connection = null;
        this.ioEvent = IOEvent.NONE;
    }

    @Override
    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    private static final class NullProcessor
    implements Processor {
        private NullProcessor() {
        }

        public Context obtainContext(Connection connection) {
            Context context = Context.create(connection);
            context.setProcessor(this);
            return context;
        }

        public ProcessorResult process(Context context) throws IOException {
            return ProcessorResult.createNotRun();
        }

        public GrizzlyFuture read(Connection connection, CompletionHandler completionHandler) throws IOException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public GrizzlyFuture write(Connection connection, Object dstAddress, Object message, CompletionHandler completionHandler) throws IOException {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean isInterested(IOEvent ioEvent) {
            return true;
        }

        @Override
        public void setInterested(IOEvent ioEvent, boolean isInterested) {
        }
    }
}

